/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.AttributeComparator;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyEntryAsAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.eclipse.jface.resource.ImageDescriptor;

public class CopyEntryAsLdifAction
extends CopyEntryAsAction {
    public CopyEntryAsLdifAction(int mode) {
        super(Messages.getString("CopyEntryAsLdifAction.LDIF"), mode);
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.mode == 1) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_ldif.gif");
        }
        if (this.mode == 2) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_ldif_searchresult.gif");
        }
        if (this.mode == 4) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_ldif_operational.gif");
        }
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_ldif_user.gif");
    }

    public void serialializeEntries(IEntry[] entries, StringBuffer text) {
        String lineSeparator = BrowserCorePlugin.getDefault().getPluginPreferences().getString("ldifLineSeparator");
        HashSet<String> returningAttributesSet = null;
        if (this.mode == 2 && this.getSelectedSearchResults().length > 0 && this.getSelectedEntries().length + this.getSelectedBookmarks().length + this.getSelectedSearches().length == 0) {
            returningAttributesSet = new HashSet<String>(Arrays.asList(this.getSelectedSearchResults()[0].getSearch().getReturningAttributes()));
        } else if (this.mode == 2 && this.getSelectedSearches().length == 1) {
            returningAttributesSet = new HashSet<String>(Arrays.asList(this.getSelectedSearches()[0].getReturningAttributes()));
        }
        for (int e = 0; entries != null && e < entries.length; ++e) {
            this.serializeDn(entries[e].getDn(), text);
            if (this.mode != 1) {
                ArrayList<IValue> valueList = new ArrayList<IValue>();
                IAttribute[] attributes = entries[e].getAttributes();
                if (attributes != null) {
                    for (int i = 0; i < attributes.length; ++i) {
                        if (returningAttributesSet != null && !returningAttributesSet.contains(attributes[i].getType()) || attributes[i].isOperationalAttribute() && this.mode != 4) continue;
                        IValue[] values = attributes[i].getValues();
                        for (int k = 0; k < values.length; ++k) {
                            valueList.add(values[k]);
                        }
                    }
                }
                IValue[] values = valueList.toArray(new IValue[valueList.size()]);
                AttributeComparator comparator = new AttributeComparator(entries[e]);
                Arrays.sort(values, comparator);
                for (int i = 0; i < values.length; ++i) {
                    this.serializeValue(values[i], text);
                }
            }
            if (e >= entries.length) continue;
            text.append(lineSeparator);
        }
    }

    protected void serializeValue(IValue value, StringBuffer text) {
        text.append(ModelConverter.valueToLdifAttrValLine((IValue)value).toFormattedString(Utils.getLdifFormatParameters()));
    }

    protected void serializeDn(LdapDN dn, StringBuffer text) {
        text.append(ModelConverter.dnToLdifDnLine((LdapDN)dn).toFormattedString(Utils.getLdifFormatParameters()));
    }
}

