/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.AttributeComparator;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyEntryAsAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.eclipse.jface.resource.ImageDescriptor;

public class CopyEntryAsCsvAction
extends CopyEntryAsAction {
    public static final int MODE_TABLE = 5;

    public CopyEntryAsCsvAction(int mode) {
        super(Messages.getString("CopyEntryAsCsvAction.CSV"), mode);
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.mode == 1) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_csv.gif");
        }
        if (this.mode == 2) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_csv_searchresult.gif");
        }
        if (this.mode == 4) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_csv_operational.gif");
        }
        if (this.mode == 3) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_csv_user.gif");
        }
        if (this.mode == 5) {
            return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_table.gif");
        }
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_csv.gif");
    }

    public String getText() {
        if (this.mode == 5) {
            return Messages.getString("CopyEntryAsCsvAction.CopyTable");
        }
        return super.getText();
    }

    public boolean isEnabled() {
        if (this.mode == 5) {
            return this.getInput() != null && this.getInput() instanceof ISearch && ((ISearch)this.getInput()).getSearchResults() != null && ((ISearch)this.getInput()).getSearchResults().length > 0;
        }
        return super.isEnabled();
    }

    public void run() {
        if (this.mode == 5) {
            if (this.getInput() != null && this.getInput() instanceof ISearch && ((ISearch)this.getInput()).getSearchResults() != null && ((ISearch)this.getInput()).getSearchResults().length > 0) {
                ArrayList<IEntry> entryList = new ArrayList<IEntry>();
                ISearchResult[] results = ((ISearch)this.getInput()).getSearchResults();
                for (int k = 0; k < results.length; ++k) {
                    entryList.add(results[k].getEntry());
                }
                IEntry[] entries = entryList.toArray(new IEntry[entryList.size()]);
                StringBuffer text = new StringBuffer();
                this.serialializeEntries(entries, text);
                this.copyToClipboard(text.toString());
            }
        } else {
            super.run();
        }
    }

    public void serialializeEntries(IEntry[] entries, StringBuffer text) {
        String attributeDelimiter = BrowserCommonActivator.getDefault().getPreferenceStore().getString("formatTableAttributeDelimiter");
        String valueDelimiter = BrowserCommonActivator.getDefault().getPreferenceStore().getString("formatTableValueDelimiter");
        String quoteCharacter = BrowserCommonActivator.getDefault().getPreferenceStore().getString("formatTableQuoteCharacter");
        String lineSeparator = BrowserCommonActivator.getDefault().getPreferenceStore().getString("formatTableLineSeparator");
        int binaryEncoding = BrowserCommonActivator.getDefault().getPreferenceStore().getInt("formatTableBinaryEncoding");
        String[] returningAttributes = null;
        if (this.mode == 1) {
            returningAttributes = new String[]{};
        } else if (this.mode == 2 && this.getSelectedSearchResults().length > 0 && this.getSelectedEntries().length + this.getSelectedBookmarks().length + this.getSelectedSearches().length == 0) {
            returningAttributes = this.getSelectedSearchResults()[0].getSearch().getReturningAttributes();
        } else if ((this.mode == 2 || this.mode == 5) && this.getSelectedSearches().length == 1) {
            returningAttributes = this.getSelectedSearches()[0].getReturningAttributes();
        } else if ((this.mode == 2 || this.mode == 5) && this.getInput() instanceof ISearch) {
            returningAttributes = ((ISearch)this.getInput()).getReturningAttributes();
        } else {
            HashMap<String, IAttribute> attributeMap = new HashMap<String, IAttribute>();
            for (int e = 0; entries != null && e < entries.length; ++e) {
                IAttribute[] attributes = entries[e].getAttributes();
                for (int a = 0; attributes != null && a < attributes.length; ++a) {
                    if (attributes[a].isOperationalAttribute() && this.mode != 4 || attributeMap.containsKey(attributes[a].getDescription())) continue;
                    attributeMap.put(attributes[a].getDescription(), attributes[a]);
                }
            }
            IAttribute[] attributes = attributeMap.values().toArray(new IAttribute[attributeMap.size()]);
            if (attributes.length > 0) {
                AttributeComparator comparator = new AttributeComparator(entries[0]);
                Arrays.sort(attributes, comparator);
            }
            returningAttributes = new String[attributes.length];
            for (int i = 0; i < attributes.length; ++i) {
                returningAttributes[i] = attributes[i].getDescription();
            }
        }
        if (this.mode != 5 || BrowserUIPlugin.getDefault().getPreferenceStore().getBoolean("searchResultEditorShowDn")) {
            text.append(quoteCharacter);
            text.append("DN");
            text.append(quoteCharacter);
            text.append(attributeDelimiter);
        }
        for (int a = 0; returningAttributes != null && a < returningAttributes.length; ++a) {
            text.append(quoteCharacter);
            text.append(returningAttributes[a]);
            text.append(quoteCharacter);
            if (a + 1 >= returningAttributes.length) continue;
            text.append(attributeDelimiter);
        }
        text.append(lineSeparator);
        for (int e = 0; entries != null && e < entries.length; ++e) {
            if (this.mode != 5 || BrowserUIPlugin.getDefault().getPreferenceStore().getBoolean("searchResultEditorShowDn")) {
                text.append(quoteCharacter);
                text.append(entries[e].getDn().getUpName());
                text.append(quoteCharacter);
                text.append(attributeDelimiter);
            }
            for (int a = 0; returningAttributes != null && a < returningAttributes.length; ++a) {
                AttributeComparator comparator = new AttributeComparator(entries[e]);
                AttributeHierarchy ah = entries[e].getAttributeWithSubtypes(returningAttributes[a]);
                if (ah != null) {
                    StringBuffer valueSB = new StringBuffer();
                    Iterator it = ah.iterator();
                    while (it.hasNext()) {
                        IAttribute attribute = (IAttribute)it.next();
                        if (attribute != null) {
                            IValue[] values = attribute.getValues();
                            Arrays.sort(values, comparator);
                            for (int v = 0; v < values.length; ++v) {
                                String val = ModelConverter.getStringValue((IValue)values[v], (int)binaryEncoding);
                                valueSB.append(val);
                                if (v + 1 >= values.length) continue;
                                valueSB.append(valueDelimiter);
                            }
                        }
                        if (!it.hasNext()) continue;
                        valueSB.append(valueDelimiter);
                    }
                    String value = valueSB.toString().replaceAll(quoteCharacter, quoteCharacter + quoteCharacter);
                    text.append(quoteCharacter);
                    text.append(value);
                    text.append(quoteCharacter);
                }
                if (a + 1 >= returningAttributes.length) continue;
                text.append(attributeDelimiter);
            }
            if (e >= entries.length) continue;
            text.append(lineSeparator);
        }
    }
}

