/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.CopyAction;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class CopyDnAction
extends BrowserAction {
    public void run() {
        String dn = null;
        if (this.getSelectedEntries().length > 0) {
            dn = this.getSelectedEntries()[0].getDn().getUpName();
        } else if (this.getSelectedAttributes().length > 0) {
            dn = this.getSelectedAttributes()[0].getEntry().getDn().getUpName();
        } else if (this.getSelectedAttributeHierarchies().length > 0) {
            dn = this.getSelectedAttributeHierarchies()[0].getAttribute().getEntry().getDn().getUpName();
        } else if (this.getSelectedValues().length > 0) {
            dn = this.getSelectedValues()[0].getAttribute().getEntry().getDn().getUpName();
        } else if (this.getSelectedSearchResults().length > 0) {
            dn = this.getSelectedSearchResults()[0].getDn().getUpName();
        } else if (this.getSelectedBookmarks().length > 0) {
            dn = this.getSelectedBookmarks()[0].getDn().getUpName();
        }
        if (dn != null) {
            CopyAction.copyToClipboard((Object[])new Object[]{dn}, (Transfer[])new Transfer[]{TextTransfer.getInstance()});
        }
    }

    public String getText() {
        return Messages.getString("CopyDnAction.CopyDN");
    }

    public ImageDescriptor getImageDescriptor() {
        return BrowserUIPlugin.getDefault().getImageDescriptor("resources/icons/copy_dn.gif");
    }

    public String getCommandId() {
        return null;
    }

    public boolean isEnabled() {
        return this.getSelectedEntries().length + this.getSelectedSearchResults().length + this.getSelectedBookmarks().length == 1 || this.getSelectedAttributes().length + this.getSelectedValues().length > 0;
    }
}

