/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonConstants;
import org.apache.directory.studio.ldapbrowser.common.actions.PasteAction;
import org.apache.directory.studio.ldapbrowser.common.dialogs.EntryExistsCopyStrategyDialogImpl;
import org.apache.directory.studio.ldapbrowser.common.dialogs.ScopeDialog;
import org.apache.directory.studio.ldapbrowser.common.dnd.EntryTransfer;
import org.apache.directory.studio.ldapbrowser.common.dnd.SearchTransfer;
import org.apache.directory.studio.ldapbrowser.common.dnd.ValuesTransfer;
import org.apache.directory.studio.ldapbrowser.core.jobs.CopyEntriesJob;
import org.apache.directory.studio.ldapbrowser.core.jobs.EntryExistsCopyStrategyDialog;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.jobs.UpdateEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Search;
import org.apache.directory.studio.ldapbrowser.core.utils.CompoundModification;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class BrowserPasteAction
extends PasteAction {
    public String getText() {
        IEntry[] entries = this.getEntriesToPaste();
        if (entries != null) {
            return entries.length > 1 ? Messages.getString("BrowserPasteAction.PasteEntries") : Messages.getString("BrowserPasteAction.PasteEntry");
        }
        ISearch[] searches = this.getSearchesToPaste();
        if (searches != null) {
            return searches.length > 1 ? Messages.getString("BrowserPasteAction.PasteSearches") : Messages.getString("BrowserPasteAction.PasteSearch");
        }
        IValue[] values = this.getValuesToPaste();
        if (values != null) {
            return values.length > 1 ? Messages.getString("BrowserPasteAction.PasteValues") : Messages.getString("BrowserPasteAction.PasteValue");
        }
        return Messages.getString("BrowserPasteAction.Paste");
    }

    public boolean isEnabled() {
        if (this.getEntriesToPaste() != null) {
            return true;
        }
        if (this.getSearchesToPaste() != null) {
            return true;
        }
        return this.getValuesToPaste() != null;
    }

    public void run() {
        IEntry[] entries = this.getEntriesToPaste();
        if (entries != null) {
            this.pasteEntries(this.getSelectedEntries()[0], entries);
            return;
        }
        ISearch[] searches = this.getSearchesToPaste();
        if (searches != null) {
            this.pasteSearches(searches);
            return;
        }
        IValue[] values = this.getValuesToPaste();
        if (values != null) {
            this.pasteValues(values);
            return;
        }
    }

    private void pasteEntries(IEntry parent, IEntry[] entriesToPaste) {
        ISearch.SearchScope scope = ISearch.SearchScope.OBJECT;
        boolean askForScope = false;
        for (int i = 0; i < entriesToPaste.length; ++i) {
            if (!entriesToPaste[i].hasChildren()) continue;
            askForScope = true;
            break;
        }
        if (askForScope) {
            ScopeDialog scopeDialog = new ScopeDialog(Display.getDefault().getActiveShell(), Messages.getString("BrowserPasteAction.SelectCopyDepth"), entriesToPaste.length > 1);
            scopeDialog.open();
            scope = scopeDialog.getScope();
        }
        new CopyEntriesJob(parent, entriesToPaste, scope, (EntryExistsCopyStrategyDialog)new EntryExistsCopyStrategyDialogImpl(Display.getDefault().getActiveShell())).execute();
    }

    private void pasteSearches(ISearch[] searches) {
        IBrowserConnection browserConnection = null;
        if (this.getSelectedBrowserViewCategories().length > 0) {
            browserConnection = this.getSelectedBrowserViewCategories()[0].getParent();
        } else if (this.getSelectedSearches().length > 0) {
            browserConnection = this.getSelectedSearches()[0].getBrowserConnection();
        }
        if (browserConnection != null) {
            Search clone = null;
            for (ISearch search : searches) {
                SearchParameter searchParameter = (SearchParameter)search.getSearchParameter().clone();
                clone = new Search(browserConnection, searchParameter);
                browserConnection.getSearchManager().addSearch((ISearch)clone);
            }
            if (searches.length == 1) {
                Search element = clone;
                String pageId = BrowserCommonConstants.PROP_SEARCH;
                String title = clone.getName();
                PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)element, (String)pageId, null, null);
                if (dialog != null) {
                    title = Utils.shorten((String)title, (int)30);
                }
                dialog.getShell().setText(NLS.bind((String)Messages.getString("PropertiesAction.PropertiesForX"), (Object)title));
                dialog.open();
            }
        }
    }

    private void pasteValues(IValue[] values) {
        IEntry entry = null;
        if (this.getSelectedEntries().length == 1) {
            entry = this.getSelectedEntries()[0];
        } else if (this.getSelectedSearchResults().length == 1) {
            entry = this.getSelectedSearchResults()[0].getEntry();
        } else if (this.getSelectedBookmarks().length == 1) {
            entry = this.getSelectedBookmarks()[0].getEntry();
        }
        if (entry != null) {
            entry = entry.getBrowserConnection().getEntryFromCache(entry.getDn());
        }
        if (entry != null) {
            IEntry clone = new CompoundModification().cloneEntry(entry);
            new CompoundModification().createValues(clone, values);
            LdifFile diff = org.apache.directory.studio.ldapbrowser.core.utils.Utils.computeDiff((IEntry)entry, (IEntry)clone);
            if (diff != null) {
                UpdateEntryRunnable runnable = new UpdateEntryRunnable(entry, diff.toFormattedString(LdifFormatParameters.DEFAULT));
                new StudioBrowserJob(new StudioRunnableWithProgress[]{runnable}).execute();
            }
        }
    }

    private IEntry[] getEntriesToPaste() {
        Object content;
        if (this.getSelectedBookmarks().length + this.getSelectedSearchResults().length + this.getSelectedSearches().length + this.getSelectedConnections().length + this.getSelectedAttributes().length + this.getSelectedValues().length == 0 && this.getSelectedEntries().length == 1 && (content = this.getFromClipboard((Transfer)EntryTransfer.getInstance())) != null && content instanceof IEntry[]) {
            IEntry[] entries = (IEntry[])content;
            return entries;
        }
        return null;
    }

    private ISearch[] getSearchesToPaste() {
        Object content;
        if (this.getSelectedBookmarks().length + this.getSelectedSearchResults().length + this.getSelectedEntries().length + this.getSelectedConnections().length + this.getSelectedAttributes().length + this.getSelectedValues().length == 0 && this.getSelectedSearches().length + this.getSelectedBrowserViewCategories().length > 0 && (content = this.getFromClipboard((Transfer)SearchTransfer.getInstance())) != null && content instanceof ISearch[]) {
            ISearch[] searches = (ISearch[])content;
            return searches;
        }
        return null;
    }

    private IValue[] getValuesToPaste() {
        Object content;
        if ((this.getSelectedAttributes().length + this.getSelectedValues().length + this.getSelectedSearchResults().length + this.getSelectedBookmarks().length + this.getSelectedSearches().length + this.getSelectedConnections().length == 0 && this.getSelectedEntries().length == 1 || this.getSelectedAttributes().length + this.getSelectedValues().length + this.getSelectedEntries().length + this.getSelectedSearchResults().length + this.getSelectedSearches().length + this.getSelectedConnections().length == 0 && this.getSelectedBookmarks().length == 1 || this.getSelectedAttributes().length + this.getSelectedValues().length + this.getSelectedEntries().length + this.getSelectedBookmarks().length + this.getSelectedSearches().length + this.getSelectedConnections().length == 0 && this.getSelectedSearchResults().length == 1) && (content = this.getFromClipboard((Transfer)ValuesTransfer.getInstance())) != null && content instanceof IValue[]) {
            IValue[] values = (IValue[])content;
            return values;
        }
        return null;
    }
}

