/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.internal.base.remote.DefaultPreferenceFileHandler;
import org.eclipse.help.internal.base.remote.PreferenceFileHandler;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.base.remote.RemoteIC;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.preferences.HelpContentBlock;
import org.eclipse.help.ui.internal.preferences.InfocenterDisplay;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class HelpContentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private InfocenterDisplay remoteICPage;
    private Button checkbox;
    private Label descLabel;
    private Listener changeListener = new Listener(){

        public void handleEvent(Event event) {
            HelpContentBlock currentBlock = HelpContentPreferencePage.this.remoteICPage.getHelpContentBlock();
            boolean isRemoteHelpEnabled = HelpContentPreferencePage.this.checkbox.getSelection();
            if (isRemoteHelpEnabled) {
                currentBlock.restoreDefaultButtons();
            } else {
                currentBlock.disableAllButtons();
            }
            currentBlock.getRemoteICviewer().getTable().setEnabled(isRemoteHelpEnabled);
        }
    };

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.prefPageHelpContent");
        this.initializeDialogUnits((Control)parent);
        this.createCheckbox(parent);
        this.descLabel = new Label(parent, 0);
        this.descLabel.setText(Messages.HelpContentPage_title);
        Dialog.applyDialogFont((Control)this.descLabel);
        this.remoteICPage = new InfocenterDisplay(this);
        this.remoteICPage.createContents(parent);
        this.initializeTableEnablement(this.checkbox.getSelection());
        return parent;
    }

    protected void performDefaults() {
        super.performDefaults();
        HelpContentBlock currentBlock = this.remoteICPage.getHelpContentBlock();
        currentBlock.getRemoteICviewer().getRemoteICList().removeAllRemoteICs(currentBlock.getRemoteICList());
        currentBlock.getRemoteICviewer().getRemoteICList().loadDefaultPreferences();
        currentBlock.restoreDefaultButtons();
        this.checkbox.setSelection(new DefaultPreferenceFileHandler().isRemoteHelpOn());
        this.changeListener.handleEvent(null);
    }

    public boolean performOk() {
        InstanceScope instanceScope = new InstanceScope();
        IEclipsePreferences prefs = instanceScope.getNode("org.eclipse.help.base");
        prefs.putBoolean("remoteHelpOn", this.checkbox.getSelection());
        HelpContentBlock currentBlock = this.remoteICPage.getHelpContentBlock();
        RemoteIC[] currentRemoteICArray = currentBlock.getRemoteICList();
        PreferenceFileHandler.commitRemoteICs((RemoteIC[])currentRemoteICArray);
        RemoteHelp.notifyPreferenceChange();
        return super.performOk();
    }

    protected GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    private void createCheckbox(Composite parent) {
        this.checkbox = new Button(parent, 32);
        this.checkbox.setText(Messages.HelpContentPreferencePage_remote);
        this.checkbox.addListener(13, this.changeListener);
        boolean isOn = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "remoteHelpOn", false, null);
        this.checkbox.setSelection(isOn);
        Dialog.applyDialogFont((Control)this.checkbox);
    }

    private void initializeTableEnablement(boolean isRemoteHelpEnabled) {
        HelpContentBlock currentBlock = this.remoteICPage.getHelpContentBlock();
        if (isRemoteHelpEnabled) {
            currentBlock.restoreDefaultButtons();
        } else {
            currentBlock.disableAllButtons();
        }
        currentBlock.getRemoteICviewer().getTable().setEnabled(isRemoteHelpEnabled);
    }
}

