/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.navigator.CommonNavigatorActionGroup;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.navigator.CommonNavigatorManager;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorFilterService;
import org.eclipse.ui.navigator.LinkHelperService;
import org.eclipse.ui.navigator.NavigatorActionService;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class CommonNavigator
extends ViewPart
implements ISetSelectionTarget,
ISaveablePart,
ISaveablesSource,
IShowInTarget {
    private static final String PERF_CREATE_PART_CONTROL = "org.eclipse.ui.navigator/perf/explorer/createPartControl";
    private static final Class INAVIGATOR_CONTENT_SERVICE;
    private static final Class COMMON_VIEWER_CLASS;
    private static final Class ISHOW_IN_SOURCE_CLASS;
    private static final Class ISHOW_IN_TARGET_CLASS;
    private static final String HELP_CONTEXT;
    public static final int IS_LINKING_ENABLED_PROPERTY = 65536;
    private CommonViewer commonViewer;
    private CommonNavigatorManager commonManager;
    private ActionGroup commonActionGroup;
    protected IMemento memento;
    private boolean isLinkingEnabled = false;
    private String LINKING_ENABLED = "CommonNavigator.LINKING_ENABLED";
    private LinkHelperService linkService;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.navigator.INavigatorContentService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INAVIGATOR_CONTENT_SERVICE = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.navigator.CommonViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        COMMON_VIEWER_CLASS = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISHOW_IN_SOURCE_CLASS = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.ui.part.IShowInTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISHOW_IN_TARGET_CLASS = clazz4;
        HELP_CONTEXT = String.valueOf(NavigatorPlugin.PLUGIN_ID) + ".common_navigator";
    }

    public void createPartControl(Composite aParent) {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_CREATE_PART_CONTROL, (Object)((Object)this));
        stats.startRun();
        this.commonViewer = this.createCommonViewer(aParent);
        this.commonViewer.setCommonNavigator(this);
        try {
            this.commonViewer.getControl().setRedraw(false);
            INavigatorFilterService filterService = this.commonViewer.getNavigatorContentService().getFilterService();
            ViewerFilter[] visibleFilters = filterService.getVisibleFilters(true);
            int i = 0;
            while (i < visibleFilters.length) {
                this.commonViewer.addFilter(visibleFilters[i]);
                ++i;
            }
            this.commonViewer.setSorter((ViewerSorter)new CommonViewerSorter());
            this.commonViewer.setInput(this.getInitialInput());
            this.getSite().setSelectionProvider((ISelectionProvider)this.commonViewer);
            this.setPartName(this.getConfigurationElement().getAttribute("name"));
        }
        finally {
            this.commonViewer.getControl().setRedraw(true);
        }
        this.commonViewer.createFrameList();
        this.commonManager = this.createCommonManager();
        if (this.memento != null) {
            this.commonViewer.getNavigatorContentService().restoreState(this.memento);
        }
        this.commonActionGroup = this.createCommonActionGroup();
        this.commonActionGroup.fillActionBars(this.getViewSite().getActionBars());
        ISaveablesLifecycleListener saveablesLifecycleListener = new ISaveablesLifecycleListener(){
            ISaveablesLifecycleListener siteSaveablesLifecycleListener;
            {
                IWorkbenchPartSite iWorkbenchPartSite = CommonNavigator.this.getSite();
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("org.eclipse.ui.ISaveablesLifecycleListener");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.siteSaveablesLifecycleListener = (ISaveablesLifecycleListener)iWorkbenchPartSite.getService((Class)clazz);
            }

            public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
                if (event.getEventType() == 4) {
                    CommonNavigator.this.firePropertyChange(257);
                }
                this.siteSaveablesLifecycleListener.handleLifecycleEvent(event);
            }
        };
        this.commonViewer.getNavigatorContentService().getSaveablesService().init(this, (StructuredViewer)this.getCommonViewer(), saveablesLifecycleListener);
        this.commonViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CommonNavigator.this.firePropertyChange(257);
            }
        });
        String helpContext = this.commonViewer.getNavigatorContentService().getViewerDescriptor().getHelpContext();
        if (helpContext == null) {
            helpContext = HELP_CONTEXT;
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.commonViewer.getControl(), helpContext);
        stats.endRun();
    }

    public void updateTitle() {
        Object input = this.commonViewer.getInput();
        if (input == null) {
            this.setTitleToolTip("");
        } else {
            String inputToolTip = this.getFrameToolTipText(input);
            this.setTitleToolTip(inputToolTip);
        }
    }

    public String getFrameToolTipText(Object anElement) {
        if (this.commonViewer == null) {
            return "";
        }
        return ((ILabelProvider)this.commonViewer.getLabelProvider()).getText(anElement);
    }

    public void dispose() {
        if (this.commonManager != null) {
            this.commonManager.dispose();
        }
        if (this.commonActionGroup != null) {
            this.commonActionGroup.dispose();
        }
        super.dispose();
    }

    public void init(IViewSite aSite, IMemento aMemento) throws PartInitException {
        super.init(aSite, aMemento);
        this.memento = aMemento;
        if (this.memento != null) {
            Integer linkingEnabledInteger = this.memento.getInteger(this.LINKING_ENABLED);
            this.setLinkingEnabled(linkingEnabledInteger != null ? linkingEnabledInteger == 1 : false);
        }
    }

    public void saveState(IMemento aMemento) {
        aMemento.putInteger(this.LINKING_ENABLED, this.isLinkingEnabled ? 1 : 0);
        super.saveState(aMemento);
        this.commonManager.saveState(aMemento);
        this.commonViewer.getNavigatorContentService().saveState(aMemento);
    }

    public void setFocus() {
        if (this.commonViewer != null) {
            this.commonViewer.getTree().setFocus();
        }
    }

    public void selectReveal(ISelection selection) {
        if (this.commonViewer != null) {
            this.commonViewer.setSelection(selection, true);
        }
    }

    public final void setLinkingEnabled(boolean toEnableLinking) {
        this.isLinkingEnabled = toEnableLinking;
        this.firePropertyChange(65536);
    }

    public final boolean isLinkingEnabled() {
        return this.isLinkingEnabled;
    }

    public CommonViewer getCommonViewer() {
        return this.commonViewer;
    }

    public INavigatorContentService getNavigatorContentService() {
        return this.getCommonViewer().getNavigatorContentService();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == COMMON_VIEWER_CLASS) {
            return this.getCommonViewer();
        }
        if (adapter == INAVIGATOR_CONTENT_SERVICE) {
            return this.getCommonViewer().getNavigatorContentService();
        }
        if (adapter == ISHOW_IN_TARGET_CLASS) {
            return this;
        }
        if (adapter == ISHOW_IN_SOURCE_CLASS) {
            return this.getShowInSource();
        }
        return super.getAdapter(adapter);
    }

    private IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(CommonNavigator.this.getCommonViewer().getInput(), CommonNavigator.this.getCommonViewer().getSelection());
            }
        };
    }

    public NavigatorActionService getNavigatorActionService() {
        return this.commonManager.getNavigatorActionService();
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        CommonViewer aViewer = this.createCommonViewerObject(aParent);
        this.initListeners(aViewer);
        aViewer.getNavigatorContentService().restoreState(this.memento);
        return aViewer;
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        return new CommonViewer(this.getViewSite().getId(), aParent, 770);
    }

    protected void initListeners(TreeViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                try {
                    CommonNavigator.this.handleDoubleClick(event);
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                }
            }
        });
    }

    protected void handleDoubleClick(DoubleClickEvent anEvent) {
        IAction openHandler = this.getViewSite().getActionBars().getGlobalActionHandler("org.eclipse.ui.navigator.Open");
        if (openHandler == null) {
            IStructuredSelection selection = (IStructuredSelection)anEvent.getSelection();
            Object element = selection.getFirstElement();
            CommonViewer viewer = this.getCommonViewer();
            if (viewer.isExpandable(element)) {
                viewer.setExpandedState(element, !viewer.getExpandedState(element));
            }
        }
    }

    protected CommonNavigatorManager createCommonManager() {
        return new CommonNavigatorManager(this, this.memento);
    }

    protected ActionGroup createCommonActionGroup() {
        return new CommonNavigatorActionGroup(this, this.commonViewer, this.getLinkHelperService());
    }

    protected Object getInitialInput() {
        return this.getSite().getPage().getInput();
    }

    public Saveable[] getSaveables() {
        return this.getNavigatorContentService().getSaveablesService().getSaveables();
    }

    public Saveable[] getActiveSaveables() {
        return this.getNavigatorContentService().getSaveablesService().getActiveSaveables();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        Saveable[] saveables = this.getSaveables();
        int i = 0;
        while (i < saveables.length) {
            if (saveables[i].isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isDirty();
    }

    public boolean show(ShowInContext context) {
        IStructuredSelection selection = this.getSelection(context);
        if (selection != null && !selection.isEmpty()) {
            this.selectReveal((ISelection)selection);
            return true;
        }
        return false;
    }

    private IStructuredSelection getSelection(ShowInContext context) {
        if (context == null) {
            return StructuredSelection.EMPTY;
        }
        ISelection selection = context.getSelection();
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        Object input = context.getInput();
        if (input instanceof IEditorInput) {
            LinkHelperService lhs = this.getLinkHelperService();
            return lhs.getSelectionFor((IEditorInput)input);
        }
        if (input != null) {
            return new StructuredSelection(input);
        }
        return StructuredSelection.EMPTY;
    }

    protected synchronized LinkHelperService getLinkHelperService() {
        if (this.linkService == null) {
            this.linkService = new LinkHelperService((NavigatorContentService)this.getCommonViewer().getNavigatorContentService());
        }
        return this.linkService;
    }

    protected IMemento getMemento() {
        return this.memento;
    }

    public void setRootMode(int mode) {
    }

    public int getRootMode() {
        return 0;
    }

    public void setWorkingSetLabel(String label) {
    }

    public String getWorkingSetLabel() {
        return null;
    }
}

