/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.jobs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.studio.connection.core.ConnectionCoreConstants;
import org.apache.directory.studio.connection.core.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class StudioProgressMonitor
extends ProgressMonitorWrapper {
    private static Job reportProgressAndCheckCancellationJob = new Job(Messages.jobs__progressmonitor_check_cancellation){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (true) {
                List list = monitors;
                synchronized (list) {
                    Iterator it = monitors.iterator();
                    block6: while (it.hasNext()) {
                        StudioProgressMonitor next;
                        StudioProgressMonitor spm = next = (StudioProgressMonitor)((Object)it.next());
                        do {
                            if (!spm.isCanceled() && !spm.done && spm.reportProgressMessage != null) {
                                spm.subTask(spm.reportProgressMessage);
                                spm.reportProgressMessage = null;
                            }
                            if (spm.isCanceled()) {
                                spm.fireCancelRequested();
                            }
                            if (!spm.isCanceled() && !spm.done) continue;
                            it.remove();
                            continue block6;
                        } while ((spm = spm.getWrappedProgressMonitor() != null && spm.getWrappedProgressMonitor() instanceof StudioProgressMonitor ? (StudioProgressMonitor)spm.getWrappedProgressMonitor() : null) != null);
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    };
    private static List<StudioProgressMonitor> monitors;
    private boolean done = false;
    private List<Status> errorStatusList;
    private List<CancelListener> cancelListenerList;
    private String reportProgressMessage = null;

    public StudioProgressMonitor(IProgressMonitor monitor) {
        super(monitor);
        monitors.add(this);
    }

    public void setCanceled(boolean b) {
        super.setCanceled(b);
        if (b) {
            this.fireCancelRequested();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        StudioProgressMonitor studioProgressMonitor = this;
        synchronized (studioProgressMonitor) {
            this.done = true;
            super.done();
        }
    }

    public void addCancelListener(CancelListener listener) {
        if (this.cancelListenerList == null) {
            this.cancelListenerList = new ArrayList<CancelListener>();
        }
        if (!this.cancelListenerList.contains(listener)) {
            this.cancelListenerList.add(listener);
        }
    }

    public void removeCancelListener(CancelListener listener) {
        if (this.cancelListenerList != null && this.cancelListenerList.contains(listener)) {
            this.cancelListenerList.remove(listener);
        }
    }

    private void fireCancelRequested() {
        CancelEvent event = new CancelEvent((IProgressMonitor)this);
        if (this.cancelListenerList != null) {
            for (int i = 0; i < this.cancelListenerList.size(); ++i) {
                CancelListener listener = this.cancelListenerList.get(i);
                listener.cancelRequested(event);
            }
        }
    }

    public void reportProgress(String message) {
        this.reportProgressMessage = message;
    }

    public void reportError(String message) {
        this.reportError(message, null);
    }

    public void reportError(Exception exception) {
        this.reportError(null, exception);
    }

    public void reportError(String message, Exception exception) {
        if (this.errorStatusList == null) {
            this.errorStatusList = new ArrayList<Status>(3);
        }
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, ConnectionCoreConstants.PLUGIN_ID, 4, message, (Throwable)exception);
        this.errorStatusList.add(errorStatus);
    }

    public boolean errorsReported() {
        return this.errorStatusList != null;
    }

    public IStatus getErrorStatus(String message) {
        if (this.errorStatusList != null && !this.errorStatusList.isEmpty()) {
            for (Status status : this.errorStatusList) {
                String statusMessage = status.getMessage();
                Throwable exception = status.getException();
                String exceptionMessage = exception != null ? exception.getMessage() : null;
                for (Throwable e = exception; e != null; e = e.getCause()) {
                    if (e instanceof UnknownHostException) {
                        exceptionMessage = "Unknown Host: " + e.getMessage();
                        continue;
                    }
                    if (!(e instanceof SocketException)) continue;
                    exceptionMessage = e.getMessage() + " (" + exceptionMessage + ")";
                }
                if (!StringUtils.isEmpty((String)statusMessage)) {
                    message = message + "\n - " + statusMessage;
                }
                if (exception == null || exceptionMessage == null || exceptionMessage.equals(statusMessage)) continue;
                int indexOfAny = StringUtils.indexOfAny((String)exceptionMessage, (String)"\n\r\t");
                if (indexOfAny > -1) {
                    exceptionMessage = exceptionMessage.substring(0, indexOfAny - 1);
                }
                message = message + "\n - " + exceptionMessage;
            }
            MultiStatus multiStatus = new MultiStatus(ConnectionCoreConstants.PLUGIN_ID, 4, message, null);
            for (Status status : this.errorStatusList) {
                String statusMessage = status.getMessage();
                if (status.getException() != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    status.getException().printStackTrace(pw);
                    statusMessage = sw.toString();
                }
                multiStatus.add((IStatus)new Status(status.getSeverity(), status.getPlugin(), status.getCode(), statusMessage, status.getException()));
            }
            return multiStatus;
        }
        if (this.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public Exception getException() {
        if (this.errorStatusList != null) {
            return (Exception)this.errorStatusList.get(0).getException();
        }
        return null;
    }

    public void reset() {
        this.done = false;
        this.errorStatusList = null;
    }

    static {
        reportProgressAndCheckCancellationJob.setSystem(true);
        reportProgressAndCheckCancellationJob.schedule();
        monitors = Collections.synchronizedList(new ArrayList());
    }

    public static interface CancelListener {
        public void cancelRequested(CancelEvent var1);
    }

    public static class CancelEvent {
        private IProgressMonitor monitor;

        public CancelEvent(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public IProgressMonitor getMonitor() {
            return this.monitor;
        }
    }
}

