/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.jobs;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IConnectionListener;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.jobs.StudioBulkRunnableWithProgress;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.jobs.StudioRunnableWithProgress;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class StudioConnectionJob
extends Job {
    private StudioRunnableWithProgress[] runnables;

    public StudioConnectionJob(StudioRunnableWithProgress ... runnables) {
        super(runnables[0].getName());
        this.runnables = runnables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final IStatus run(IProgressMonitor ipm) {
        StudioProgressMonitor monitor = new StudioProgressMonitor(ipm);
        for (StudioRunnableWithProgress runnable : this.runnables) {
            Connection[] connections = runnable.getConnections();
            if (connections == null) continue;
            for (Connection connection : connections) {
                if (connection == null || connection.getJNDIConnectionWrapper().isConnected()) continue;
                monitor.setTaskName(Messages.bind((String)Messages.jobs__open_connections_task, (Object[])new String[]{connection.getName()}));
                monitor.worked(1);
                connection.getJNDIConnectionWrapper().connect(monitor);
                if (connection.getJNDIConnectionWrapper().isConnected()) {
                    connection.getJNDIConnectionWrapper().bind(monitor);
                }
                if (!connection.getJNDIConnectionWrapper().isConnected()) continue;
                for (IConnectionListener listener : ConnectionCorePlugin.getDefault().getConnectionListeners()) {
                    listener.connectionOpened(connection, monitor);
                }
                ConnectionEventRegistry.fireConnectionOpened(connection, (Object)this);
            }
        }
        if (!monitor.errorsReported()) {
            try {
                for (StudioRunnableWithProgress runnable : this.runnables) {
                    if (runnable instanceof StudioBulkRunnableWithProgress) {
                        StudioBulkRunnableWithProgress bulkRunnable = (StudioBulkRunnableWithProgress)runnable;
                        this.suspendEventFiringInCurrentThread();
                        try {
                            bulkRunnable.run(monitor);
                        }
                        finally {
                            this.resumeEventFiringInCurrentThread();
                        }
                        bulkRunnable.runNotification(monitor);
                        continue;
                    }
                    runnable.run(monitor);
                }
            }
            catch (Exception e) {
                monitor.reportError(e);
            }
        }
        monitor.done();
        ipm.done();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (monitor.errorsReported()) {
            return monitor.getErrorStatus(this.runnables[0].getErrorMessage());
        }
        return Status.OK_STATUS;
    }

    protected void suspendEventFiringInCurrentThread() {
        ConnectionEventRegistry.suspendEventFiringInCurrentThread();
    }

    protected void resumeEventFiringInCurrentThread() {
        ConnectionEventRegistry.resumeEventFiringInCurrentThread();
    }

    public final void execute() {
        this.setUser(true);
        this.schedule();
    }

    public boolean shouldSchedule() {
        for (StudioRunnableWithProgress runnable : this.runnables) {
            Object[] myLockedObjects = runnable.getLockedObjects();
            String[] myLockedObjectsIdentifiers = StudioConnectionJob.getLockIdentifiers(myLockedObjects);
            Job[] jobs = StudioConnectionJob.getJobManager().find(null);
            for (int i = 0; i < jobs.length; ++i) {
                Job job = jobs[i];
                if (!(job instanceof StudioConnectionJob)) continue;
                StudioConnectionJob otherJob = (StudioConnectionJob)job;
                for (StudioRunnableWithProgress otherRunnable : otherJob.runnables) {
                    if (runnable.getClass() != otherRunnable.getClass() || runnable == otherRunnable) continue;
                    Object[] otherLockedObjects = otherRunnable.getLockedObjects();
                    String[] otherLockedObjectIdentifiers = StudioConnectionJob.getLockIdentifiers(otherLockedObjects);
                    for (int j = 0; j < otherLockedObjectIdentifiers.length; ++j) {
                        String other = otherLockedObjectIdentifiers[j];
                        for (int k = 0; k < myLockedObjectsIdentifiers.length; ++k) {
                            String my = myLockedObjectsIdentifiers[k];
                            if (!other.startsWith(my) && !my.startsWith(other)) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return super.shouldSchedule();
    }

    private static String[] getLockIdentifiers(Object[] objects) {
        String[] identifiers = new String[objects.length];
        for (int i = 0; i < identifiers.length; ++i) {
            Object o = objects[i];
            identifiers[i] = o instanceof Connection ? StudioConnectionJob.getLockIdentifier((Connection)o) : StudioConnectionJob.getLockIdentifier(objects[i]);
        }
        return identifiers;
    }

    private static String getLockIdentifier(Connection connection) {
        return connection.getHost() + ':' + connection.getPort();
    }

    private static String getLockIdentifier(Object object) {
        String s = object != null ? object.toString() : "null";
        s = '-' + s;
        return s;
    }
}

