/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.jobs;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IConnectionListener;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.jobs.StudioBulkRunnableWithProgress;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;

public class OpenConnectionsRunnable
implements StudioBulkRunnableWithProgress {
    private Connection[] connections;

    public OpenConnectionsRunnable(Connection connection) {
        this(new Connection[]{connection});
    }

    public OpenConnectionsRunnable(Connection[] connections) {
        this.connections = connections;
    }

    public String getName() {
        return this.connections.length == 1 ? Messages.jobs__open_connections_name_1 : Messages.jobs__open_connections_name_n;
    }

    public Object[] getLockedObjects() {
        return this.connections;
    }

    public String getErrorMessage() {
        return this.connections.length == 1 ? Messages.jobs__open_connections_error_1 : Messages.jobs__open_connections_error_n;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(" ", this.connections.length * 6 + 1);
        monitor.reportProgress(" ");
        for (Connection connection : this.connections) {
            if (connection.getJNDIConnectionWrapper().isConnected()) continue;
            monitor.setTaskName(Messages.bind((String)Messages.jobs__open_connections_task, (Object[])new String[]{connection.getName()}));
            monitor.worked(1);
            connection.getJNDIConnectionWrapper().connect(monitor);
            if (!connection.getJNDIConnectionWrapper().isConnected()) continue;
            connection.getJNDIConnectionWrapper().bind(monitor);
        }
    }

    public void runNotification(StudioProgressMonitor monitor) {
        for (Connection connection : this.connections) {
            if (!connection.getJNDIConnectionWrapper().isConnected()) continue;
            for (IConnectionListener listener : ConnectionCorePlugin.getDefault().getConnectionListeners()) {
                listener.connectionOpened(connection, monitor);
            }
        }
        for (Connection connection : this.connections) {
            if (!connection.getJNDIConnectionWrapper().isConnected()) continue;
            ConnectionEventRegistry.fireConnectionOpened(connection, this);
        }
    }

    public Connection[] getConnections() {
        return null;
    }
}

