/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.jobs;

import java.util.List;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IConnectionListener;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.jobs.StudioBulkRunnableWithProgress;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloseConnectionsRunnable
implements StudioBulkRunnableWithProgress {
    private Connection[] connections;

    public CloseConnectionsRunnable(Connection connection) {
        this(new Connection[]{connection});
    }

    public CloseConnectionsRunnable(Connection[] connections) {
        this.connections = connections;
    }

    public CloseConnectionsRunnable(List<Connection> connections) {
        this.connections = connections.toArray(new Connection[connections.size()]);
    }

    @Override
    public String getName() {
        return this.connections.length == 1 ? Messages.jobs__close_connections_name_1 : Messages.jobs__close_connections_name_n;
    }

    @Override
    public Object[] getLockedObjects() {
        return this.connections;
    }

    @Override
    public String getErrorMessage() {
        return this.connections.length == 1 ? Messages.jobs__close_connections_error_1 : Messages.jobs__close_connections_error_n;
    }

    @Override
    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(" ", this.connections.length * 6 + 1);
        monitor.reportProgress(" ");
        for (Connection connection : this.connections) {
            if (!connection.getJNDIConnectionWrapper().isConnected()) continue;
            monitor.setTaskName(Messages.bind((String)Messages.jobs__close_connections_task, (Object[])new String[]{connection.getName()}));
            monitor.worked(1);
            connection.getJNDIConnectionWrapper().unbind();
            connection.getJNDIConnectionWrapper().disconnect();
        }
    }

    @Override
    public void runNotification(StudioProgressMonitor monitor) {
        for (Connection connection : this.connections) {
            if (connection.getJNDIConnectionWrapper().isConnected()) continue;
            for (IConnectionListener listener : ConnectionCorePlugin.getDefault().getConnectionListeners()) {
                listener.connectionClosed(connection, monitor);
            }
        }
        for (Connection connection : this.connections) {
            if (connection.getJNDIConnectionWrapper().isConnected()) continue;
            ConnectionEventRegistry.fireConnectionClosed(connection, this);
        }
    }

    @Override
    public Connection[] getConnections() {
        return null;
    }
}

