/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io.jndi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.directory.studio.connection.core.io.jndi.StudioTrustManager;

public class StudioSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory delegate;
    private StudioTrustManager[] trustManagers;

    public static SSLSocketFactory getDefault() {
        return new StudioSSLSocketFactory();
    }

    public StudioSSLSocketFactory() {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init((KeyStore)null);
            TrustManager[] defaultTrustManagers = factory.getTrustManagers();
            this.trustManagers = new StudioTrustManager[defaultTrustManagers.length];
            for (int i = 0; i < defaultTrustManagers.length; ++i) {
                this.trustManagers[i] = new StudioTrustManager((X509TrustManager)defaultTrustManagers[i]);
            }
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, this.trustManagers, null);
            this.delegate = sc.getSocketFactory();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        try {
            this.updateTrustManagers(host);
            return this.delegate.createSocket(s, host, port, autoClose);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        try {
            this.updateTrustManagers(host);
            return this.delegate.createSocket(host, port);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        try {
            this.updateTrustManagers(host);
            return this.delegate.createSocket(host, port);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        try {
            this.updateTrustManagers(host);
            return this.delegate.createSocket(host, port, localHost, localPort);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        try {
            this.updateTrustManagers(address);
            return this.delegate.createSocket(address, port, localAddress, localPort);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void updateTrustManagers(InetAddress address) {
        this.updateTrustManagers(address.getHostName());
    }

    private void updateTrustManagers(String host) {
        for (StudioTrustManager trustManager : this.trustManagers) {
            trustManager.setHost(host);
        }
    }
}

