/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io.jndi;

import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.ReferralException;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IJndiLogger;
import org.apache.directory.studio.connection.core.io.jndi.JNDIConnectionWrapper;
import org.apache.directory.studio.connection.core.io.jndi.ReferralsInfo;
import org.apache.directory.studio.connection.core.io.jndi.StudioSearchResult;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudioNamingEnumeration
implements NamingEnumeration<SearchResult> {
    private final Connection connection;
    private final LdapContext ctx;
    private NamingEnumeration<SearchResult> initialNamingEnumeration;
    private NamingEnumeration<SearchResult> delegate;
    private NamingException initialReferralException;
    private long requestNum;
    private long resultEntryCounter;
    private String searchBase;
    private String filter;
    private SearchControls searchControls;
    private Connection.AliasDereferencingMethod aliasesDereferencingMethod;
    private Connection.ReferralHandlingMethod referralsHandlingMethod;
    private Control[] controls;
    private StudioProgressMonitor monitor;
    private ReferralsInfo referralsInfo;

    StudioNamingEnumeration(Connection connection, LdapContext ctx, NamingEnumeration<SearchResult> delegate, NamingException initialReferralException, String searchBase, String filter, SearchControls searchControls, Connection.AliasDereferencingMethod aliasesDereferencingMethod, Connection.ReferralHandlingMethod referralsHandlingMethod, Control[] controls, long requestNum, StudioProgressMonitor monitor, ReferralsInfo referralsInfo) {
        this.connection = connection;
        this.ctx = ctx;
        this.initialNamingEnumeration = delegate;
        this.delegate = delegate;
        this.initialReferralException = initialReferralException;
        this.requestNum = requestNum;
        this.resultEntryCounter = 0L;
        this.searchBase = searchBase;
        this.filter = filter;
        this.searchControls = searchControls;
        this.aliasesDereferencingMethod = aliasesDereferencingMethod;
        this.referralsHandlingMethod = referralsHandlingMethod;
        this.controls = controls;
        this.monitor = monitor;
        this.referralsInfo = referralsInfo;
    }

    @Override
    public void close() throws NamingException {
        this.delegate.close();
    }

    @Override
    public boolean hasMore() throws NamingException {
        NamingException logResultDoneException = null;
        boolean done = false;
        while (true) {
            try {
                boolean hasMore;
                if (this.initialReferralException != null) {
                    NamingException referralException = this.initialReferralException;
                    this.initialReferralException = null;
                    throw referralException;
                }
                boolean bl = hasMore = this.delegate != null && this.delegate.hasMore();
                if (!hasMore && !done && this.referralsInfo != null && this.referralsInfo.hasMoreReferrals()) {
                    done = this.checkReferral();
                    continue;
                }
                done = !hasMore;
                boolean bl2 = hasMore;
                return bl2;
            }
            catch (PartialResultException pre) {
                done = true;
                logResultDoneException = pre;
                if (this.referralsHandlingMethod == Connection.ReferralHandlingMethod.IGNORE) {
                    boolean logger = false;
                    return logger;
                }
                throw pre;
            }
            catch (ReferralException re) {
                done = true;
                logResultDoneException = re;
                this.referralsInfo = JNDIConnectionWrapper.handleReferralException(re, this.referralsInfo);
                if (this.referralsInfo.hasMoreReferrals()) {
                    logResultDoneException = null;
                    done = this.checkReferral();
                    return done;
                }
            }
            catch (NamingException ne) {
                done = true;
                logResultDoneException = ne;
                throw ne;
            }
            finally {
                if (!done) continue;
                for (IJndiLogger logger : ConnectionCorePlugin.getDefault().getJndiLoggers()) {
                    logger.logSearchResultDone(this.connection, this.resultEntryCounter, this.requestNum, logResultDoneException);
                }
                continue;
            }
            break;
        }
    }

    @Override
    public boolean hasMoreElements() {
        throw new UnsupportedOperationException("Call hasMore() instead of hasMoreElements() !");
    }

    @Override
    public StudioSearchResult next() throws NamingException {
        StudioSearchResult studioSearchResult = null;
        NamingException namingException = null;
        try {
            SearchResult searchResult = this.delegate.next();
            ++this.resultEntryCounter;
            studioSearchResult = searchResult instanceof StudioSearchResult ? (StudioSearchResult)searchResult : new StudioSearchResult(searchResult, this.getConnection(), this.referralsInfo != null, null);
            StudioSearchResult studioSearchResult2 = studioSearchResult;
            return studioSearchResult2;
        }
        catch (NamingException ne) {
            namingException = ne;
            throw ne;
        }
        finally {
            if (this.delegate == this.initialNamingEnumeration) {
                for (IJndiLogger logger : ConnectionCorePlugin.getDefault().getJndiLoggers()) {
                    logger.logSearchResultEntry(this.connection, studioSearchResult, this.requestNum, namingException);
                }
            }
        }
    }

    @Override
    public StudioSearchResult nextElement() {
        throw new UnsupportedOperationException("Call next() instead of nextElement() !");
    }

    public Connection getConnection() {
        if (this.delegate instanceof StudioNamingEnumeration) {
            return ((StudioNamingEnumeration)this.delegate).getConnection();
        }
        return this.connection;
    }

    public Control[] getResponseControls() throws NamingException {
        return this.ctx != null ? this.ctx.getResponseControls() : null;
    }

    private boolean checkReferral() {
        boolean done = false;
        if (this.referralsHandlingMethod == Connection.ReferralHandlingMethod.IGNORE) {
            done = true;
            this.delegate = null;
        } else if (this.referralsHandlingMethod == Connection.ReferralHandlingMethod.FOLLOW_MANUALLY) {
            this.delegate = new NamingEnumeration<SearchResult>(){
                List<LdapURL> urls = new ArrayList<LdapURL>();
                {
                    while (StudioNamingEnumeration.this.referralsInfo.hasMoreReferrals()) {
                        ReferralsInfo.Referral referral = StudioNamingEnumeration.this.referralsInfo.getNextReferral();
                        for (IJndiLogger logger : ConnectionCorePlugin.getDefault().getJndiLoggers()) {
                            logger.logSearchResultReference(StudioNamingEnumeration.this.connection, referral, StudioNamingEnumeration.this.referralsInfo, StudioNamingEnumeration.this.requestNum, null);
                        }
                        this.urls.addAll(referral.getLdapURLs());
                    }
                }

                @Override
                public SearchResult nextElement() {
                    throw new UnsupportedOperationException("Call next() instead of nextElement() !");
                }

                @Override
                public boolean hasMoreElements() {
                    throw new UnsupportedOperationException("Call hasMore() instead of hasMoreElements() !");
                }

                @Override
                public SearchResult next() throws NamingException {
                    LdapURL url = this.urls.remove(0);
                    SearchResult searchResult = new SearchResult(url.getDn().getUpName(), (Object)null, new BasicAttributes(), false);
                    searchResult.setNameInNamespace(url.getDn().getUpName());
                    StudioSearchResult ssr = new StudioSearchResult(searchResult, null, false, url);
                    return ssr;
                }

                @Override
                public boolean hasMore() throws NamingException {
                    return !this.urls.isEmpty();
                }

                @Override
                public void close() throws NamingException {
                    this.urls.clear();
                    StudioNamingEnumeration.this.referralsInfo = null;
                }
            };
        } else if (this.referralsHandlingMethod == Connection.ReferralHandlingMethod.FOLLOW) {
            ReferralsInfo.Referral referral = this.referralsInfo.getNextReferral();
            for (IJndiLogger logger : ConnectionCorePlugin.getDefault().getJndiLoggers()) {
                logger.logSearchResultReference(this.connection, referral, this.referralsInfo, this.requestNum, null);
            }
            LdapURL url = referral.getLdapURLs().get(0);
            Connection referralConnection = JNDIConnectionWrapper.getReferralConnection(referral, this.monitor, this);
            if (referralConnection != null) {
                done = false;
                String referralSearchBase = url.getDn() != null && !url.getDn().isEmpty() ? url.getDn().getUpName() : this.searchBase;
                String referralFilter = url.getFilter() != null && url.getFilter().length() == 0 ? url.getFilter() : this.filter;
                SearchControls referralSearchControls = new SearchControls();
                referralSearchControls.setSearchScope(url.getScope() > -1 ? url.getScope() : this.searchControls.getSearchScope());
                referralSearchControls.setReturningAttributes(url.getAttributes() != null && url.getAttributes().size() > 0 ? url.getAttributes().toArray(new String[url.getAttributes().size()]) : this.searchControls.getReturningAttributes());
                referralSearchControls.setCountLimit(this.searchControls.getCountLimit());
                referralSearchControls.setTimeLimit(this.searchControls.getTimeLimit());
                referralSearchControls.setDerefLinkFlag(this.searchControls.getDerefLinkFlag());
                referralSearchControls.setReturningObjFlag(this.searchControls.getReturningObjFlag());
                this.delegate = referralConnection.getJNDIConnectionWrapper().search(referralSearchBase, referralFilter, referralSearchControls, this.aliasesDereferencingMethod, this.referralsHandlingMethod, this.controls, this.monitor, this.referralsInfo);
            } else {
                done = true;
                this.delegate = null;
            }
        }
        return done;
    }
}

