/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io.jndi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.naming.LinkLoopException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.studio.connection.core.Messages;
import org.eclipse.osgi.util.NLS;

public class ReferralsInfo {
    private LinkedList<Referral> referralsToProcess = new LinkedList();
    private Set<LdapURL> processedUrls = new HashSet<LdapURL>();

    public void addReferral(Referral referral) {
        this.referralsToProcess.addLast(referral);
    }

    public Referral getNextReferral() {
        if (!this.referralsToProcess.isEmpty()) {
            Referral referral = this.referralsToProcess.removeFirst();
            for (LdapURL url : referral.urls) {
                this.processedUrls.add(url);
            }
            return referral;
        }
        return null;
    }

    public boolean hasMoreReferrals() {
        return !this.referralsToProcess.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Referral {
        private List<LdapURL> urls = new ArrayList<LdapURL>();
        private LdapDN dn;

        public Referral(LdapDN dn) {
            this.dn = dn;
        }

        public List<LdapURL> getLdapURLs() {
            return this.urls;
        }

        public LdapDN getDn() {
            return this.dn;
        }

        public void addUrl(LdapURL url) throws LinkLoopException {
            if (ReferralsInfo.this.processedUrls.contains(url)) {
                throw new LinkLoopException(NLS.bind((String)Messages.error__loop_detected, (Object)url));
            }
            this.urls.add(url);
        }
    }
}

