/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io.jndi;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.Control;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionManager;
import org.apache.directory.studio.connection.core.DnUtils;
import org.apache.directory.studio.connection.core.IJndiLogger;
import org.apache.directory.studio.connection.core.io.jndi.ReferralsInfo;
import org.apache.directory.studio.connection.core.io.jndi.StudioSearchResult;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeAddRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeDeleteRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModDnRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModifyRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifModSpec;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifChangeTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifCommentLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifControlLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDeloldrdnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecSepLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifNewrdnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifNewsuperiorLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;
import org.eclipse.core.runtime.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifModificationLogger
implements IJndiLogger {
    private String id;
    private String name;
    private String description;
    private Map<String, FileHandler> fileHandlers = new HashMap<String, FileHandler>();
    private Map<String, Logger> loggers = new HashMap<String, Logger>();

    public LdifModificationLogger() {
        ConnectionCorePlugin.getDefault().getPluginPreferences().addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                if ("modificationLogsFileCount".equals(event.getProperty()) || "modificationLogsFileSize".equals(event.getProperty())) {
                    for (Logger logger : LdifModificationLogger.this.loggers.values()) {
                        for (Handler handler : logger.getHandlers()) {
                            handler.close();
                        }
                    }
                    for (FileHandler fh : LdifModificationLogger.this.fileHandlers.values()) {
                        try {
                            File[] logFiles = LdifModificationLogger.getLogFiles(fh);
                            for (int i = LdifModificationLogger.this.getFileCount(); i < logFiles.length; ++i) {
                                if (logFiles[i] == null || !logFiles[i].exists()) continue;
                                logFiles[i].delete();
                            }
                        }
                        catch (Exception e) {
                        }
                    }
                    LdifModificationLogger.this.loggers.clear();
                }
            }
        });
    }

    private void initModificationLogger(Connection connection) {
        Logger logger = Logger.getAnonymousLogger();
        this.loggers.put(connection.getId(), logger);
        logger.setLevel(Level.ALL);
        String logfileName = ConnectionManager.getModificationLogFileName(connection);
        try {
            FileHandler fileHandler = new FileHandler(logfileName, this.getFileSizeInKb() * 1000, this.getFileCount(), true);
            this.fileHandlers.put(connection.getId(), fileHandler);
            fileHandler.setFormatter(new Formatter(){

                public String format(LogRecord record) {
                    return record.getMessage();
                }
            });
            logger.addHandler(fileHandler);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void dispose(Connection connection) {
        String id = connection.getId();
        if (this.loggers.containsKey(id)) {
            Handler[] handlers;
            for (Handler handler : handlers = this.loggers.get(id).getHandlers()) {
                handler.close();
            }
            this.loggers.remove(id);
        }
    }

    private void log(String text, NamingException ex, Connection connection) {
        String id = connection.getId();
        if (!this.loggers.containsKey(id) && connection.getName() != null) {
            this.initModificationLogger(connection);
        }
        if (this.loggers.containsKey(id)) {
            Logger logger = this.loggers.get(id);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            if (ex != null) {
                logger.log(Level.ALL, LdifCommentLine.create((String)"#!RESULT ERROR").toFormattedString(LdifFormatParameters.DEFAULT));
            } else {
                logger.log(Level.ALL, LdifCommentLine.create((String)"#!RESULT OK").toFormattedString(LdifFormatParameters.DEFAULT));
            }
            logger.log(Level.ALL, LdifCommentLine.create((String)("#!CONNECTION ldap://" + connection.getHost() + ":" + connection.getPort())).toFormattedString(LdifFormatParameters.DEFAULT));
            logger.log(Level.ALL, LdifCommentLine.create((String)("#!DATE " + df.format(new Date()))).toFormattedString(LdifFormatParameters.DEFAULT));
            if (ex != null) {
                String errorComment = "#!ERROR " + ex.getMessage();
                errorComment = errorComment.replaceAll("\r", " ");
                errorComment = errorComment.replaceAll("\n", " ");
                LdifCommentLine errorCommentLine = LdifCommentLine.create((String)errorComment);
                logger.log(Level.ALL, errorCommentLine.toFormattedString(LdifFormatParameters.DEFAULT));
            }
            logger.log(Level.ALL, text);
        }
    }

    @Override
    public void logChangetypeAdd(Connection connection, String dn, Attributes attributes, Control[] controls, NamingException ex) {
        if (!this.isModificationLogEnabled()) {
            return;
        }
        try {
            Set<String> maskedAttributes = this.getMaskedAttributes();
            LdifChangeAddRecord record = new LdifChangeAddRecord(LdifDnLine.create((String)dn));
            LdifModificationLogger.addControlLines((LdifChangeRecord)record, controls);
            record.setChangeType(LdifChangeTypeLine.createAdd());
            NamingEnumeration<? extends Attribute> attributeEnumeration = attributes.getAll();
            while (attributeEnumeration.hasMore()) {
                Attribute attribute = attributeEnumeration.next();
                String attributeName = attribute.getID();
                NamingEnumeration<?> valueEnumeration = attribute.getAll();
                while (valueEnumeration.hasMore()) {
                    Object o = valueEnumeration.next();
                    if (maskedAttributes.contains(attributeName.toLowerCase())) {
                        record.addAttrVal(LdifAttrValLine.create((String)attributeName, (String)"**********"));
                        continue;
                    }
                    if (o instanceof String) {
                        record.addAttrVal(LdifAttrValLine.create((String)attributeName, (String)((String)o)));
                    }
                    if (!(o instanceof byte[])) continue;
                    record.addAttrVal(LdifAttrValLine.create((String)attributeName, (byte[])((byte[])o)));
                }
            }
            record.finish(LdifSepLine.create());
            String formattedString = record.toFormattedString(LdifFormatParameters.DEFAULT);
            this.log(formattedString, ex, connection);
        }
        catch (NamingException e) {
            // empty catch block
        }
    }

    @Override
    public void logChangetypeDelete(Connection connection, String dn, Control[] controls, NamingException ex) {
        if (!this.isModificationLogEnabled()) {
            return;
        }
        LdifChangeDeleteRecord record = new LdifChangeDeleteRecord(LdifDnLine.create((String)dn));
        LdifModificationLogger.addControlLines((LdifChangeRecord)record, controls);
        record.setChangeType(LdifChangeTypeLine.createDelete());
        record.finish(LdifSepLine.create());
        String formattedString = record.toFormattedString(LdifFormatParameters.DEFAULT);
        this.log(formattedString, ex, connection);
    }

    @Override
    public void logChangetypeModify(Connection connection, String dn, ModificationItem[] modificationItems, Control[] controls, NamingException ex) {
        if (!this.isModificationLogEnabled()) {
            return;
        }
        try {
            Set<String> maskedAttributes = this.getMaskedAttributes();
            LdifChangeModifyRecord record = new LdifChangeModifyRecord(LdifDnLine.create((String)dn));
            LdifModificationLogger.addControlLines((LdifChangeRecord)record, controls);
            record.setChangeType(LdifChangeTypeLine.createModify());
            block7: for (ModificationItem item : modificationItems) {
                LdifModSpec modSpec;
                Attribute attribute = item.getAttribute();
                String attributeDescription = attribute.getID();
                switch (item.getModificationOp()) {
                    case 1: {
                        modSpec = LdifModSpec.createAdd((String)attributeDescription);
                        break;
                    }
                    case 3: {
                        modSpec = LdifModSpec.createDelete((String)attributeDescription);
                        break;
                    }
                    case 2: {
                        modSpec = LdifModSpec.createReplace((String)attributeDescription);
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                NamingEnumeration<?> valueEnumeration = attribute.getAll();
                while (valueEnumeration.hasMore()) {
                    Object o = valueEnumeration.next();
                    if (maskedAttributes.contains(attributeDescription.toLowerCase())) {
                        modSpec.addAttrVal(LdifAttrValLine.create((String)attributeDescription, (String)"**********"));
                        continue;
                    }
                    if (o instanceof String) {
                        modSpec.addAttrVal(LdifAttrValLine.create((String)attributeDescription, (String)((String)o)));
                    }
                    if (!(o instanceof byte[])) continue;
                    modSpec.addAttrVal(LdifAttrValLine.create((String)attributeDescription, (byte[])((byte[])o)));
                }
                modSpec.finish(LdifModSpecSepLine.create());
                record.addModSpec(modSpec);
            }
            record.finish(LdifSepLine.create());
            String formattedString = record.toFormattedString(LdifFormatParameters.DEFAULT);
            this.log(formattedString, ex, connection);
        }
        catch (NamingException e) {
            // empty catch block
        }
    }

    @Override
    public void logChangetypeModDn(Connection connection, String oldDn, String newDn, boolean deleteOldRdn, Control[] controls, NamingException ex) {
        if (!this.isModificationLogEnabled()) {
            return;
        }
        try {
            LdapDN dn = new LdapDN(newDn);
            Rdn newrdn = dn.getRdn();
            LdapDN newsuperior = DnUtils.getParent(dn);
            LdifChangeModDnRecord record = new LdifChangeModDnRecord(LdifDnLine.create((String)oldDn));
            LdifModificationLogger.addControlLines((LdifChangeRecord)record, controls);
            record.setChangeType(LdifChangeTypeLine.createModDn());
            record.setNewrdn(LdifNewrdnLine.create((String)newrdn.getUpName()));
            record.setDeloldrdn(deleteOldRdn ? LdifDeloldrdnLine.create1() : LdifDeloldrdnLine.create0());
            record.setNewsuperior(LdifNewsuperiorLine.create((String)newsuperior.getUpName()));
            record.finish(LdifSepLine.create());
            String formattedString = record.toFormattedString(LdifFormatParameters.DEFAULT);
            this.log(formattedString, ex, connection);
        }
        catch (InvalidNameException e) {
            // empty catch block
        }
    }

    @Override
    public void logSearchRequest(Connection connection, String searchBase, String filter, SearchControls searchControls, Connection.AliasDereferencingMethod aliasesDereferencingMethod, Control[] controls, long requestNum, NamingException ex) {
    }

    @Override
    public void logSearchResultEntry(Connection connection, StudioSearchResult studioSearchResult, long requestNum, NamingException ex) {
    }

    @Override
    public void logSearchResultReference(Connection connection, ReferralsInfo.Referral referral, ReferralsInfo referralsInfo, long requestNum, NamingException ex) {
    }

    @Override
    public void logSearchResultDone(Connection connection, long count, long requestNum, NamingException ex) {
    }

    private static void addControlLines(LdifChangeRecord record, Control[] controls) {
        if (controls != null) {
            for (Control control : controls) {
                String oid = control.getID();
                boolean isCritical = control.isCritical();
                byte[] controlValue = control.getEncodedValue();
                LdifControlLine controlLine = LdifControlLine.create((String)oid, (boolean)isCritical, (byte[])controlValue);
                record.addControl(controlLine);
            }
        }
    }

    public File[] getFiles(Connection connection) {
        String id = connection.getId();
        if (!this.loggers.containsKey(id) && connection.getName() != null) {
            this.initModificationLogger(connection);
        }
        try {
            return LdifModificationLogger.getLogFiles(this.fileHandlers.get(id));
        }
        catch (Exception e) {
            return new File[0];
        }
    }

    private static File[] getLogFiles(FileHandler fileHandler) throws Exception {
        Field field = LdifModificationLogger.getFieldFromClass("java.util.logging.FileHandler", "files");
        field.setAccessible(true);
        File[] files = (File[])field.get(fileHandler);
        return files;
    }

    private static Field getFieldFromClass(String className, String fieldName) throws Exception {
        Class<?> clazz = Class.forName(className);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(fieldName)) continue;
            return fields[i];
        }
        return null;
    }

    private boolean isModificationLogEnabled() {
        return ConnectionCorePlugin.getDefault().getPluginPreferences().getBoolean("modificationLogsEnable");
    }

    private int getFileCount() {
        return ConnectionCorePlugin.getDefault().getPluginPreferences().getInt("modificationLogsFileCount");
    }

    private int getFileSizeInKb() {
        return ConnectionCorePlugin.getDefault().getPluginPreferences().getInt("modificationLogsFileSize");
    }

    private Set<String> getMaskedAttributes() {
        String[] splitted;
        HashSet<String> maskedAttributes = new HashSet<String>();
        String maskedAttributeString = ConnectionCorePlugin.getDefault().getPluginPreferences().getString("modificationLogsMaskedAttributes");
        for (String s : splitted = maskedAttributeString.split(",")) {
            maskedAttributes.add(s.toLowerCase());
        }
        return maskedAttributes;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }
}

