/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io.jndi;

import java.io.File;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InsufficientResourcesException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.ReferralException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCoreConstants;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.IAuthHandler;
import org.apache.directory.studio.connection.core.IConnectionListener;
import org.apache.directory.studio.connection.core.ICredentials;
import org.apache.directory.studio.connection.core.IJndiLogger;
import org.apache.directory.studio.connection.core.IReferralHandler;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.io.ConnectionWrapper;
import org.apache.directory.studio.connection.core.io.jndi.CancelException;
import org.apache.directory.studio.connection.core.io.jndi.DummySSLSocketFactory;
import org.apache.directory.studio.connection.core.io.jndi.ReferralsInfo;
import org.apache.directory.studio.connection.core.io.jndi.StudioNamingEnumeration;
import org.apache.directory.studio.connection.core.io.jndi.StudioSSLSocketFactory;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDIConnectionWrapper
implements ConnectionWrapper {
    private static final String JAVA_NAMING_LDAP_DELETE_RDN = "java.naming.ldap.deleteRDN";
    private static final String AUTHMETHOD_NONE = "none";
    private static final String AUTHMETHOD_SIMPLE = "simple";
    private static final String AUTHMETHOD_DIGEST_MD5 = "DIGEST-MD5";
    private static final String AUTHMETHOD_CRAM_MD5 = "CRAM-MD5";
    private static final String AUTHMETHOD_GSSAPI = "GSSAPI";
    private static final String NO_CONNECTION = "No connection";
    private static final String JAVA_NAMING_SECURITY_SASL_REALM = "java.naming.security.sasl.realm";
    private static final String JAVA_NAMING_LDAP_FACTORY_SOCKET = "java.naming.ldap.factory.socket";
    private static final String COM_SUN_JNDI_DNS_TIMEOUT_RETRIES = "com.sun.jndi.dns.timeout.retries";
    private static final String COM_SUN_JNDI_DNS_TIMEOUT_INITIAL = "com.sun.jndi.dns.timeout.initial";
    private static final String COM_SUN_JNDI_LDAP_CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String JAVA_NAMING_LDAP_VERSION = "java.naming.ldap.version";
    private static final String JAVA_NAMING_LDAP_DEREF_ALIASES = "java.naming.ldap.derefAliases";
    private static final String JAVA_NAMING_LDAP_ATTRIBUTES_BINARY = "java.naming.ldap.attributes.binary";
    private static int SEARCH_RESQUEST_NUM = 0;
    private Connection connection;
    private boolean useLdaps;
    private boolean useStartTLS;
    private String authMethod;
    private String bindPrincipal;
    private String bindCredentials;
    private String saslRealm;
    private Hashtable<String, String> environment;
    private InitialLdapContext context;
    private boolean isConnected;
    private Thread jobThread;
    private Collection<String> binaryAttributes;
    public static final String REFERRAL_THROW = "throw";
    public static final String REFERRAL_FOLLOW = "follow";
    public static final String REFERRAL_IGNORE = "ignore";
    public static final String ALIAS_SEARCHING = "searching";
    public static final String ALIAS_FINDING = "finding";
    public static final String ALIAS_ALWAYS = "always";
    public static final String ALIAS_NEVER = "never";

    public JNDIConnectionWrapper(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void connect(StudioProgressMonitor monitor) {
        this.context = null;
        this.isConnected = false;
        this.jobThread = null;
        try {
            this.doConnect(monitor);
        }
        catch (NamingException ne) {
            this.disconnect();
            monitor.reportError(ne);
        }
    }

    @Override
    public void disconnect() {
        if (this.jobThread != null) {
            Thread t = this.jobThread;
            this.jobThread = null;
            t.interrupt();
        }
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.context = null;
        }
        this.isConnected = false;
        System.gc();
    }

    @Override
    public void bind(StudioProgressMonitor monitor) {
        try {
            this.doBind(monitor);
        }
        catch (NamingException ne) {
            this.disconnect();
            monitor.reportError(ne);
        }
    }

    @Override
    public void unbind() {
        this.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.context != null;
    }

    public void setBinaryAttributes(Collection<String> binaryAttributes) {
        this.binaryAttributes = binaryAttributes;
        String binaryAttributesString = "";
        for (String string : binaryAttributes) {
            binaryAttributesString = binaryAttributesString + string + ' ';
        }
        if (this.environment != null) {
            this.environment.put(JAVA_NAMING_LDAP_ATTRIBUTES_BINARY, binaryAttributesString);
        }
        if (this.context != null) {
            try {
                this.context.addToEnvironment(JAVA_NAMING_LDAP_ATTRIBUTES_BINARY, binaryAttributesString);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
    }

    public StudioNamingEnumeration search(final String searchBase, final String filter, final SearchControls searchControls, final Connection.AliasDereferencingMethod aliasesDereferencingMethod, final Connection.ReferralHandlingMethod referralsHandlingMethod, final Control[] controls, final StudioProgressMonitor monitor, final ReferralsInfo referralsInfo) {
        final long requestNum = SEARCH_RESQUEST_NUM++;
        InnerRunnable runnable = new InnerRunnable(){

            public void run() {
                LdapContext searchCtx = JNDIConnectionWrapper.this.context;
                try {
                    searchCtx = JNDIConnectionWrapper.this.context.newInstance(controls);
                    searchCtx.addToEnvironment(JNDIConnectionWrapper.JAVA_NAMING_LDAP_DEREF_ALIASES, JNDIConnectionWrapper.this.translateDerefAliasMethod(aliasesDereferencingMethod));
                    searchCtx.addToEnvironment("java.naming.referral", JNDIConnectionWrapper.REFERRAL_THROW);
                    NamingEnumeration<SearchResult> result = searchCtx.search(JNDIConnectionWrapper.getSaveJndiName(searchBase), filter, searchControls);
                    this.namingEnumeration = new StudioNamingEnumeration(JNDIConnectionWrapper.this.connection, searchCtx, result, null, searchBase, filter, searchControls, aliasesDereferencingMethod, referralsHandlingMethod, controls, requestNum, monitor, referralsInfo);
                }
                catch (PartialResultException e) {
                    this.namingEnumeration = new StudioNamingEnumeration(JNDIConnectionWrapper.this.connection, searchCtx, null, e, searchBase, filter, searchControls, aliasesDereferencingMethod, referralsHandlingMethod, controls, requestNum, monitor, referralsInfo);
                }
                catch (ReferralException e) {
                    this.namingEnumeration = new StudioNamingEnumeration(JNDIConnectionWrapper.this.connection, searchCtx, null, e, searchBase, filter, searchControls, aliasesDereferencingMethod, referralsHandlingMethod, controls, requestNum, monitor, referralsInfo);
                }
                catch (NamingException e) {
                    this.namingException = e;
                }
                for (IJndiLogger logger : JNDIConnectionWrapper.this.getJndiLoggers()) {
                    if (this.namingEnumeration != null) {
                        logger.logSearchRequest(JNDIConnectionWrapper.this.connection, searchBase, filter, searchControls, aliasesDereferencingMethod, controls, requestNum, this.namingException);
                        continue;
                    }
                    logger.logSearchRequest(JNDIConnectionWrapper.this.connection, searchBase, filter, searchControls, aliasesDereferencingMethod, controls, requestNum, this.namingException);
                    logger.logSearchResultDone(JNDIConnectionWrapper.this.connection, 0L, requestNum, this.namingException);
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (NamingException ne) {
            monitor.reportError(ne);
            return null;
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
            return null;
        }
        return runnable.getResult();
    }

    public void modifyEntry(final String dn, final ModificationItem[] modificationItems, final Control[] controls, final StudioProgressMonitor monitor, final ReferralsInfo referralsInfo) {
        if (this.connection.isReadOnly()) {
            monitor.reportError(NLS.bind((String)Messages.error__connection_is_readonly, (Object)this.connection.getName()));
            return;
        }
        InnerRunnable runnable = new InnerRunnable(){

            public void run() {
                boolean logModifycation = true;
                try {
                    LdapContext modCtx = JNDIConnectionWrapper.this.context.newInstance(controls);
                    modCtx.addToEnvironment("java.naming.referral", JNDIConnectionWrapper.REFERRAL_THROW);
                    modCtx.modifyAttributes(JNDIConnectionWrapper.getSaveJndiName(dn), modificationItems);
                }
                catch (ReferralException re) {
                    logModifycation = false;
                    try {
                        ReferralsInfo newReferralsInfo = JNDIConnectionWrapper.handleReferralException(re, referralsInfo);
                        ReferralsInfo.Referral referral = newReferralsInfo.getNextReferral();
                        if (referral != null) {
                            Connection referralConnection = JNDIConnectionWrapper.getReferralConnection(referral, monitor, this);
                            if (referralConnection != null) {
                                String referralDn = referral.getLdapURLs().get(0).getDn().getUpName();
                                referralConnection.getJNDIConnectionWrapper().modifyEntry(referralDn, modificationItems, controls, monitor, newReferralsInfo);
                            } else {
                                this.canceled = true;
                            }
                        }
                        return;
                    }
                    catch (NamingException ne) {
                        this.namingException = ne;
                    }
                }
                catch (NamingException ne) {
                    this.namingException = ne;
                }
                if (logModifycation) {
                    for (IJndiLogger logger : JNDIConnectionWrapper.this.getJndiLoggers()) {
                        logger.logChangetypeModify(JNDIConnectionWrapper.this.connection, dn, modificationItems, controls, this.namingException);
                    }
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (NamingException ne) {
            monitor.reportError(ne);
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
        }
    }

    public void renameEntry(final String oldDn, final String newDn, final boolean deleteOldRdn, final Control[] controls, final StudioProgressMonitor monitor, final ReferralsInfo referralsInfo) {
        if (this.connection.isReadOnly()) {
            monitor.reportError(NLS.bind((String)Messages.error__connection_is_readonly, (Object)this.connection.getName()));
            return;
        }
        InnerRunnable runnable = new InnerRunnable(){

            public void run() {
                boolean logModifycation;
                block10: {
                    logModifycation = true;
                    try {
                        LdapContext modCtx = JNDIConnectionWrapper.this.context.newInstance(controls);
                        modCtx.addToEnvironment("java.naming.referral", JNDIConnectionWrapper.REFERRAL_THROW);
                        if (deleteOldRdn) {
                            modCtx.addToEnvironment(JNDIConnectionWrapper.JAVA_NAMING_LDAP_DELETE_RDN, "true");
                        } else {
                            modCtx.addToEnvironment(JNDIConnectionWrapper.JAVA_NAMING_LDAP_DELETE_RDN, "false");
                        }
                        modCtx.rename(JNDIConnectionWrapper.getSaveJndiName(oldDn), JNDIConnectionWrapper.getSaveJndiName(newDn));
                    }
                    catch (ReferralException re) {
                        logModifycation = false;
                        try {
                            ReferralsInfo newReferralsInfo = JNDIConnectionWrapper.handleReferralException(re, referralsInfo);
                            ReferralsInfo.Referral referral = newReferralsInfo.getNextReferral();
                            if (referral == null) break block10;
                            Connection referralConnection = JNDIConnectionWrapper.getReferralConnection(referral, monitor, this);
                            if (referralConnection != null) {
                                referralConnection.getJNDIConnectionWrapper().renameEntry(oldDn, newDn, deleteOldRdn, controls, monitor, newReferralsInfo);
                            }
                            this.canceled = true;
                        }
                        catch (NamingException ne) {
                            this.namingException = ne;
                        }
                    }
                    catch (NamingException ne) {
                        this.namingException = ne;
                    }
                }
                if (logModifycation) {
                    for (IJndiLogger logger : JNDIConnectionWrapper.this.getJndiLoggers()) {
                        logger.logChangetypeModDn(JNDIConnectionWrapper.this.connection, oldDn, newDn, deleteOldRdn, controls, this.namingException);
                    }
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (NamingException ne) {
            monitor.reportError(ne);
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
        }
    }

    public void createEntry(final String dn, final Attributes attributes, final Control[] controls, final StudioProgressMonitor monitor, final ReferralsInfo referralsInfo) {
        if (this.connection.isReadOnly()) {
            monitor.reportError(NLS.bind((String)Messages.error__connection_is_readonly, (Object)this.connection.getName()));
            return;
        }
        InnerRunnable runnable = new InnerRunnable(){

            public void run() {
                boolean logModifycation;
                block8: {
                    logModifycation = true;
                    try {
                        LdapContext modCtx = JNDIConnectionWrapper.this.context.newInstance(controls);
                        modCtx.addToEnvironment("java.naming.referral", JNDIConnectionWrapper.REFERRAL_THROW);
                        modCtx.createSubcontext(JNDIConnectionWrapper.getSaveJndiName(dn), attributes);
                    }
                    catch (ReferralException re) {
                        logModifycation = false;
                        try {
                            ReferralsInfo newReferralsInfo = JNDIConnectionWrapper.handleReferralException(re, referralsInfo);
                            ReferralsInfo.Referral referral = newReferralsInfo.getNextReferral();
                            if (referral == null) break block8;
                            Connection referralConnection = JNDIConnectionWrapper.getReferralConnection(referral, monitor, this);
                            if (referralConnection != null) {
                                String referralDn = referral.getLdapURLs().get(0).getDn().getUpName();
                                referralConnection.getJNDIConnectionWrapper().createEntry(referralDn, attributes, controls, monitor, newReferralsInfo);
                            }
                            this.canceled = true;
                        }
                        catch (NamingException ne) {
                            this.namingException = ne;
                        }
                    }
                    catch (NamingException ne) {
                        this.namingException = ne;
                    }
                }
                if (logModifycation) {
                    for (IJndiLogger logger : JNDIConnectionWrapper.this.getJndiLoggers()) {
                        logger.logChangetypeAdd(JNDIConnectionWrapper.this.connection, dn, attributes, controls, this.namingException);
                    }
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (NamingException ne) {
            monitor.reportError(ne);
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
        }
    }

    public void deleteEntry(final String dn, final Control[] controls, final StudioProgressMonitor monitor, final ReferralsInfo referralsInfo) {
        if (this.connection.isReadOnly()) {
            monitor.reportError(NLS.bind((String)Messages.error__connection_is_readonly, (Object)this.connection.getName()));
            return;
        }
        InnerRunnable runnable = new InnerRunnable(){

            public void run() {
                boolean logModifycation;
                block8: {
                    logModifycation = true;
                    try {
                        LdapContext modCtx = JNDIConnectionWrapper.this.context.newInstance(controls);
                        modCtx.addToEnvironment("java.naming.referral", JNDIConnectionWrapper.REFERRAL_THROW);
                        modCtx.destroySubcontext(JNDIConnectionWrapper.getSaveJndiName(dn));
                    }
                    catch (ReferralException re) {
                        logModifycation = false;
                        try {
                            ReferralsInfo newReferralsInfo = JNDIConnectionWrapper.handleReferralException(re, referralsInfo);
                            ReferralsInfo.Referral referral = newReferralsInfo.getNextReferral();
                            if (referral == null) break block8;
                            Connection referralConnection = JNDIConnectionWrapper.getReferralConnection(referral, monitor, this);
                            if (referralConnection != null) {
                                String referralDn = referral.getLdapURLs().get(0).getDn().getUpName();
                                referralConnection.getJNDIConnectionWrapper().deleteEntry(referralDn, controls, monitor, newReferralsInfo);
                            }
                            this.canceled = true;
                        }
                        catch (NamingException ne) {
                            this.namingException = ne;
                        }
                    }
                    catch (NamingException ne) {
                        this.namingException = ne;
                    }
                }
                if (logModifycation) {
                    for (IJndiLogger logger : JNDIConnectionWrapper.this.getJndiLoggers()) {
                        logger.logChangetypeDelete(JNDIConnectionWrapper.this.connection, dn, controls, this.namingException);
                    }
                }
            }
        };
        try {
            this.checkConnectionAndRunAndMonitor(runnable, monitor);
        }
        catch (NamingException ne) {
            monitor.reportError(ne);
        }
        if (runnable.isCanceled()) {
            monitor.setCanceled(true);
        }
        if (runnable.getException() != null) {
            monitor.reportError(runnable.getException());
        }
    }

    private void doConnect(StudioProgressMonitor monitor) throws NamingException {
        this.context = null;
        this.isConnected = true;
        String host = this.connection.getConnectionParameter().getHost();
        int port = this.connection.getConnectionParameter().getPort();
        this.useLdaps = this.connection.getConnectionParameter().getEncryptionMethod() == ConnectionParameter.EncryptionMethod.LDAPS;
        this.useStartTLS = this.connection.getConnectionParameter().getEncryptionMethod() == ConnectionParameter.EncryptionMethod.START_TLS;
        this.environment = new Hashtable();
        Preferences preferences = ConnectionCorePlugin.getDefault().getPluginPreferences();
        final boolean validateCertificates = preferences.getBoolean("validateCertificates");
        String ldapCtxFactory = preferences.getString("ldapContextFactory");
        this.environment.put("java.naming.factory.initial", ldapCtxFactory);
        this.environment.put(JAVA_NAMING_LDAP_VERSION, "3");
        if (!this.useLdaps) {
            this.environment.put(COM_SUN_JNDI_LDAP_CONNECT_TIMEOUT, "10000");
        }
        this.environment.put(COM_SUN_JNDI_DNS_TIMEOUT_INITIAL, "2000");
        this.environment.put(COM_SUN_JNDI_DNS_TIMEOUT_RETRIES, "3");
        if (this.useLdaps) {
            this.environment.put("java.naming.provider.url", "ldaps://" + host + ':' + port);
            this.environment.put("java.naming.security.protocol", "ssl");
            this.environment.put(JAVA_NAMING_LDAP_FACTORY_SOCKET, validateCertificates ? StudioSSLSocketFactory.class.getName() : DummySSLSocketFactory.class.getName());
        } else {
            this.environment.put("java.naming.provider.url", "ldap://" + host + ':' + port);
        }
        if (this.binaryAttributes != null) {
            this.setBinaryAttributes(this.binaryAttributes);
        }
        InnerRunnable runnable = new InnerRunnable(){

            public void run() {
                block5: {
                    try {
                        JNDIConnectionWrapper.this.context = new InitialLdapContext(JNDIConnectionWrapper.this.environment, null);
                        if (!JNDIConnectionWrapper.this.useStartTLS) break block5;
                        try {
                            StartTlsResponse tls = (StartTlsResponse)JNDIConnectionWrapper.this.context.extendedOperation(new StartTlsRequest());
                            tls.setHostnameVerifier(new HostnameVerifier(){

                                public boolean verify(String hostname, SSLSession session) {
                                    return true;
                                }
                            });
                            if (validateCertificates) {
                                tls.negotiate(StudioSSLSocketFactory.getDefault());
                                break block5;
                            }
                            tls.negotiate(DummySSLSocketFactory.getDefault());
                        }
                        catch (Exception e) {
                            this.namingException = new NamingException(e.getMessage() != null ? e.getMessage() : "Error while establishing TLS session");
                            this.namingException.setRootCause(e);
                            JNDIConnectionWrapper.this.context.close();
                        }
                    }
                    catch (NamingException ne) {
                        this.namingException = ne;
                    }
                }
            }
        };
        this.runAndMonitor(runnable, monitor);
        if (runnable.getException() != null) {
            throw runnable.getException();
        }
        if (this.context == null) {
            throw new NamingException("???");
        }
    }

    private void doBind(StudioProgressMonitor monitor) throws NamingException {
        if (this.context != null && this.isConnected) {
            this.authMethod = AUTHMETHOD_NONE;
            if (this.connection.getConnectionParameter().getAuthMethod() == ConnectionParameter.AuthenticationMethod.SIMPLE) {
                this.authMethod = AUTHMETHOD_SIMPLE;
            } else if (this.connection.getConnectionParameter().getAuthMethod() == ConnectionParameter.AuthenticationMethod.SASL_DIGEST_MD5) {
                this.authMethod = AUTHMETHOD_DIGEST_MD5;
                this.saslRealm = this.connection.getConnectionParameter().getSaslRealm();
            } else if (this.connection.getConnectionParameter().getAuthMethod() == ConnectionParameter.AuthenticationMethod.SASL_CRAM_MD5) {
                this.authMethod = AUTHMETHOD_CRAM_MD5;
            } else if (this.connection.getConnectionParameter().getAuthMethod() == ConnectionParameter.AuthenticationMethod.SASL_GSSAPI) {
                this.authMethod = AUTHMETHOD_GSSAPI;
            }
            IAuthHandler authHandler = ConnectionCorePlugin.getDefault().getAuthHandler();
            if (authHandler == null) {
                NamingException namingException = new NamingException(Messages.model__no_auth_handler);
                monitor.reportError(Messages.model__no_auth_handler, namingException);
                throw namingException;
            }
            ICredentials credentials = authHandler.getCredentials(this.connection.getConnectionParameter());
            if (credentials == null) {
                CancelException cancelException = new CancelException();
                monitor.setCanceled(true);
                monitor.reportError(Messages.model__no_credentials, cancelException);
                throw cancelException;
            }
            if (credentials.getBindPrincipal() == null || credentials.getBindPassword() == null) {
                NamingException namingException = new NamingException(Messages.model__no_credentials);
                monitor.reportError(Messages.model__no_credentials, namingException);
                throw namingException;
            }
            this.bindPrincipal = credentials.getBindPrincipal();
            this.bindCredentials = credentials.getBindPassword();
            InnerRunnable runnable = new InnerRunnable(){

                public void run() {
                    try {
                        JNDIConnectionWrapper.this.context.removeFromEnvironment("java.naming.security.authentication");
                        JNDIConnectionWrapper.this.context.removeFromEnvironment("java.naming.security.principal");
                        JNDIConnectionWrapper.this.context.removeFromEnvironment("java.naming.security.credentials");
                        JNDIConnectionWrapper.this.context.removeFromEnvironment(JNDIConnectionWrapper.JAVA_NAMING_SECURITY_SASL_REALM);
                        JNDIConnectionWrapper.this.context.addToEnvironment("java.naming.security.authentication", JNDIConnectionWrapper.this.authMethod);
                        if (JNDIConnectionWrapper.this.connection.getConnectionParameter().getAuthMethod() == ConnectionParameter.AuthenticationMethod.SASL_CRAM_MD5 || JNDIConnectionWrapper.this.connection.getConnectionParameter().getAuthMethod() == ConnectionParameter.AuthenticationMethod.SASL_DIGEST_MD5 || JNDIConnectionWrapper.this.connection.getConnectionParameter().getAuthMethod() == ConnectionParameter.AuthenticationMethod.SASL_GSSAPI) {
                            switch (JNDIConnectionWrapper.this.connection.getConnectionParameter().getSaslQop()) {
                                case AUTH: {
                                    JNDIConnectionWrapper.this.context.addToEnvironment("javax.security.sasl.qop", "auth");
                                    break;
                                }
                                case AUTH_INT: {
                                    JNDIConnectionWrapper.this.context.addToEnvironment("javax.security.sasl.qop", "auth-int");
                                    break;
                                }
                                case AUTH_INT_PRIV: {
                                    JNDIConnectionWrapper.this.context.addToEnvironment("javax.security.sasl.qop", "auth-conf");
                                }
                            }
                            if (JNDIConnectionWrapper.this.connection.getConnectionParameter().isSaslMutualAuthentication()) {
                                JNDIConnectionWrapper.this.context.addToEnvironment("javax.security.sasl.server.authentication", "true");
                            } else {
                                JNDIConnectionWrapper.this.context.removeFromEnvironment("javax.security.sasl.server.authentication");
                            }
                            switch (JNDIConnectionWrapper.this.connection.getConnectionParameter().getSaslSecurityStrength()) {
                                case HIGH: {
                                    JNDIConnectionWrapper.this.context.addToEnvironment("javax.security.sasl.strength", "high");
                                    break;
                                }
                                case MEDIUM: {
                                    JNDIConnectionWrapper.this.context.addToEnvironment("javax.security.sasl.strength", "medium");
                                    break;
                                }
                                case LOW: {
                                    JNDIConnectionWrapper.this.context.addToEnvironment("javax.security.sasl.strength", "low");
                                }
                            }
                        }
                        if (JNDIConnectionWrapper.this.connection.getConnectionParameter().getAuthMethod() == ConnectionParameter.AuthenticationMethod.SASL_GSSAPI) {
                            JNDIConnectionWrapper.this.doGssapiBind(this);
                        } else {
                            JNDIConnectionWrapper.this.context.addToEnvironment("java.naming.security.principal", JNDIConnectionWrapper.this.bindPrincipal);
                            JNDIConnectionWrapper.this.context.addToEnvironment("java.naming.security.credentials", JNDIConnectionWrapper.this.bindCredentials);
                            if (JNDIConnectionWrapper.this.connection.getConnectionParameter().getAuthMethod() == ConnectionParameter.AuthenticationMethod.SASL_DIGEST_MD5 && StringUtils.isNotEmpty((String)JNDIConnectionWrapper.this.saslRealm)) {
                                JNDIConnectionWrapper.this.context.addToEnvironment(JNDIConnectionWrapper.JAVA_NAMING_SECURITY_SASL_REALM, JNDIConnectionWrapper.this.saslRealm);
                            }
                            JNDIConnectionWrapper.this.context.reconnect(JNDIConnectionWrapper.this.context.getConnectControls());
                        }
                    }
                    catch (NamingException ne) {
                        this.namingException = ne;
                    }
                }
            };
            this.runAndMonitor(runnable, monitor);
            if (runnable.getException() != null) {
                throw runnable.getException();
            }
            if (this.context == null) {
                throw new NamingException("???");
            }
        } else {
            throw new NamingException(NO_CONNECTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGssapiBind(final InnerRunnable innerRunnable) throws NamingException {
        File configFile = null;
        try {
            Preferences preferences = ConnectionCorePlugin.getDefault().getPluginPreferences();
            boolean useKrb5SystemProperties = preferences.getBoolean("useKrb5SystemProperties");
            String krb5LoginModule = preferences.getString("krb5LoginModule");
            if (!useKrb5SystemProperties) {
                switch (this.connection.getConnectionParameter().getKrb5Configuration()) {
                    case DEFAULT: {
                        System.clearProperty("java.security.krb5.conf");
                        break;
                    }
                    case FILE: {
                        System.setProperty("java.security.krb5.conf", this.connection.getConnectionParameter().getKrb5ConfigurationFile());
                        break;
                    }
                    case MANUAL: {
                        String fileName = Utils.getFilenameString(this.connection.getId()) + ".krb5.conf";
                        configFile = ConnectionCorePlugin.getDefault().getStateLocation().append(fileName).toFile();
                        String realm = this.connection.getConnectionParameter().getKrb5Realm();
                        String host = this.connection.getConnectionParameter().getKrb5KdcHost();
                        int port = this.connection.getConnectionParameter().getKrb5KdcPort();
                        StringBuilder sb = new StringBuilder();
                        sb.append("[libdefaults]").append(ConnectionCoreConstants.LINE_SEPARATOR);
                        sb.append("default_realm = ").append(realm).append(ConnectionCoreConstants.LINE_SEPARATOR);
                        sb.append("[realms]").append(ConnectionCoreConstants.LINE_SEPARATOR);
                        sb.append(realm).append(" = {").append(ConnectionCoreConstants.LINE_SEPARATOR);
                        sb.append("kdc = ").append(host).append(":").append(port).append(ConnectionCoreConstants.LINE_SEPARATOR);
                        sb.append("}").append(ConnectionCoreConstants.LINE_SEPARATOR);
                        try {
                            FileUtils.writeStringToFile((File)configFile, (String)sb.toString());
                        }
                        catch (IOException ioe) {
                            NamingException ne = new NamingException();
                            ne.setRootCause(ioe);
                            throw ne;
                        }
                        System.setProperty("java.security.krb5.conf", configFile.getAbsolutePath());
                    }
                }
                Configuration.setConfiguration(new InnerConfiguration(krb5LoginModule));
            }
            LoginContext lc = null;
            try {
                lc = new LoginContext(this.getClass().getName(), new InnerCallbackHandler());
                lc.login();
            }
            catch (LoginException le) {
                NamingException ne = new NamingException();
                ne.setRootCause(le);
                throw ne;
            }
            Subject.doAs(lc.getSubject(), new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        JNDIConnectionWrapper.this.context.reconnect(JNDIConnectionWrapper.this.context.getConnectControls());
                    }
                    catch (NamingException ne) {
                        innerRunnable.namingException = ne;
                    }
                    return null;
                }
            });
        }
        finally {
            if (configFile != null && configFile.exists()) {
                configFile.delete();
            }
        }
    }

    private void checkConnectionAndRunAndMonitor(InnerRunnable runnable, StudioProgressMonitor monitor) throws NamingException {
        if (!this.isConnected || this.context == null) {
            this.doConnect(monitor);
            this.doBind(monitor);
        }
        if (this.context == null) {
            throw new NamingException(NO_CONNECTION);
        }
        for (int i = 0; i <= 1; ++i) {
            this.runAndMonitor(runnable, monitor);
            if (i != 0 || runnable.getException() == null || !(runnable.getException() instanceof CommunicationException) && !(runnable.getException() instanceof ServiceUnavailableException) && !(runnable.getException() instanceof InsufficientResourcesException)) break;
            this.doConnect(monitor);
            this.doBind(monitor);
            runnable.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAndMonitor(InnerRunnable runnable, final StudioProgressMonitor monitor) throws CancelException {
        if (!monitor.isCanceled()) {
            StudioProgressMonitor.CancelListener listener = new StudioProgressMonitor.CancelListener(){

                public void cancelRequested(StudioProgressMonitor.CancelEvent event) {
                    if (monitor.isCanceled()) {
                        if (JNDIConnectionWrapper.this.jobThread != null && JNDIConnectionWrapper.this.jobThread.isAlive()) {
                            JNDIConnectionWrapper.this.jobThread.interrupt();
                        }
                        if (JNDIConnectionWrapper.this.context != null) {
                            try {
                                JNDIConnectionWrapper.this.context.close();
                            }
                            catch (NamingException namingException) {
                                // empty catch block
                            }
                            JNDIConnectionWrapper.this.isConnected = false;
                            JNDIConnectionWrapper.this.context = null;
                            System.gc();
                        }
                        JNDIConnectionWrapper.this.isConnected = false;
                    }
                }
            };
            monitor.addCancelListener(listener);
            this.jobThread = Thread.currentThread();
            try {
                runnable.run();
            }
            finally {
                monitor.removeCancelListener(listener);
                this.jobThread = null;
            }
            if (monitor.isCanceled()) {
                throw new CancelException();
            }
        }
    }

    private List<IJndiLogger> getJndiLoggers() {
        return ConnectionCorePlugin.getDefault().getJndiLoggers();
    }

    private String translateDerefAliasMethod(Connection.AliasDereferencingMethod aliasDereferencingMethod) {
        String m = ALIAS_ALWAYS;
        switch (aliasDereferencingMethod) {
            case NEVER: {
                m = ALIAS_NEVER;
                break;
            }
            case ALWAYS: {
                m = ALIAS_ALWAYS;
                break;
            }
            case FINDING: {
                m = ALIAS_FINDING;
                break;
            }
            case SEARCH: {
                m = ALIAS_SEARCHING;
            }
        }
        return m;
    }

    static Name getSaveJndiName(String name) throws InvalidNameException {
        if (name == null || StringUtils.isEmpty((String)name)) {
            return new CompositeName();
        }
        return new LdapName(name);
    }

    static Connection getReferralConnection(ReferralsInfo.Referral referral, StudioProgressMonitor monitor, Object source) {
        Connection referralConnection = null;
        IReferralHandler referralHandler = ConnectionCorePlugin.getDefault().getReferralHandler();
        if (referralHandler != null && (referralConnection = referralHandler.getReferralConnection(referral.getLdapURLs())) != null && !referralConnection.getJNDIConnectionWrapper().isConnected()) {
            referralConnection.getJNDIConnectionWrapper().connect(monitor);
            referralConnection.getJNDIConnectionWrapper().bind(monitor);
            for (IConnectionListener listener : ConnectionCorePlugin.getDefault().getConnectionListeners()) {
                listener.connectionOpened(referralConnection, monitor);
            }
            ConnectionEventRegistry.fireConnectionOpened(referralConnection, source);
        }
        return referralConnection;
    }

    static ReferralsInfo handleReferralException(ReferralException referralException, ReferralsInfo initialReferralsInfo) throws NamingException {
        if (initialReferralsInfo == null) {
            initialReferralsInfo = new ReferralsInfo();
        }
        ReferralsInfo.Referral referral = JNDIConnectionWrapper.handleReferralException(referralException, initialReferralsInfo, null);
        while (referralException.skipReferral()) {
            try {
                Context ctx = referralException.getReferralContext();
                ctx.list("");
            }
            catch (NamingException ne) {
                if (!(ne instanceof ReferralException)) break;
                if (ne != referralException) {
                    referral = null;
                }
                referralException = (ReferralException)ne;
                referral = JNDIConnectionWrapper.handleReferralException(referralException, initialReferralsInfo, referral);
            }
        }
        return initialReferralsInfo;
    }

    private static ReferralsInfo.Referral handleReferralException(ReferralException referralException, ReferralsInfo initialReferralsInfo, ReferralsInfo.Referral referral) throws NamingException {
        try {
            String info = (String)referralException.getReferralInfo();
            String name = referralException.getRemainingName().toString();
            LdapURL url = new LdapURL(info);
            LdapDN dn = new LdapDN(name);
            if (referral == null) {
                ReferralsInfo referralsInfo = initialReferralsInfo;
                referralsInfo.getClass();
                referral = new ReferralsInfo.Referral(referralsInfo, dn);
                initialReferralsInfo.addReferral(referral);
            }
            referral.addUrl(url);
        }
        catch (LdapURLEncodingException ldapURLEncodingException) {
            // empty catch block
        }
        return referral;
    }

    abstract class InnerRunnable
    implements Runnable {
        protected StudioNamingEnumeration namingEnumeration = null;
        protected NamingException namingException = null;
        protected boolean canceled = false;

        InnerRunnable() {
        }

        public NamingException getException() {
            return this.namingException;
        }

        public StudioNamingEnumeration getResult() {
            return this.namingEnumeration;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void reset() {
            this.namingEnumeration = null;
            this.namingException = null;
            this.canceled = false;
        }
    }

    private final class InnerCallbackHandler
    implements CallbackHandler {
        private InnerCallbackHandler() {
        }

        public void handle(Callback[] callbacks) throws UnsupportedCallbackException, IOException {
            for (int ii = 0; ii < callbacks.length; ++ii) {
                Callback callBack = callbacks[ii];
                if (callBack instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callBack;
                    nameCallback.setName(JNDIConnectionWrapper.this.bindPrincipal);
                    continue;
                }
                if (callBack instanceof PasswordCallback) {
                    PasswordCallback passwordCallback = (PasswordCallback)callBack;
                    passwordCallback.setPassword(JNDIConnectionWrapper.this.bindCredentials.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callBack, "Callback not supported");
            }
        }
    }

    private final class InnerConfiguration
    extends Configuration {
        private String krb5LoginModule;
        private AppConfigurationEntry[] configList = null;

        public InnerConfiguration(String krb5LoginModule) {
            this.krb5LoginModule = krb5LoginModule;
        }

        public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
            if (this.configList == null) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("refreshKrb5Config", "true");
                switch (JNDIConnectionWrapper.this.connection.getConnectionParameter().getKrb5CredentialConfiguration()) {
                    case USE_NATIVE: {
                        options.put("useTicketCache", "true");
                        options.put("doNotPrompt", "true");
                        break;
                    }
                    case OBTAIN_TGT: {
                        options.put("doNotPrompt", "false");
                    }
                }
                this.configList = new AppConfigurationEntry[1];
                this.configList[0] = new AppConfigurationEntry(this.krb5LoginModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
            }
            return this.configList;
        }

        public void refresh() {
        }
    }
}

