/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCoreConstants;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.event.EventRunnable;
import org.apache.directory.studio.connection.core.event.EventRunnableFactory;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ConnectionEventRegistry {
    private static List<Long> suspendedEventFiringThreads = new ArrayList<Long>();
    protected static Object lock = new Object();
    private static List<Long> fireTimeStamps = new ArrayList<Long>();
    private static long fireCount = 0L;
    private static final EventManager<ConnectionUpdateListener, EventRunner> connectionUpdateEventManager = new EventManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isEventFiringSuspendedInCurrentThread() {
        boolean suspended = suspendedEventFiringThreads.contains(Thread.currentThread().getId());
        if (!suspended) {
            ++fireCount;
            List<Long> list = fireTimeStamps;
            synchronized (list) {
                Long ts;
                long now = System.currentTimeMillis();
                Iterator<Long> it = fireTimeStamps.iterator();
                while (it.hasNext() && (ts = it.next()) + 1000L < now) {
                    it.remove();
                }
                fireTimeStamps.add(now);
                if (fireTimeStamps.size() > 5) {
                    String message = "Warning: More then " + fireTimeStamps.size() + " events were fired per second!";
                    ConnectionCorePlugin.getDefault().getLog().log((IStatus)new Status(2, ConnectionCoreConstants.PLUGIN_ID, message, (Throwable)new Exception(message)));
                }
            }
        }
        return suspended;
    }

    public static long getFireCount() {
        return fireCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resumeEventFiringInCurrentThread() {
        List<Long> list = suspendedEventFiringThreads;
        synchronized (list) {
            suspendedEventFiringThreads.remove(Thread.currentThread().getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void suspendEventFiringInCurrentThread() {
        List<Long> list = suspendedEventFiringThreads;
        synchronized (list) {
            suspendedEventFiringThreads.add(Thread.currentThread().getId());
        }
    }

    public static void addConnectionUpdateListener(ConnectionUpdateListener listener, EventRunner runner) {
        connectionUpdateEventManager.addListener(listener, runner);
    }

    public static void removeConnectionUpdateListener(ConnectionUpdateListener listener) {
        connectionUpdateEventManager.removeListener(listener);
    }

    public static void fireConnectionOpened(final Connection connection, Object source) {
        EventRunnableFactory<ConnectionUpdateListener> factory = new EventRunnableFactory<ConnectionUpdateListener>(){

            @Override
            public EventRunnable createEventRunnable(final ConnectionUpdateListener listener) {
                return new EventRunnable(){

                    public void run() {
                        listener.connectionOpened(connection);
                    }
                };
            }
        };
        connectionUpdateEventManager.fire(factory);
    }

    public static void fireConnectionClosed(final Connection connection, Object source) {
        EventRunnableFactory<ConnectionUpdateListener> factory = new EventRunnableFactory<ConnectionUpdateListener>(){

            @Override
            public EventRunnable createEventRunnable(final ConnectionUpdateListener listener) {
                return new EventRunnable(){

                    public void run() {
                        listener.connectionClosed(connection);
                    }
                };
            }
        };
        connectionUpdateEventManager.fire(factory);
    }

    public static void fireConnectionUpdated(final Connection connection, Object source) {
        EventRunnableFactory<ConnectionUpdateListener> factory = new EventRunnableFactory<ConnectionUpdateListener>(){

            @Override
            public EventRunnable createEventRunnable(final ConnectionUpdateListener listener) {
                return new EventRunnable(){

                    public void run() {
                        listener.connectionUpdated(connection);
                    }
                };
            }
        };
        connectionUpdateEventManager.fire(factory);
    }

    public static void fireConnectionAdded(final Connection connection, Object source) {
        EventRunnableFactory<ConnectionUpdateListener> factory = new EventRunnableFactory<ConnectionUpdateListener>(){

            @Override
            public EventRunnable createEventRunnable(final ConnectionUpdateListener listener) {
                return new EventRunnable(){

                    public void run() {
                        listener.connectionAdded(connection);
                    }
                };
            }
        };
        connectionUpdateEventManager.fire(factory);
    }

    public static void fireConnectionRemoved(final Connection connection, Object source) {
        EventRunnableFactory<ConnectionUpdateListener> factory = new EventRunnableFactory<ConnectionUpdateListener>(){

            @Override
            public EventRunnable createEventRunnable(final ConnectionUpdateListener listener) {
                return new EventRunnable(){

                    public void run() {
                        listener.connectionRemoved(connection);
                    }
                };
            }
        };
        connectionUpdateEventManager.fire(factory);
    }

    public static void fireConnectonFolderModified(final ConnectionFolder connectionFolder, Object source) {
        EventRunnableFactory<ConnectionUpdateListener> factory = new EventRunnableFactory<ConnectionUpdateListener>(){

            @Override
            public EventRunnable createEventRunnable(final ConnectionUpdateListener listener) {
                return new EventRunnable(){

                    public void run() {
                        listener.connectionFolderModified(connectionFolder);
                    }
                };
            }
        };
        connectionUpdateEventManager.fire(factory);
    }

    public static void fireConnectonFolderAdded(final ConnectionFolder connectionFolder, Object source) {
        EventRunnableFactory<ConnectionUpdateListener> factory = new EventRunnableFactory<ConnectionUpdateListener>(){

            @Override
            public EventRunnable createEventRunnable(final ConnectionUpdateListener listener) {
                return new EventRunnable(){

                    public void run() {
                        listener.connectionFolderAdded(connectionFolder);
                    }
                };
            }
        };
        connectionUpdateEventManager.fire(factory);
    }

    public static void fireConnectonFolderRemoved(final ConnectionFolder connectionFolder, Object source) {
        EventRunnableFactory<ConnectionUpdateListener> factory = new EventRunnableFactory<ConnectionUpdateListener>(){

            @Override
            public EventRunnable createEventRunnable(final ConnectionUpdateListener listener) {
                return new EventRunnable(){

                    public void run() {
                        listener.connectionFolderRemoved(connectionFolder);
                    }
                };
            }
        };
        connectionUpdateEventManager.fire(factory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EventManager<L, R extends EventRunner> {
        private Map<L, EventRunner> listeners = new HashMap<L, EventRunner>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(L listener, R runner) {
            assert (listener != null);
            assert (runner != null);
            Map<L, EventRunner> map = this.listeners;
            synchronized (map) {
                if (!this.listeners.containsKey(listener)) {
                    this.listeners.put(listener, (EventRunner)runner);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(L listener) {
            Map<L, EventRunner> map = this.listeners;
            synchronized (map) {
                if (this.listeners.containsKey(listener)) {
                    this.listeners.remove(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fire(EventRunnableFactory<L> factory) {
            if (ConnectionEventRegistry.isEventFiringSuspendedInCurrentThread()) {
                return;
            }
            HashMap<L, EventRunner> clone = new HashMap<L, EventRunner>(this.listeners);
            for (Object listener : clone.keySet()) {
                EventRunner runner = (EventRunner)clone.get(listener);
                Object object = lock;
                synchronized (object) {
                    EventRunnable runnable = factory.createEventRunnable(listener);
                    runner.execute(runnable);
                }
            }
        }
    }
}

