/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import java.io.IOException;
import javax.naming.ldap.PagedResultsControl;
import org.apache.directory.studio.connection.core.StudioControl;

public class StudioPagedResultsControl
extends StudioControl {
    private static final long serialVersionUID = -6219375680879062812L;
    public static final String OID = "1.2.840.113556.1.4.319";
    public static final String NAME = "Simple Paged Results";
    private int size;
    private byte[] cookie;
    private boolean isScrollMode;

    public StudioPagedResultsControl() {
    }

    public StudioPagedResultsControl(int size, byte[] cookie, boolean critical, boolean isScrollMode) {
        super(NAME, OID, critical, null);
        this.size = size;
        this.cookie = cookie;
        this.isScrollMode = isScrollMode;
        this.encode();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
        this.encode();
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
        this.encode();
    }

    public boolean isScrollMode() {
        return this.isScrollMode;
    }

    public void setScrollMode(boolean isScrollMode) {
        this.isScrollMode = isScrollMode;
    }

    private void encode() {
        try {
            this.controlValue = new PagedResultsControl(this.size, this.cookie, this.critical).getEncodedValue();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isScrollMode ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StudioPagedResultsControl)) {
            return false;
        }
        StudioPagedResultsControl other = (StudioPagedResultsControl)obj;
        return this.toString().equals(other.toString()) && this.isScrollMode == other.isScrollMode;
    }
}

