/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.studio.connection.core.Messages;

public class DnUtils {
    public static LdapDN composeDn(Rdn rdn, LdapDN parent) {
        LdapDN ldapDn = (LdapDN)parent.clone();
        ldapDn.add((Rdn)rdn.clone());
        return ldapDn;
    }

    public static LdapDN getParent(LdapDN dn) {
        if (dn.size() < 1) {
            return null;
        }
        LdapDN parent = (LdapDN)dn.getPrefix(dn.size() - 1);
        return parent;
    }

    public static LdapDN composeDn(String rdn, String parent) throws InvalidNameException {
        return DnUtils.composeDn(new Rdn(rdn), new LdapDN(parent));
    }

    public static LdapDN composeDn(LdapDN prefix, LdapDN suffix) {
        LdapDN ldapDn = (LdapDN)suffix.clone();
        for (int i = 0; i < prefix.size(); ++i) {
            ldapDn.add((Rdn)prefix.getRdn(i).clone());
        }
        return ldapDn;
    }

    public static LdapDN getPrefixName(LdapDN dn, LdapDN suffix) {
        if (suffix.size() < 1) {
            return null;
        }
        LdapDN prefix = (LdapDN)dn.getSuffix(suffix.size());
        return prefix;
    }

    public static Rdn composeRdn(String[] rdnTypes, String[] rdnValues) throws InvalidNameException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < rdnTypes.length; ++i) {
            if (i > 0) {
                sb.append('+');
            }
            sb.append(rdnTypes[i]);
            sb.append('=');
            sb.append(Rdn.escapeValue((String)rdnValues[i]));
        }
        String s = sb.toString();
        try {
            if (LdapDN.isValid((String)s)) {
                Rdn rdn = new Rdn(sb.toString());
                return rdn;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        throw new InvalidNameException(Messages.error__invalid_rdn);
    }
}

