/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionParameter {
    private String id;
    private String name;
    private String host;
    private int port;
    private EncryptionMethod encryptionMethod;
    private AuthenticationMethod authMethod;
    private String bindPrincipal;
    private String bindPassword;
    private String saslRealm;
    private SaslQop saslQop = SaslQop.AUTH;
    private SaslSecurityStrength saslSecurityStrength = SaslSecurityStrength.HIGH;
    private boolean saslMutualAuthentication = true;
    private Krb5CredentialConfiguration krb5CredentialConfiguration = Krb5CredentialConfiguration.USE_NATIVE;
    private Krb5Configuration krb5Configuration = Krb5Configuration.DEFAULT;
    private String krb5ConfigurationFile;
    private String krb5Realm;
    private String krb5KdcHost;
    private int krb5KdcPort = 88;
    private boolean isReadOnly;
    private Map<String, String> extendedProperties;

    public ConnectionParameter() {
        this.extendedProperties = new HashMap<String, String>();
    }

    public ConnectionParameter(String name, String host, int port, EncryptionMethod encryptionMethod, AuthenticationMethod authMethod, String bindPrincipal, String bindPassword, String saslRealm, boolean isReadOnly, Map<String, String> extendedProperties) {
        this.id = this.createId();
        this.name = name;
        this.host = host;
        this.port = port;
        this.encryptionMethod = encryptionMethod;
        this.authMethod = authMethod;
        this.bindPrincipal = bindPrincipal;
        this.bindPassword = bindPassword;
        this.saslRealm = saslRealm;
        this.isReadOnly = isReadOnly;
        this.extendedProperties = new HashMap<String, String>();
        if (extendedProperties != null) {
            this.extendedProperties.putAll(extendedProperties);
        }
    }

    public AuthenticationMethod getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(AuthenticationMethod authMethod) {
        this.authMethod = authMethod;
    }

    public String getBindPassword() {
        return this.bindPassword;
    }

    public void setBindPassword(String bindPassword) {
        this.bindPassword = bindPassword;
    }

    public String getSaslRealm() {
        return this.saslRealm;
    }

    public void setSaslRealm(String saslRealm) {
        this.saslRealm = saslRealm;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public String getBindPrincipal() {
        return this.bindPrincipal;
    }

    public void setBindPrincipal(String bindPrincipal) {
        this.bindPrincipal = bindPrincipal;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public void setEncryptionMethod(EncryptionMethod encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.createId();
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public SaslQop getSaslQop() {
        return this.saslQop;
    }

    public void setSaslQop(SaslQop saslQop) {
        this.saslQop = saslQop;
    }

    public SaslSecurityStrength getSaslSecurityStrength() {
        return this.saslSecurityStrength;
    }

    public void setSaslSecurityStrength(SaslSecurityStrength saslSecurityStrength) {
        this.saslSecurityStrength = saslSecurityStrength;
    }

    public boolean isSaslMutualAuthentication() {
        return this.saslMutualAuthentication;
    }

    public void setSaslMutualAuthentication(boolean saslMutualAuthentication) {
        this.saslMutualAuthentication = saslMutualAuthentication;
    }

    public Krb5CredentialConfiguration getKrb5CredentialConfiguration() {
        return this.krb5CredentialConfiguration;
    }

    public void setKrb5CredentialConfiguration(Krb5CredentialConfiguration krb5CredentialConfiguration) {
        this.krb5CredentialConfiguration = krb5CredentialConfiguration;
    }

    public Krb5Configuration getKrb5Configuration() {
        return this.krb5Configuration;
    }

    public void setKrb5Configuration(Krb5Configuration krb5Configuration) {
        this.krb5Configuration = krb5Configuration;
    }

    public String getKrb5ConfigurationFile() {
        return this.krb5ConfigurationFile;
    }

    public void setKrb5ConfigurationFile(String krb5ConfigurationFile) {
        this.krb5ConfigurationFile = krb5ConfigurationFile;
    }

    public String getKrb5Realm() {
        return this.krb5Realm;
    }

    public void setKrb5Realm(String krb5Realm) {
        this.krb5Realm = krb5Realm;
    }

    public String getKrb5KdcHost() {
        return this.krb5KdcHost;
    }

    public void setKrb5KdcHost(String krb5KdcHost) {
        this.krb5KdcHost = krb5KdcHost;
    }

    public int getKrb5KdcPort() {
        return this.krb5KdcPort;
    }

    public void setKrb5KdcPort(int krb5KdcPort) {
        this.krb5KdcPort = krb5KdcPort;
    }

    public Map<String, String> getExtendedProperties() {
        return this.extendedProperties;
    }

    public void setExtendedProperties(Map<String, String> extendedProperties) {
        this.extendedProperties = extendedProperties;
    }

    public void setExtendedProperty(String key, String value) {
        this.extendedProperties.put(key, value);
    }

    public String getExtendedProperty(String key) {
        return this.extendedProperties.get(key);
    }

    public void setExtendedIntProperty(String key, int value) {
        this.extendedProperties.put(key, new Integer(value).toString());
    }

    public int getExtendedIntProperty(String key) {
        String s = this.extendedProperties.get(key);
        if (s != null) {
            return new Integer(s);
        }
        return -1;
    }

    public void setExtendedBoolProperty(String key, boolean value) {
        this.extendedProperties.put(key, Boolean.valueOf(value).toString());
    }

    public boolean getExtendedBoolProperty(String key) {
        String s = this.extendedProperties.get(key);
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    private String createId() {
        return UUID.randomUUID().toString();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionParameter) {
            ConnectionParameter other = (ConnectionParameter)obj;
            return this.getId().equals(other.getId());
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Krb5Configuration {
        DEFAULT,
        FILE,
        MANUAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Krb5CredentialConfiguration {
        USE_NATIVE,
        OBTAIN_TGT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SaslSecurityStrength {
        LOW,
        MEDIUM,
        HIGH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SaslQop {
        AUTH,
        AUTH_INT,
        AUTH_INT_PRIV;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthenticationMethod {
        NONE,
        SIMPLE,
        SASL_DIGEST_MD5,
        SASL_CRAM_MD5,
        SASL_GSSAPI;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EncryptionMethod {
        NONE,
        LDAPS,
        START_TLS;

    }
}

