/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.io.ConnectionIO;
import org.apache.directory.studio.connection.core.io.ConnectionIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFolderManager
implements ConnectionUpdateListener {
    private static final String CONNECTION_FOLDERS_FILENAME = "connectionFolders.xml";
    private static final String ROOT_ID = "0";
    private ConnectionFolder root = new ConnectionFolder("");
    private Set<ConnectionFolder> folderList;

    public ConnectionFolderManager() {
        this.root.setId(ROOT_ID);
        this.folderList = new HashSet<ConnectionFolder>();
        this.loadConnectionFolders();
        ConnectionEventRegistry.addConnectionUpdateListener(this, ConnectionCorePlugin.getDefault().getEventRunner());
        this.folderList.add(this.root);
    }

    public static final String getConnectionFolderStoreFileName() {
        String filename = ConnectionCorePlugin.getDefault().getStateLocation().append(CONNECTION_FOLDERS_FILENAME).toOSString();
        return filename;
    }

    public void addConnectionFolder(ConnectionFolder connectionFolder) {
        if (this.getConnectionFolderByName(connectionFolder.getName()) != null) {
            String newConnectionFolderName = Messages.bind((String)Messages.copy_n_of_s, (Object)"", (Object)connectionFolder.getName());
            int i = 2;
            while (this.getConnectionFolderByName(newConnectionFolderName) != null) {
                newConnectionFolderName = Messages.bind((String)Messages.copy_n_of_s, (Object)(i + " "), (Object)connectionFolder.getName());
                ++i;
            }
            connectionFolder.setName(newConnectionFolderName);
        }
        this.folderList.add(connectionFolder);
        ConnectionEventRegistry.fireConnectonFolderAdded(connectionFolder, this);
    }

    public void removeConnectionFolder(ConnectionFolder connectionFolder) {
        this.folderList.remove(connectionFolder);
        ConnectionEventRegistry.fireConnectonFolderRemoved(connectionFolder, this);
    }

    public ConnectionFolder[] getConnectionFolders() {
        return this.folderList.toArray(new ConnectionFolder[0]);
    }

    public ConnectionFolder getConnectionFolderById(String id) {
        for (ConnectionFolder folder : this.folderList) {
            if (!folder.getId().equals(id)) continue;
            return folder;
        }
        return null;
    }

    public ConnectionFolder getConnectionFolderByName(String name) {
        for (ConnectionFolder folder : this.folderList) {
            if (!folder.getName().equals(name)) continue;
            return folder;
        }
        return null;
    }

    public ConnectionFolder getParentConnectionFolder(Connection connection) {
        for (ConnectionFolder folder : this.folderList) {
            if (!folder.getConnectionIds().contains(connection.getId())) continue;
            return folder;
        }
        return this.getRootConnectionFolder();
    }

    public ConnectionFolder getParentConnectionFolder(ConnectionFolder connectionFolder) {
        for (ConnectionFolder folder : this.folderList) {
            if (!folder.getSubFolderIds().contains(connectionFolder.getId())) continue;
            return folder;
        }
        return null;
    }

    public Set<ConnectionFolder> getAllSubFolders(ConnectionFolder folder) {
        HashSet<ConnectionFolder> allSubFolders = new HashSet<ConnectionFolder>();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(folder.getId());
        while (!ids.isEmpty()) {
            String id = (String)ids.remove(0);
            ConnectionFolder subFolder = this.getConnectionFolderById(id);
            allSubFolders.add(subFolder);
            ids.addAll(subFolder.getSubFolderIds());
        }
        return allSubFolders;
    }

    public Set<ConnectionFolder> getAllParentFolders(ConnectionFolder folder) {
        HashSet<ConnectionFolder> allParentFolders = new HashSet<ConnectionFolder>();
        do {
            allParentFolders.add(folder);
        } while ((folder = this.getParentConnectionFolder(folder)) != null);
        return allParentFolders;
    }

    public ConnectionFolder getRootConnectionFolder() {
        return this.root;
    }

    public void setRootConnectionFolder(ConnectionFolder root) {
        this.root = root;
    }

    @Override
    public void connectionAdded(Connection connection) {
        this.saveConnectionFolders();
    }

    @Override
    public void connectionRemoved(Connection connection) {
        this.saveConnectionFolders();
    }

    @Override
    public void connectionUpdated(Connection connection) {
        this.saveConnectionFolders();
    }

    @Override
    public void connectionOpened(Connection connection) {
    }

    @Override
    public void connectionClosed(Connection connection) {
    }

    @Override
    public void connectionFolderModified(ConnectionFolder connectionFolder) {
        this.saveConnectionFolders();
    }

    @Override
    public void connectionFolderAdded(ConnectionFolder connectionFolder) {
        this.saveConnectionFolders();
    }

    @Override
    public void connectionFolderRemoved(ConnectionFolder connectionFolder) {
        this.saveConnectionFolders();
    }

    private synchronized void saveConnectionFolders() {
        try {
            ConnectionIO.saveConnectionFolders(this.folderList, new FileOutputStream(ConnectionFolderManager.getConnectionFolderStoreFileName() + "-temp"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file = new File(ConnectionFolderManager.getConnectionFolderStoreFileName());
        File tempFile = new File(ConnectionFolderManager.getConnectionFolderStoreFileName() + "-temp");
        if (file.exists()) {
            file.delete();
        }
        try {
            String content = FileUtils.readFileToString((File)tempFile, (String)"UTF-8");
            FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private synchronized void loadConnectionFolders() {
        ConnectionEventRegistry.suspendEventFiringInCurrentThread();
        try {
            this.folderList = ConnectionIO.loadConnectionFolders(new FileInputStream(ConnectionFolderManager.getConnectionFolderStoreFileName()));
        }
        catch (Exception e) {
            try {
                this.folderList = ConnectionIO.loadConnectionFolders(new FileInputStream(ConnectionFolderManager.getConnectionFolderStoreFileName() + "-temp"));
            }
            catch (FileNotFoundException e1) {
            }
            catch (ConnectionIOException e1) {
                // empty catch block
            }
        }
        if (!this.folderList.isEmpty()) {
            for (ConnectionFolder folder : this.folderList) {
                if (!ROOT_ID.equals(folder.getId())) continue;
                this.root = folder;
            }
        } else {
            Connection[] connections;
            for (Connection connection : connections = ConnectionCorePlugin.getDefault().getConnectionManager().getConnections()) {
                this.root.addConnectionId(connection.getId());
            }
        }
        ConnectionEventRegistry.resumeEventFiringInCurrentThread();
    }
}

