/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.PropertyResourceBundle;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCoreConstants;
import org.apache.directory.studio.connection.core.ConnectionFolderManager;
import org.apache.directory.studio.connection.core.ConnectionManager;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.Credentials;
import org.apache.directory.studio.connection.core.IAuthHandler;
import org.apache.directory.studio.connection.core.ICertificateHandler;
import org.apache.directory.studio.connection.core.IConnectionListener;
import org.apache.directory.studio.connection.core.ICredentials;
import org.apache.directory.studio.connection.core.IJndiLogger;
import org.apache.directory.studio.connection.core.IReferralHandler;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.StudioKeyStoreManager;
import org.apache.directory.studio.connection.core.event.CoreEventRunner;
import org.apache.directory.studio.connection.core.event.EventRunner;
import org.apache.directory.studio.connection.core.io.jndi.LdifModificationLogger;
import org.apache.directory.studio.connection.core.io.jndi.LdifSearchLogger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionCorePlugin
extends Plugin {
    private static final String PERMANENT_TRUST_STORE = "permanent.jks";
    private static final String PERMANENT_TRUST_STORE_PASSWORD = "changeit";
    private static ConnectionCorePlugin plugin;
    private ConnectionManager connectionManager;
    private ConnectionFolderManager connectionFolderManager;
    private StudioKeyStoreManager permanentTrustStoreManager;
    private StudioKeyStoreManager sessionTrustStoreManager;
    private EventRunner eventRunner;
    private IAuthHandler authHandler;
    private IReferralHandler referralHandler;
    private ICertificateHandler certificateHandler;
    private List<IJndiLogger> jndiLoggers;
    private List<IConnectionListener> connectionListeners;
    private PropertyResourceBundle properties;

    public ConnectionCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (this.eventRunner == null) {
            this.eventRunner = new CoreEventRunner();
        }
        if (this.connectionManager == null) {
            this.connectionManager = new ConnectionManager();
        }
        if (this.connectionFolderManager == null) {
            this.connectionFolderManager = new ConnectionFolderManager();
        }
        if (this.permanentTrustStoreManager == null) {
            this.permanentTrustStoreManager = StudioKeyStoreManager.createFileKeyStoreManager(PERMANENT_TRUST_STORE, PERMANENT_TRUST_STORE_PASSWORD);
        }
        if (this.sessionTrustStoreManager == null) {
            this.sessionTrustStoreManager = StudioKeyStoreManager.createMemoryKeyStoreManager();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        if (this.eventRunner != null) {
            this.eventRunner = null;
        }
        if (this.connectionManager != null) {
            Connection[] connections = this.connectionManager.getConnections();
            for (int i = 0; i < connections.length; ++i) {
                connections[i].getJNDIConnectionWrapper().disconnect();
            }
            this.connectionManager = null;
        }
        if (this.connectionFolderManager != null) {
            this.connectionFolderManager = null;
        }
        if (this.permanentTrustStoreManager != null) {
            this.permanentTrustStoreManager = null;
        }
        if (this.sessionTrustStoreManager != null) {
            this.sessionTrustStoreManager = null;
        }
    }

    public static ConnectionCorePlugin getDefault() {
        return plugin;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ConnectionFolderManager getConnectionFolderManager() {
        return this.connectionFolderManager;
    }

    public EventRunner getEventRunner() {
        return this.eventRunner;
    }

    public StudioKeyStoreManager getPermanentTrustStoreManager() {
        return this.permanentTrustStoreManager;
    }

    public StudioKeyStoreManager getSessionTrustStoreManager() {
        return this.sessionTrustStoreManager;
    }

    public IAuthHandler getAuthHandler() {
        if (this.authHandler == null) {
            this.authHandler = new IAuthHandler(){

                public ICredentials getCredentials(ConnectionParameter connectionParameter) {
                    if (connectionParameter.getBindPrincipal() == null || "".equals(connectionParameter.getBindPrincipal())) {
                        return new Credentials("", "", connectionParameter);
                    }
                    if (connectionParameter.getBindPassword() != null && !"".equals(connectionParameter.getBindPassword())) {
                        return new Credentials(connectionParameter.getBindPrincipal(), connectionParameter.getBindPassword(), connectionParameter);
                    }
                    return null;
                }
            };
        }
        return this.authHandler;
    }

    public void setAuthHandler(IAuthHandler authHandler) {
        this.authHandler = authHandler;
    }

    public IReferralHandler getReferralHandler() {
        if (this.referralHandler == null) {
            this.referralHandler = new IReferralHandler(){

                @Override
                public Connection getReferralConnection(List<LdapURL> referralUrls) {
                    return null;
                }
            };
        }
        return this.referralHandler;
    }

    public void setReferralHandler(IReferralHandler referralHandler) {
        this.referralHandler = referralHandler;
    }

    public ICertificateHandler getCertificateHandler() {
        if (this.certificateHandler == null) {
            this.certificateHandler = new ICertificateHandler(){

                @Override
                public ICertificateHandler.TrustLevel verifyTrustLevel(String host, X509Certificate[] certChain, List<ICertificateHandler.FailCause> failCauses) {
                    return ICertificateHandler.TrustLevel.Not;
                }
            };
        }
        return this.certificateHandler;
    }

    public void setCertificateHandler(ICertificateHandler certificateHandler) {
        this.certificateHandler = certificateHandler;
    }

    public LdifModificationLogger getLdifModificationLogger() {
        List<IJndiLogger> jndiLoggers = this.getJndiLoggers();
        for (IJndiLogger jndiLogger : jndiLoggers) {
            if (!(jndiLogger instanceof LdifModificationLogger)) continue;
            return (LdifModificationLogger)jndiLogger;
        }
        return null;
    }

    public LdifSearchLogger getLdifSearchLogger() {
        List<IJndiLogger> jndiLoggers = this.getJndiLoggers();
        for (IJndiLogger jndiLogger : jndiLoggers) {
            if (!(jndiLogger instanceof LdifSearchLogger)) continue;
            return (LdifSearchLogger)jndiLogger;
        }
        return null;
    }

    public List<IJndiLogger> getJndiLoggers() {
        if (this.jndiLoggers == null) {
            IConfigurationElement[] members;
            this.jndiLoggers = new ArrayList<IJndiLogger>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPluginProperties().getString("ExtensionPoint_JndiLogger_id"));
            for (IConfigurationElement member : members = extensionPoint.getConfigurationElements()) {
                try {
                    IJndiLogger logger = (IJndiLogger)member.createExecutableExtension("class");
                    logger.setId(member.getAttribute("id"));
                    logger.setName(member.getAttribute("name"));
                    logger.setDescription(member.getAttribute("description"));
                    this.jndiLoggers.add(logger);
                }
                catch (Exception e) {
                    this.getLog().log((IStatus)new Status(4, ConnectionCoreConstants.PLUGIN_ID, 1, Messages.error__unable_to_create_jndi_logger + member.getAttribute("class"), (Throwable)e));
                }
            }
        }
        return this.jndiLoggers;
    }

    public List<IConnectionListener> getConnectionListeners() {
        if (this.connectionListeners == null) {
            IConfigurationElement[] members;
            this.connectionListeners = new ArrayList<IConnectionListener>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(this.getPluginProperties().getString("ExtensionPoint_ConnectionListener_id"));
            for (IConfigurationElement member : members = extensionPoint.getConfigurationElements()) {
                try {
                    IConnectionListener listener = (IConnectionListener)member.createExecutableExtension("class");
                    this.connectionListeners.add(listener);
                }
                catch (Exception e) {
                    this.getLog().log((IStatus)new Status(4, ConnectionCoreConstants.PLUGIN_ID, 1, Messages.error__unable_to_create_connection_listener + member.getAttribute("class"), (Throwable)e));
                }
            }
        }
        return this.connectionListeners;
    }

    public PropertyResourceBundle getPluginProperties() {
        if (this.properties == null) {
            try {
                this.properties = new PropertyResourceBundle(FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path("plugin.properties"), (boolean)false));
            }
            catch (IOException e) {
                this.getLog().log((IStatus)new Status(4, "org.apache.directory.studio.connection.core", 0, Messages.error__unable_to_get_plugin_properties, (Throwable)e));
            }
        }
        return this.properties;
    }

    public String getDefaultLdapContextFactory() {
        String defaultLdapContextFactory = "";
        try {
            String sun = "com.sun.jndi.ldap.LdapCtxFactory";
            Class.forName(sun);
            defaultLdapContextFactory = sun;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            String apache = "org.apache.harmony.jndi.provider.ldap.LdapContextFactory";
            Class.forName(apache);
            defaultLdapContextFactory = apache;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return defaultLdapContextFactory;
    }

    public String getDefaultKrb5LoginModule() {
        String defaultKrb5LoginModule = "";
        try {
            String sun = "com.sun.security.auth.module.Krb5LoginModule";
            Class.forName(sun);
            defaultKrb5LoginModule = sun;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            String apache = "org.apache.harmony.auth.module.Krb5LoginModule";
            Class.forName(apache);
            defaultKrb5LoginModule = apache;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return defaultKrb5LoginModule;
    }
}

