/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.ConnectionPropertyPageProvider;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.io.jndi.JNDIConnectionWrapper;
import org.eclipse.core.runtime.IAdaptable;

public class Connection
implements ConnectionPropertyPageProvider,
IAdaptable {
    private ConnectionParameter connectionParameter;
    private JNDIConnectionWrapper jndiConnectionWrapper;

    public Connection(ConnectionParameter connectionParameter) {
        this.connectionParameter = connectionParameter;
    }

    public Object clone() {
        ConnectionParameter cp = new ConnectionParameter(this.getName(), this.getHost(), this.getPort(), this.getEncryptionMethod(), this.getAuthMethod(), this.getBindPrincipal(), this.getBindPassword(), this.getSaslRealm(), this.isReadOnly(), this.getConnectionParameter().getExtendedProperties());
        Connection clone = new Connection(cp);
        return clone;
    }

    public JNDIConnectionWrapper getJNDIConnectionWrapper() {
        if (this.jndiConnectionWrapper == null) {
            this.jndiConnectionWrapper = new JNDIConnectionWrapper(this);
        }
        return this.jndiConnectionWrapper;
    }

    public ConnectionParameter getConnectionParameter() {
        return this.connectionParameter;
    }

    public void setConnectionParameter(ConnectionParameter connectionParameter) {
        this.connectionParameter = connectionParameter;
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public ConnectionParameter.AuthenticationMethod getAuthMethod() {
        return this.connectionParameter.getAuthMethod();
    }

    public String getBindPassword() {
        return this.connectionParameter.getBindPassword();
    }

    public String getBindPrincipal() {
        return this.connectionParameter.getBindPrincipal();
    }

    public ConnectionParameter.EncryptionMethod getEncryptionMethod() {
        return this.connectionParameter.getEncryptionMethod();
    }

    public String getId() {
        return this.connectionParameter.getId();
    }

    public String getHost() {
        return this.connectionParameter.getHost();
    }

    public String getName() {
        return this.connectionParameter.getName();
    }

    public int getPort() {
        return this.connectionParameter.getPort();
    }

    public String getSaslRealm() {
        return this.connectionParameter.getSaslRealm();
    }

    public boolean isReadOnly() {
        return this.connectionParameter.isReadOnly();
    }

    public void setAuthMethod(ConnectionParameter.AuthenticationMethod authMethod) {
        this.connectionParameter.setAuthMethod(authMethod);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setBindPassword(String bindPassword) {
        this.connectionParameter.setBindPassword(bindPassword);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setBindPrincipal(String bindPrincipal) {
        this.connectionParameter.setBindPrincipal(bindPrincipal);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setEncryptionMethod(ConnectionParameter.EncryptionMethod encryptionMethod) {
        this.connectionParameter.setEncryptionMethod(encryptionMethod);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setHost(String host) {
        this.connectionParameter.setHost(host);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setName(String name) {
        this.connectionParameter.setName(name);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setPort(int port) {
        this.connectionParameter.setPort(port);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setSaslRealm(String realm) {
        this.connectionParameter.setSaslRealm(realm);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public void setReadOnly(boolean isReadOnly) {
        this.connectionParameter.setReadOnly(isReadOnly);
        ConnectionEventRegistry.fireConnectionUpdated(this, this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Connection.class) {
            return this;
        }
        return null;
    }

    public LdapURL getUrl() {
        LdapURL url = new LdapURL();
        url.setHost(this.getHost());
        url.setPort(this.getPort());
        return url;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReferralHandlingMethod {
        IGNORE(0),
        FOLLOW(1),
        FOLLOW_MANUALLY(3);

        private final int ordinal;

        private ReferralHandlingMethod(int ordinal) {
            this.ordinal = ordinal;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public static ReferralHandlingMethod getByOrdinal(int ordinal) {
            switch (ordinal) {
                case 0: {
                    return IGNORE;
                }
                case 1: {
                    return FOLLOW;
                }
                case 2: {
                    return FOLLOW_MANUALLY;
                }
                case 3: {
                    return FOLLOW_MANUALLY;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AliasDereferencingMethod {
        NEVER(0),
        ALWAYS(1),
        FINDING(2),
        SEARCH(3);

        private final int ordinal;

        private AliasDereferencingMethod(int ordinal) {
            this.ordinal = ordinal;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public static AliasDereferencingMethod getByOrdinal(int ordinal) {
            switch (ordinal) {
                case 0: {
                    return NEVER;
                }
                case 1: {
                    return ALWAYS;
                }
                case 2: {
                    return FINDING;
                }
                case 3: {
                    return SEARCH;
                }
            }
            return null;
        }
    }
}

