/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.utils;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.StudioControl;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeModifyRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifModSpec;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifChangeTypeLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifControlLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifDnLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifModSpecSepLine;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;
import org.eclipse.core.runtime.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static String getNormalizedOidString(LdapDN dn, Schema schema) {
        StringBuffer sb = new StringBuffer();
        Iterator it = dn.getRdns().iterator();
        while (it.hasNext()) {
            Rdn rdn = (Rdn)it.next();
            sb.append(Utils.getOidString(rdn, schema));
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private static String getOidString(Rdn rdn, Schema schema) {
        StringBuffer sb = new StringBuffer();
        Iterator it = rdn.iterator();
        while (it.hasNext()) {
            AttributeTypeAndValue atav = (AttributeTypeAndValue)it.next();
            sb.append(Utils.getOidString(atav, schema));
            if (!it.hasNext()) continue;
            sb.append('+');
        }
        return sb.toString();
    }

    private static String getOidString(AttributeTypeAndValue atav, Schema schema) {
        String oid = schema != null ? schema.getAttributeTypeDescription(atav.getNormType()).getNumericOid() : atav.getNormType();
        return oid.trim().toLowerCase() + "=" + atav.getUpValue().getString().trim().toLowerCase();
    }

    public static String arrayToString(String[] array) {
        if (array == null || array.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ");
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static boolean equals(byte[] data1, byte[] data2) {
        if (data1 == data2) {
            return true;
        }
        if (data1 == null || data2 == null) {
            return false;
        }
        if (data1.length != data2.length) {
            return false;
        }
        for (int i = 0; i < data1.length; ++i) {
            if (data1[i] == data2[i]) continue;
            return false;
        }
        return true;
    }

    public static String getShortenedString(String value, int length) {
        if (value == null) {
            return "";
        }
        if (value.length() > length) {
            value = value.substring(0, length) + "...";
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String serialize(Object o) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            String s;
            Thread.currentThread().setContextClassLoader(Utils.class.getClassLoader());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLEncoder encoder = new XMLEncoder(baos);
            encoder.writeObject(o);
            encoder.close();
            String string = s = LdifUtils.utf8decode((byte[])baos.toByteArray());
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(String s) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Utils.class.getClassLoader());
            ByteArrayInputStream bais = new ByteArrayInputStream(LdifUtils.utf8encode((String)s));
            XMLDecoder decoder = new XMLDecoder(bais);
            Object o = decoder.readObject();
            decoder.close();
            Object object = o;
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    public static String getNonNullString(Object o) {
        return o == null ? "-" : o.toString();
    }

    public static String formatBytes(long bytes) {
        String size = "";
        size = bytes > 0x100000L ? size + bytes / 1024L / 1024L + " MB (" + bytes + " Bytes)" : (bytes > 1024L ? size + bytes / 1024L + " KB (" + bytes + " Bytes)" : (bytes > 1L ? size + bytes + " Bytes" : size + bytes + " Byte"));
        return size;
    }

    public static boolean containsIgnoreCase(Collection<String> c, String s) {
        if (c == null || s == null) {
            return false;
        }
        for (String string : c) {
            if (!string.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static LdifFormatParameters getLdifFormatParameters() {
        Preferences store = BrowserCorePlugin.getDefault().getPluginPreferences();
        boolean spaceAfterColon = store.getBoolean("ldifSpaceAfterColon");
        int lineWidth = store.getInt("ldifLineWidth");
        String lineSeparator = store.getString("ldifLineSeparator");
        LdifFormatParameters ldifFormatParameters = new LdifFormatParameters(spaceAfterColon, lineWidth, lineSeparator);
        return ldifFormatParameters;
    }

    public static LdapURL getLdapURL(IBrowserConnection browserConnection) {
        LdapURL url = new LdapURL();
        if (browserConnection.getConnection() != null) {
            if (browserConnection.getConnection().getEncryptionMethod() == ConnectionParameter.EncryptionMethod.LDAPS) {
                url.setScheme("ldaps://");
            } else {
                url.setScheme("ldap://");
            }
            url.setHost(browserConnection.getConnection().getHost());
            url.setPort(browserConnection.getConnection().getPort());
        }
        return url;
    }

    public static LdapURL getLdapURL(IEntry entry) {
        LdapURL url = Utils.getLdapURL(entry.getBrowserConnection());
        url.setDn(entry.getDn());
        return url;
    }

    public static LdapURL getLdapURL(ISearch search) {
        LdapURL url = Utils.getLdapURL(search.getBrowserConnection());
        url.setDn(search.getSearchBase());
        if (search.getReturningAttributes() != null) {
            url.setAttributes(Arrays.asList(search.getReturningAttributes()));
        }
        url.setScope(search.getScope().getOrdinal());
        url.setFilter(search.getFilter());
        return url;
    }

    public static LdifFile computeDiff(IEntry oldEntry, IEntry newEntry) {
        IBrowserConnection.ModifyMode modifyMode = oldEntry.getBrowserConnection().getModifyMode();
        IBrowserConnection.ModifyMode modifyModeNoEMR = oldEntry.getBrowserConnection().getModifyModeNoEMR();
        IBrowserConnection.ModifyOrder modifyAddDeleteOrder = oldEntry.getBrowserConnection().getModifyAddDeleteOrder();
        HashSet<String> attributeDescriptions = new HashSet<String>();
        for (IAttribute oldAttr : oldEntry.getAttributes()) {
            attributeDescriptions.add(oldAttr.getDescription());
        }
        for (IAttribute newAttr : newEntry.getAttributes()) {
            attributeDescriptions.add(newAttr.getDescription());
        }
        LdifChangeModifyRecord record = new LdifChangeModifyRecord(LdifDnLine.create((String)newEntry.getDn().getUpName()));
        if (newEntry.isReferral()) {
            record.addControl(LdifControlLine.create((String)StudioControl.MANAGEDSAIT_CONTROL.getOid(), (boolean)StudioControl.MANAGEDSAIT_CONTROL.isCritical(), (byte[])StudioControl.MANAGEDSAIT_CONTROL.getControlValue()));
        }
        record.setChangeType(LdifChangeTypeLine.createModify());
        for (String attributeDescription : attributeDescriptions) {
            LdifModSpec modSpec;
            Schema schema = oldEntry.getBrowserConnection().getSchema();
            AttributeTypeDescription atd = schema.getAttributeTypeDescription(attributeDescription);
            boolean hasEMR = SchemaUtils.getEqualityMatchingRuleNameOrNumericOidTransitive(atd, schema) != null;
            boolean isReplaceForced = hasEMR && modifyMode == IBrowserConnection.ModifyMode.REPLACE || !hasEMR && modifyModeNoEMR == IBrowserConnection.ModifyMode.REPLACE;
            boolean isAddDelForced = hasEMR && modifyMode == IBrowserConnection.ModifyMode.ADD_DELETE || !hasEMR && modifyModeNoEMR == IBrowserConnection.ModifyMode.ADD_DELETE;
            boolean isOrderedValue = atd.getExtensions().containsKey("X-ORDERED") && ((List)atd.getExtensions().get("X-ORDERED")).contains("VALUES");
            IAttribute oldAttribute = oldEntry.getAttribute(attributeDescription);
            HashSet<String> oldValues = new HashSet<String>();
            LinkedHashMap<String, LdifAttrValLine> oldAttrValLines = new LinkedHashMap<String, LdifAttrValLine>();
            if (oldAttribute != null) {
                for (IValue value : oldAttribute.getValues()) {
                    LdifAttrValLine attrValLine = Utils.computeDiffCreateAttrValLine(value);
                    oldValues.add(attrValLine.getUnfoldedValue());
                    oldAttrValLines.put(attrValLine.getUnfoldedValue(), attrValLine);
                }
            }
            IAttribute newAttribute = newEntry.getAttribute(attributeDescription);
            HashSet<String> newValues = new HashSet<String>();
            LinkedHashMap<String, LdifAttrValLine> newAttrValLines = new LinkedHashMap<String, LdifAttrValLine>();
            if (newAttribute != null) {
                for (IValue value : newAttribute.getValues()) {
                    LdifAttrValLine attrValLine = Utils.computeDiffCreateAttrValLine(value);
                    newValues.add(attrValLine.getUnfoldedValue());
                    newAttrValLines.put(attrValLine.getUnfoldedValue(), attrValLine);
                }
            }
            if (oldAttribute != null && newAttribute == null) {
                modSpec = isReplaceForced ? LdifModSpec.createReplace((String)attributeDescription) : LdifModSpec.createDelete((String)attributeDescription);
                modSpec.finish(LdifModSpecSepLine.create());
                record.addModSpec(modSpec);
                continue;
            }
            if (oldAttribute == null && newAttribute != null) {
                modSpec = isReplaceForced ? LdifModSpec.createReplace((String)attributeDescription) : LdifModSpec.createAdd((String)attributeDescription);
                for (IValue value : newAttribute.getValues()) {
                    modSpec.addAttrVal(Utils.computeDiffCreateAttrValLine(value));
                }
                modSpec.finish(LdifModSpecSepLine.create());
                record.addModSpec(modSpec);
                continue;
            }
            if (oldAttribute == null || newAttribute == null || ((Object)oldValues).equals(newValues)) continue;
            if (isReplaceForced) {
                modSpec = LdifModSpec.createReplace((String)attributeDescription);
                for (IValue value : newAttribute.getValues()) {
                    modSpec.addAttrVal(Utils.computeDiffCreateAttrValLine(value));
                }
                modSpec.finish(LdifModSpecSepLine.create());
                record.addModSpec(modSpec);
                continue;
            }
            ArrayList toDel = new ArrayList();
            ArrayList toAdd = new ArrayList();
            for (Map.Entry entry : oldAttrValLines.entrySet()) {
                if (newValues.contains(entry.getKey())) continue;
                toDel.add(entry.getValue());
            }
            for (Map.Entry entry : newAttrValLines.entrySet()) {
                if (oldValues.contains(entry.getKey())) continue;
                toAdd.add(entry.getValue());
            }
            if (isAddDelForced || toAdd.size() + toDel.size() <= newAttrValLines.size() && !isOrderedValue || !toDel.isEmpty() && toAdd.isEmpty() || !toAdd.isEmpty() && toDel.isEmpty()) {
                LdifModSpec addModSpec = LdifModSpec.createAdd((String)attributeDescription);
                for (LdifAttrValLine attrValLine : toAdd) {
                    addModSpec.addAttrVal(attrValLine);
                }
                addModSpec.finish(LdifModSpecSepLine.create());
                LdifModSpec delModSpec = LdifModSpec.createDelete((String)attributeDescription);
                for (LdifAttrValLine attrValLine : toDel) {
                    delModSpec.addAttrVal(attrValLine);
                }
                delModSpec.finish(LdifModSpecSepLine.create());
                if (modifyAddDeleteOrder == IBrowserConnection.ModifyOrder.DELETE_FIRST) {
                    if (delModSpec.getAttrVals().length > 0) {
                        record.addModSpec(delModSpec);
                    }
                    if (addModSpec.getAttrVals().length <= 0) continue;
                    record.addModSpec(addModSpec);
                    continue;
                }
                if (addModSpec.getAttrVals().length > 0) {
                    record.addModSpec(addModSpec);
                }
                if (delModSpec.getAttrVals().length <= 0) continue;
                record.addModSpec(delModSpec);
                continue;
            }
            LdifModSpec modSpec2 = LdifModSpec.createReplace((String)attributeDescription);
            for (LdifAttrValLine attrValLine : newAttrValLines.values()) {
                modSpec2.addAttrVal(attrValLine);
            }
            modSpec2.finish(LdifModSpecSepLine.create());
            record.addModSpec(modSpec2);
        }
        record.finish(LdifSepLine.create());
        LdifFile model = new LdifFile();
        if (record.isValid() && record.getModSpecs().length > 0) {
            model.addContainer((LdifContainer)record);
        }
        return model.getRecords().length > 0 ? model : null;
    }

    private static LdifAttrValLine computeDiffCreateAttrValLine(IValue value) {
        IAttribute attribute = value.getAttribute();
        if (attribute.isBinary()) {
            return LdifAttrValLine.create((String)attribute.getDescription(), (byte[])value.getBinaryValue());
        }
        return LdifAttrValLine.create((String)attribute.getDescription(), (String)value.getStringValue());
    }
}

