/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.utils;

import java.util.Comparator;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.utils.ModelConverter;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeComparator
implements Comparator<Object> {
    private IEntry dummyEntry;

    public AttributeComparator(IEntry entry) {
        this.dummyEntry = entry;
    }

    @Override
    public int compare(Object o1, Object o2) {
        IAttribute attribute1 = null;
        IValue value1 = null;
        if (o1 instanceof IAttribute) {
            attribute1 = (IAttribute)o1;
        } else if (o1 instanceof IValue) {
            value1 = (IValue)o1;
            attribute1 = value1.getAttribute();
        } else if (o1 instanceof LdifAttrValLine) {
            LdifAttrValLine line1 = (LdifAttrValLine)o1;
            value1 = ModelConverter.ldifAttrValLineToValue(line1, this.dummyEntry);
            attribute1 = value1.getAttribute();
        }
        IAttribute attribute2 = null;
        IValue value2 = null;
        if (o2 instanceof IAttribute) {
            attribute2 = (IAttribute)o2;
        } else if (o2 instanceof IValue) {
            value2 = (IValue)o2;
            attribute2 = value2.getAttribute();
        } else if (o2 instanceof LdifAttrValLine) {
            LdifAttrValLine line2 = (LdifAttrValLine)o2;
            value2 = ModelConverter.ldifAttrValLineToValue(line2, this.dummyEntry);
            attribute2 = value2.getAttribute();
        }
        if (value1 != null && value2 != null) {
            if (this.getSortByOrDefault() == 3) {
                if (value1.getAttribute() != value2.getAttribute()) {
                    return this.compareAttributeNames(value1.getAttribute(), value2.getAttribute());
                }
                return this.compareValues(value1, value2);
            }
            if (this.getSortByOrDefault() == 4) {
                return this.compareValues(value1, value2);
            }
            return this.equal();
        }
        if (attribute1 != null && attribute2 != null) {
            return this.compareAttributeNames(attribute1, attribute2);
        }
        return this.equal();
    }

    private int compareAttributeNames(IAttribute attribute1, IAttribute attribute2) {
        if (attribute1.isObjectClassAttribute()) {
            return this.lessThan();
        }
        if (attribute2.isObjectClassAttribute()) {
            return this.greaterThan();
        }
        if (attribute1.isMustAttribute() && !attribute2.isMustAttribute()) {
            return this.lessThan();
        }
        if (attribute2.isMustAttribute() && !attribute1.isMustAttribute()) {
            return this.greaterThan();
        }
        if (attribute1.isOperationalAttribute() && !attribute2.isOperationalAttribute()) {
            return this.greaterThan();
        }
        if (attribute2.isOperationalAttribute() && !attribute1.isOperationalAttribute()) {
            return this.lessThan();
        }
        return this.compare(attribute1.getDescription(), attribute2.getDescription());
    }

    private int compareValues(IValue value1, IValue value2) {
        if (value1.isEmpty() && value2.isEmpty()) {
            return this.equal();
        }
        if (value1.isEmpty() && !value2.isEmpty()) {
            return this.greaterThan();
        }
        if (!value1.isEmpty() && value2.isEmpty()) {
            return this.lessThan();
        }
        return this.compare(value1.getStringValue(), value2.getStringValue());
    }

    private int getSortOrderOrDefault() {
        return 1;
    }

    private int getSortByOrDefault() {
        return 3;
    }

    private int lessThan() {
        return this.getSortOrderOrDefault() == 1 ? -1 : 1;
    }

    private int equal() {
        return 0;
    }

    private int greaterThan() {
        return this.getSortOrderOrDefault() == 1 ? 1 : -1;
    }

    @Override
    private int compare(String s1, String s2) {
        return this.getSortOrderOrDefault() == 1 ? s1.compareToIgnoreCase(s2) : s2.compareToIgnoreCase(s1);
    }
}

