/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.shared.ldap.schema.parsers.LdapSyntaxDescription;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleDescription;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleUseDescription;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescription;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaUtils {
    public static final Set<String> OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES = new HashSet<String>();
    public static final Set<String> NON_MODIFIABLE_ATTRIBUTE_OIDS_AND_NAMES;
    private static final Comparator<String> nameAndOidComparator;
    private static final Comparator<AbstractSchemaDescription> schemaElementNameComparator;

    public static Collection<String> getNames(Collection<? extends AbstractSchemaDescription> asds) {
        TreeSet<String> nameSet = new TreeSet<String>(nameAndOidComparator);
        for (AbstractSchemaDescription abstractSchemaDescription : asds) {
            nameSet.addAll(abstractSchemaDescription.getNames());
        }
        return nameSet;
    }

    public static String[] getNamesAsArray(Collection<? extends AbstractSchemaDescription> asds) {
        return SchemaUtils.getNames(asds).toArray(new String[0]);
    }

    public static Collection<String> getNumericOids(Collection<? extends AbstractSchemaDescription> descritpions) {
        HashSet<String> oids = new HashSet<String>();
        for (AbstractSchemaDescription abstractSchemaDescription : descritpions) {
            oids.add(abstractSchemaDescription.getNumericOid());
        }
        return oids;
    }

    public static Collection<String> getLowerCaseIdentifiers(AbstractSchemaDescription asd) {
        HashSet<String> identiers = new HashSet<String>();
        if (asd.getNumericOid() != null) {
            identiers.add(asd.getNumericOid().toLowerCase());
        }
        if (asd.getNames() != null && !asd.getNames().isEmpty()) {
            for (String name : asd.getNames()) {
                if (name == null) continue;
                identiers.add(name.toLowerCase());
            }
        }
        return identiers;
    }

    public static String getFriendlyIdentifier(AbstractSchemaDescription asd) {
        if (asd.getNames() != null && !asd.getNames().isEmpty()) {
            return (String)asd.getNames().get(0);
        }
        return asd.getNumericOid();
    }

    public static Collection<AttributeTypeDescription> getOperationalAttributeDescriptions(Schema schema) {
        HashSet<AttributeTypeDescription> operationalAtds = new HashSet<AttributeTypeDescription>();
        for (AttributeTypeDescription atd : schema.getAttributeTypeDescriptions()) {
            if (!SchemaUtils.isOperational(atd)) continue;
            operationalAtds.add(atd);
        }
        return operationalAtds;
    }

    public static Collection<AttributeTypeDescription> getUserAttributeDescriptions(Schema schema) {
        HashSet<AttributeTypeDescription> userAtds = new HashSet<AttributeTypeDescription>();
        for (AttributeTypeDescription atd : schema.getAttributeTypeDescriptions()) {
            if (SchemaUtils.isOperational(atd)) continue;
            userAtds.add(atd);
        }
        return userAtds;
    }

    public static boolean isOperational(AttributeTypeDescription atd) {
        return atd.getUsage() != UsageEnum.USER_APPLICATIONS || atd.getExtensions() == Schema.DUMMY_EXTENSIONS || CollectionUtils.containsAny(OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES, SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaDescription)atd));
    }

    public static boolean isModifiable(AttributeTypeDescription atd) {
        if (atd == null) {
            return false;
        }
        if (!atd.isUserModifiable()) {
            return false;
        }
        return !CollectionUtils.containsAny(NON_MODIFIABLE_ATTRIBUTE_OIDS_AND_NAMES, SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaDescription)atd));
    }

    public static Collection<AttributeTypeDescription> getMustAttributeTypeDescriptions(IEntry entry) {
        Schema schema = entry.getBrowserConnection().getSchema();
        HashSet<AttributeTypeDescription> atds = new HashSet<AttributeTypeDescription>();
        for (ObjectClassDescription ocd : entry.getObjectClassDescriptions()) {
            Collection<String> musts = SchemaUtils.getMustAttributeTypeDescriptionNamesTransitive(ocd, schema);
            for (String must : musts) {
                AttributeTypeDescription atd = schema.getAttributeTypeDescription(must);
                atds.add(atd);
            }
        }
        return atds;
    }

    public static Collection<AttributeTypeDescription> getMayAttributeTypeDescriptions(IEntry entry) {
        Schema schema = entry.getBrowserConnection().getSchema();
        HashSet<AttributeTypeDescription> atds = new HashSet<AttributeTypeDescription>();
        for (ObjectClassDescription ocd : entry.getObjectClassDescriptions()) {
            Collection<String> mays = SchemaUtils.getMayAttributeTypeDescriptionNamesTransitive(ocd, schema);
            for (String may : mays) {
                AttributeTypeDescription atd = schema.getAttributeTypeDescription(may);
                atds.add(atd);
            }
        }
        return atds;
    }

    public static Collection<AttributeTypeDescription> getAllAttributeTypeDescriptions(IEntry entry) {
        HashSet<AttributeTypeDescription> atds = new HashSet<AttributeTypeDescription>();
        atds.addAll(SchemaUtils.getMustAttributeTypeDescriptions(entry));
        atds.addAll(SchemaUtils.getMayAttributeTypeDescriptions(entry));
        return atds;
    }

    public static boolean isString(LdapSyntaxDescription lsd) {
        return !SchemaUtils.isBinary(lsd);
    }

    public static boolean isBinary(LdapSyntaxDescription lsd) {
        Set<String> binarySyntaxOids = BrowserCorePlugin.getDefault().getCorePreferences().getUpperCasedBinarySyntaxOids();
        return binarySyntaxOids.contains(lsd.getNumericOid().toUpperCase());
    }

    public static boolean isString(AttributeTypeDescription atd, Schema schema) {
        return !SchemaUtils.isBinary(atd, schema);
    }

    public static boolean isBinary(AttributeTypeDescription atd, Schema schema) {
        Set<String> binaryAttributeOidsAndNames = BrowserCorePlugin.getDefault().getCorePreferences().getUpperCasedBinaryAttributeOidsAndNames();
        if (binaryAttributeOidsAndNames.contains(atd.getNumericOid().toUpperCase())) {
            return true;
        }
        for (String name : atd.getNames()) {
            if (!binaryAttributeOidsAndNames.contains(name.toUpperCase())) continue;
            return true;
        }
        String syntax = SchemaUtils.getSyntaxNumericOidTransitive(atd, schema);
        if (syntax != null && schema.hasLdapSyntaxDescription(syntax)) {
            LdapSyntaxDescription lsd = schema.getLdapSyntaxDescription(syntax);
            return SchemaUtils.isBinary(lsd);
        }
        return false;
    }

    public static Collection<AttributeTypeDescription> getUsedFromAttributeTypeDescriptions(LdapSyntaxDescription lsd, Schema schema) {
        TreeSet<AbstractSchemaDescription> usedFroms = new TreeSet<AbstractSchemaDescription>(schemaElementNameComparator);
        for (AttributeTypeDescription atd : schema.getAttributeTypeDescriptions()) {
            String syntax = SchemaUtils.getSyntaxNumericOidTransitive(atd, schema);
            if (syntax == null || lsd.getNumericOid() == null || !syntax.toLowerCase().equals(lsd.getNumericOid().toLowerCase())) continue;
            usedFroms.add((AbstractSchemaDescription)atd);
        }
        return usedFroms;
    }

    public static Collection<AttributeTypeDescription> getUsedFromAttributeTypeDescriptions(MatchingRuleDescription mrd, Schema schema) {
        TreeSet<AbstractSchemaDescription> usedFromSet = new TreeSet<AbstractSchemaDescription>(schemaElementNameComparator);
        for (AttributeTypeDescription atd : schema.getAttributeTypeDescriptions()) {
            Collection<String> lowerCaseIdentifiers = SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaDescription)mrd);
            String emr = SchemaUtils.getEqualityMatchingRuleNameOrNumericOidTransitive(atd, schema);
            String smr = SchemaUtils.getSubstringMatchingRuleNameOrNumericOidTransitive(atd, schema);
            String omr = SchemaUtils.getOrderingMatchingRuleNameOrNumericOidTransitive(atd, schema);
            if (emr != null && lowerCaseIdentifiers.contains(emr.toLowerCase())) {
                usedFromSet.add((AbstractSchemaDescription)atd);
            }
            if (smr != null && lowerCaseIdentifiers.contains(smr.toLowerCase())) {
                usedFromSet.add((AbstractSchemaDescription)atd);
            }
            if (omr == null || !lowerCaseIdentifiers.contains(omr.toLowerCase())) continue;
            usedFromSet.add((AbstractSchemaDescription)atd);
        }
        return usedFromSet;
    }

    public static String getEqualityMatchingRuleNameOrNumericOidTransitive(AttributeTypeDescription atd, Schema schema) {
        if (atd.getEqualityMatchingRule() != null) {
            return atd.getEqualityMatchingRule();
        }
        if (atd.getSuperType() != null && schema.hasAttributeTypeDescription(atd.getSuperType())) {
            AttributeTypeDescription superior = schema.getAttributeTypeDescription(atd.getSuperType());
            return SchemaUtils.getEqualityMatchingRuleNameOrNumericOidTransitive(superior, schema);
        }
        return null;
    }

    public static String getSubstringMatchingRuleNameOrNumericOidTransitive(AttributeTypeDescription atd, Schema schema) {
        if (atd.getSubstringsMatchingRule() != null) {
            return atd.getSubstringsMatchingRule();
        }
        if (atd.getSuperType() != null && schema.hasAttributeTypeDescription(atd.getSuperType())) {
            AttributeTypeDescription superior = schema.getAttributeTypeDescription(atd.getSuperType());
            return SchemaUtils.getSubstringMatchingRuleNameOrNumericOidTransitive(superior, schema);
        }
        return null;
    }

    public static String getOrderingMatchingRuleNameOrNumericOidTransitive(AttributeTypeDescription atd, Schema schema) {
        if (atd.getOrderingMatchingRule() != null) {
            return atd.getOrderingMatchingRule();
        }
        if (atd.getSuperType() != null && schema.hasAttributeTypeDescription(atd.getSuperType())) {
            AttributeTypeDescription superior = schema.getAttributeTypeDescription(atd.getSuperType());
            return SchemaUtils.getOrderingMatchingRuleNameOrNumericOidTransitive(superior, schema);
        }
        return null;
    }

    public static String getSyntaxNumericOidTransitive(AttributeTypeDescription atd, Schema schema) {
        if (atd.getSyntax() != null) {
            return atd.getSyntax();
        }
        if (atd.getSuperType() != null && schema.hasAttributeTypeDescription(atd.getSuperType())) {
            AttributeTypeDescription superior = schema.getAttributeTypeDescription(atd.getSuperType());
            return SchemaUtils.getSyntaxNumericOidTransitive(superior, schema);
        }
        return null;
    }

    public static int getSyntaxLengthTransitive(AttributeTypeDescription atd, Schema schema) {
        if (atd.getSyntaxLength() != -1) {
            return atd.getSyntaxLength();
        }
        if (atd.getSuperType() != null && schema.hasAttributeTypeDescription(atd.getSuperType())) {
            AttributeTypeDescription superior = schema.getAttributeTypeDescription(atd.getSuperType());
            return SchemaUtils.getSyntaxLengthTransitive(superior, schema);
        }
        return -1;
    }

    public static Collection<String> getOtherMatchingRuleDescriptionNames(AttributeTypeDescription atd, Schema schema) {
        TreeSet<String> otherMatchingRules = new TreeSet<String>(nameAndOidComparator);
        for (MatchingRuleUseDescription mrud : schema.getMatchingRuleUseDescriptions()) {
            Collection<String> atdSet = SchemaUtils.toLowerCaseSet(mrud.getApplicableAttributes());
            if (!atdSet.removeAll(SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaDescription)atd))) continue;
            otherMatchingRules.addAll(mrud.getNames());
        }
        return otherMatchingRules;
    }

    public static Collection<AttributeTypeDescription> getDerivedAttributeTypeDescriptions(AttributeTypeDescription atd, Schema schema) {
        TreeSet<AbstractSchemaDescription> derivedAtds = new TreeSet<AbstractSchemaDescription>(schemaElementNameComparator);
        for (AttributeTypeDescription derivedAtd : schema.getAttributeTypeDescriptions()) {
            String superType = derivedAtd.getSuperType();
            if (superType == null || !SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaDescription)atd).contains(superType.toLowerCase())) continue;
            derivedAtds.add((AbstractSchemaDescription)derivedAtd);
        }
        return derivedAtds;
    }

    public static Collection<ObjectClassDescription> getUsedAsMust(AttributeTypeDescription atd, Schema schema) {
        Collection<String> lowerCaseIdentifiers = SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaDescription)atd);
        TreeSet<AbstractSchemaDescription> ocds = new TreeSet<AbstractSchemaDescription>(schemaElementNameComparator);
        for (ObjectClassDescription ocd : schema.getObjectClassDescriptions()) {
            Collection<String> mustSet = SchemaUtils.toLowerCaseSet(SchemaUtils.getMustAttributeTypeDescriptionNamesTransitive(ocd, schema));
            if (!mustSet.removeAll(lowerCaseIdentifiers)) continue;
            ocds.add((AbstractSchemaDescription)ocd);
        }
        return ocds;
    }

    public static Collection<ObjectClassDescription> getUsedAsMay(AttributeTypeDescription atd, Schema schema) {
        Collection<String> lowerCaseIdentifiers = SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaDescription)atd);
        TreeSet<AbstractSchemaDescription> ocds = new TreeSet<AbstractSchemaDescription>(schemaElementNameComparator);
        for (ObjectClassDescription ocd : schema.getObjectClassDescriptions()) {
            Collection<String> mustSet = SchemaUtils.toLowerCaseSet(SchemaUtils.getMayAttributeTypeDescriptionNamesTransitive(ocd, schema));
            if (!mustSet.removeAll(lowerCaseIdentifiers)) continue;
            ocds.add((AbstractSchemaDescription)ocd);
        }
        return ocds;
    }

    private static Collection<ObjectClassDescription> getExistingSuperiorObjectClassDescription(ObjectClassDescription ocd, Schema schema) {
        ArrayList<ObjectClassDescription> superiorList = new ArrayList<ObjectClassDescription>();
        for (String superior : ocd.getSuperiorObjectClasses()) {
            if (!schema.hasObjectClassDescription(superior)) continue;
            superiorList.add(schema.getObjectClassDescription(superior));
        }
        return superiorList;
    }

    public static List<ObjectClassDescription> getSuperiorObjectClassDescriptions(ObjectClassDescription ocd, Schema schema) {
        ArrayList<ObjectClassDescription> superiorList = new ArrayList<ObjectClassDescription>();
        for (String superior : ocd.getSuperiorObjectClasses()) {
            superiorList.add(schema.getObjectClassDescription(superior));
        }
        return superiorList;
    }

    public static List<ObjectClassDescription> getSubObjectClassDescriptions(ObjectClassDescription ocd, Schema schema) {
        ArrayList<ObjectClassDescription> subOcds = new ArrayList<ObjectClassDescription>();
        for (ObjectClassDescription testOcd : schema.getObjectClassDescriptions()) {
            Collection<String> superiorNames = SchemaUtils.toLowerCaseSet(testOcd.getSuperiorObjectClasses());
            if (!superiorNames.removeAll(SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaDescription)ocd))) continue;
            subOcds.add(testOcd);
        }
        return subOcds;
    }

    public static Collection<String> getMustAttributeTypeDescriptionNamesTransitive(ObjectClassDescription ocd, Schema schema) {
        TreeSet<String> musts = new TreeSet<String>(nameAndOidComparator);
        musts.addAll(ocd.getMustAttributeTypes());
        Collection<ObjectClassDescription> superiors = SchemaUtils.getExistingSuperiorObjectClassDescription(ocd, schema);
        for (ObjectClassDescription superior : superiors) {
            musts.addAll(SchemaUtils.getMustAttributeTypeDescriptionNamesTransitive(superior, schema));
        }
        return musts;
    }

    public static Collection<String> getMayAttributeTypeDescriptionNamesTransitive(ObjectClassDescription ocd, Schema schema) {
        TreeSet<String> mays = new TreeSet<String>(nameAndOidComparator);
        mays.addAll(ocd.getMayAttributeTypes());
        Collection<ObjectClassDescription> superiors = SchemaUtils.getExistingSuperiorObjectClassDescription(ocd, schema);
        for (ObjectClassDescription superior : superiors) {
            mays.addAll(SchemaUtils.getMayAttributeTypeDescriptionNamesTransitive(superior, schema));
        }
        return mays;
    }

    public static String getLdifLine(AbstractSchemaDescription asd) {
        List ldifLines = (List)asd.getExtensions().get("RAW_SCHEMA_DEFINITION_LDIF_VALUE");
        String ldifLine = ldifLines != null && !ldifLines.isEmpty() ? (String)ldifLines.get(0) : null;
        return ldifLine;
    }

    private static Collection<String> toLowerCaseSet(Collection<String> names) {
        HashSet<String> set = new HashSet<String>();
        if (names != null) {
            for (String name : names) {
                set.add(name.toLowerCase());
            }
        }
        return set;
    }

    public static String toString(AbstractSchemaDescription asd) {
        StringBuffer sb = new StringBuffer();
        if (asd instanceof LdapSyntaxDescription) {
            if (asd.getDescription() != null && asd.getDescription().length() > 0) {
                sb.append(asd.getDescription());
            } else {
                sb.append(asd.getNumericOid());
            }
        } else {
            boolean first = true;
            for (String name : asd.getNames()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(name);
                first = false;
            }
        }
        return sb.toString();
    }

    public static Collection<String> getEntryIncompleteMessages(IEntry entry) {
        ArrayList<String> messages = new ArrayList<String>();
        if (entry != null) {
            IAttribute ocAttribute = entry.getAttribute("objectClass");
            if (ocAttribute == null) {
                messages.add(Messages.getString("SchemaUtils.NoObjectClass"));
            }
            String[] ocValues = ocAttribute.getStringValues();
            boolean structuralObjectClassAvailable = false;
            for (String ocValue : ocValues) {
                ObjectClassDescription ocd = entry.getBrowserConnection().getSchema().getObjectClassDescription(ocValue);
                if (ocd.getKind() != ObjectClassTypeEnum.STRUCTURAL) continue;
                structuralObjectClassAvailable = true;
                break;
            }
            if (!structuralObjectClassAvailable) {
                messages.add(Messages.getString("SchemaUtils.NoStructuralObjectClass"));
            }
            Collection<AttributeTypeDescription> mustAtds = SchemaUtils.getMustAttributeTypeDescriptions(entry);
            for (AttributeTypeDescription mustAtd : mustAtds) {
                AttributeHierarchy ah = entry.getAttributeWithSubtypes(mustAtd.getNumericOid());
                if (ah != null) continue;
                messages.add(NLS.bind((String)Messages.getString("SchemaUtils.MandatoryAttributeIsMissing"), SchemaUtils.getLowerCaseIdentifiers((AbstractSchemaDescription)mustAtd)));
            }
            Collection<AttributeTypeDescription> allAtds = SchemaUtils.getAllAttributeTypeDescriptions(entry);
            for (IAttribute attribute : entry.getAttributes()) {
                AttributeTypeDescription atd;
                if (attribute.isOperationalAttribute() || allAtds.contains(atd = attribute.getAttributeTypeDescription())) continue;
                messages.add(NLS.bind((String)Messages.getString("SchemaUtils.AttributeNotAllowed"), (Object)attribute.getDescription()));
            }
            for (IAttribute attribute : entry.getAttributes()) {
                for (IValue value : attribute.getValues()) {
                    if (!value.isEmpty()) continue;
                    messages.add(NLS.bind((String)Messages.getString("SchemaUtils.EmptyValue"), (Object)attribute.getDescription()));
                }
            }
        }
        return messages;
    }

    static {
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("createTimestamp".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.18.1".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("creatorsName".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.18.3".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("modifyTimestamp".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.18.2".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("modifiersName".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.18.4".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("subschemaSubentry".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.18.10".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("structuralObjectClass".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.21.9".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("governingStructureRule".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.21.10".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("entryUUID".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("1.3.6.1.1.16.4".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("entryCSN".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("entryDN".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("1.3.6.1.1.20".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("objectClasses".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.21.6".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("attributeTypes".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.21.5".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("ldapSyntaxes".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("1.3.6.1.4.1.1466.101.120.16".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("matchingRules".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.21.4".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("matchingRuleUse".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.21.8".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("ditContentRules".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.21.2".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("ditStructureRules".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.21.1".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("nameForms".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.21.7".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("hasSubordinates".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.18.9".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("numSubordinates".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("subordinateCount".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("vendorName".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("1.3.6.1.1.4".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("vendorVersion".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("1.3.6.1.1.5".toLowerCase());
        NON_MODIFIABLE_ATTRIBUTE_OIDS_AND_NAMES = new HashSet<String>();
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("createTimestamp".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.18.1".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("creatorsName".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.18.3".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("modifyTimestamp".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.18.2".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("modifiersName".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.18.4".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("subschemaSubentry".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.18.10".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("structuralObjectClass".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.21.9".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("governingStructureRule".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.21.10".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("entryUUID".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("1.3.6.1.1.16.4".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("entryCSN".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("entryDN".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("1.3.6.1.1.20".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("hasSubordinates".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("2.5.18.9".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("numSubordinates".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("subordinateCount".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("vendorName".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("1.3.6.1.1.4".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("vendorVersion".toLowerCase());
        OPERATIONAL_ATTRIBUTES_OIDS_AND_NAMES.add("1.3.6.1.1.5".toLowerCase());
        nameAndOidComparator = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                if (s1.matches("[0-9\\.]+") && !s2.matches("[0-9\\.]+")) {
                    return 1;
                }
                if (!s1.matches("[0-9\\.]+") && s2.matches("[0-9\\.]+")) {
                    return -1;
                }
                return s1.compareToIgnoreCase(s2);
            }
        };
        schemaElementNameComparator = new Comparator<AbstractSchemaDescription>(){

            @Override
            public int compare(AbstractSchemaDescription s1, AbstractSchemaDescription s2) {
                return SchemaUtils.toString(s1).compareToIgnoreCase(SchemaUtils.toString(s2));
            }
        };
    }
}

