/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.schema;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.LdapSyntaxDescription;
import org.apache.directory.shared.ldap.schema.parsers.LdapSyntaxDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleDescription;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleUseDescription;
import org.apache.directory.shared.ldap.schema.parsers.MatchingRuleUseDescriptionSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescription;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescriptionSchemaParser;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeDescription;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.model.LdifEnumeration;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.apache.directory.studio.ldifparser.parser.LdifParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schema {
    public static final String SCHEMA_FILTER = "(objectClass=subschema)";
    public static final String RAW_SCHEMA_DEFINITION_LDIF_VALUE = "RAW_SCHEMA_DEFINITION_LDIF_VALUE";
    public static final String DN_SYNTAX_OID = "1.3.6.1.4.1.1466.115.121.1.12";
    public static final LdapSyntaxDescription DUMMY_LDAP_SYNTAX = new LdapSyntaxDescription();
    public static final HashMap<String, List<String>> DUMMY_EXTENSIONS;
    public static final Schema DEFAULT_SCHEMA;
    private boolean defaultSchema = false;
    private LdifContentRecord schemaRecord = null;
    private LdapDN dn = null;
    private String createTimestamp = null;
    private String modifyTimestamp = null;
    private Map<String, ObjectClassDescription> ocdMapByNameOrNumericOid = new HashMap<String, ObjectClassDescription>();
    private Map<String, AttributeTypeDescription> atdMapByNameOrNumericOid = new HashMap<String, AttributeTypeDescription>();
    private Map<String, LdapSyntaxDescription> lsdMapByNumericOid = new HashMap<String, LdapSyntaxDescription>();
    private Map<String, MatchingRuleDescription> mrdMapByNameOrNumericOid = new HashMap<String, MatchingRuleDescription>();
    private Map<String, MatchingRuleUseDescription> mrudMapByNameOrNumericOid = new HashMap<String, MatchingRuleUseDescription>();

    public boolean isDefault() {
        return this.defaultSchema;
    }

    public void loadFromLdif(Reader reader) {
        try {
            LdifContainer container;
            LdifParser parser = new LdifParser();
            LdifEnumeration enumeration = parser.parse(reader);
            if (enumeration.hasNext() && (container = enumeration.next()) instanceof LdifContentRecord) {
                LdifContentRecord schemaRecord = (LdifContentRecord)container;
                this.parseSchemaRecord(schemaRecord);
            }
        }
        catch (Exception e) {
            System.out.println("Schema#loadFromLdif: " + e.toString());
        }
    }

    public void loadFromRecord(LdifContentRecord schemaRecord) {
        try {
            this.parseSchemaRecord(schemaRecord);
        }
        catch (Exception e) {
            System.out.println("Schema#loadFromRecord: " + e.toString());
        }
    }

    public void saveToLdif(Writer writer) {
        try {
            writer.write(this.getSchemaRecord().toFormattedString(LdifFormatParameters.DEFAULT));
        }
        catch (Exception e) {
            System.out.println("Schema#saveToLdif: " + e.toString());
        }
    }

    private void parseSchemaRecord(LdifContentRecord schemaRecord) throws Exception {
        this.setSchemaRecord(schemaRecord);
        this.setDn(new LdapDN(schemaRecord.getDnLine().getValueAsString()));
        ObjectClassDescriptionSchemaParser ocdPparser = new ObjectClassDescriptionSchemaParser();
        ocdPparser.setQuirksMode(true);
        AttributeTypeDescriptionSchemaParser atdParser = new AttributeTypeDescriptionSchemaParser();
        atdParser.setQuirksMode(true);
        LdapSyntaxDescriptionSchemaParser lsdParser = new LdapSyntaxDescriptionSchemaParser();
        lsdParser.setQuirksMode(true);
        MatchingRuleDescriptionSchemaParser mrdParser = new MatchingRuleDescriptionSchemaParser();
        mrdParser.setQuirksMode(true);
        MatchingRuleUseDescriptionSchemaParser mrudParser = new MatchingRuleUseDescriptionSchemaParser();
        mrudParser.setQuirksMode(true);
        LdifAttrValLine[] lines = schemaRecord.getAttrVals();
        for (int i = 0; i < lines.length; ++i) {
            LdifAttrValLine line = lines[i];
            String attributeName = line.getUnfoldedAttributeDescription();
            String value = line.getValueAsString();
            ArrayList<String> ldifValues = new ArrayList<String>(1);
            ldifValues.add(value);
            try {
                if (attributeName.equalsIgnoreCase("objectClasses")) {
                    ObjectClassDescription ocd = ocdPparser.parseObjectClassDescription(value);
                    ocd.addExtension(RAW_SCHEMA_DEFINITION_LDIF_VALUE, ldifValues);
                    this.addObjectClassDescription(ocd);
                    continue;
                }
                if (attributeName.equalsIgnoreCase("attributeTypes")) {
                    AttributeTypeDescription atd = atdParser.parseAttributeTypeDescription(value);
                    atd.addExtension(RAW_SCHEMA_DEFINITION_LDIF_VALUE, ldifValues);
                    this.addAttributeTypeDescription(atd);
                    continue;
                }
                if (attributeName.equalsIgnoreCase("ldapSyntaxes")) {
                    LdapSyntaxDescription lsd = lsdParser.parseLdapSyntaxDescription(value);
                    if (StringUtils.isEmpty((String)lsd.getDescription()) && Utils.getOidDescription((String)lsd.getNumericOid()) != null) {
                        lsd.setDescription(Utils.getOidDescription((String)lsd.getNumericOid()));
                    }
                    lsd.addExtension(RAW_SCHEMA_DEFINITION_LDIF_VALUE, ldifValues);
                    this.addLdapSyntaxDescription(lsd);
                    continue;
                }
                if (attributeName.equalsIgnoreCase("matchingRules")) {
                    MatchingRuleDescription mrd = mrdParser.parseMatchingRuleDescription(value);
                    mrd.addExtension(RAW_SCHEMA_DEFINITION_LDIF_VALUE, ldifValues);
                    this.addMatchingRuleDescription(mrd);
                    continue;
                }
                if (attributeName.equalsIgnoreCase("matchingRuleUse")) {
                    MatchingRuleUseDescription mrud = mrudParser.parseMatchingRuleUseDescription(value);
                    mrud.addExtension(RAW_SCHEMA_DEFINITION_LDIF_VALUE, ldifValues);
                    this.addMatchingRuleUseDescription(mrud);
                    continue;
                }
                if (attributeName.equalsIgnoreCase("createTimestamp")) {
                    this.setCreateTimestamp(value);
                    continue;
                }
                if (!attributeName.equalsIgnoreCase("modifyTimestamp")) continue;
                this.setModifyTimestamp(value);
                continue;
            }
            catch (Exception e) {
                System.out.println("Error reading schema: " + attributeName + " = " + value);
                System.out.println(e.getMessage());
            }
        }
        for (AttributeTypeDescription atd : this.getAttributeTypeDescriptions()) {
            String syntaxOid = atd.getSyntax();
            if (syntaxOid != null && !this.hasLdapSyntaxDescription(syntaxOid)) {
                LdapSyntaxDescription lsd = new LdapSyntaxDescription();
                lsd.setNumericOid(syntaxOid);
                lsd.setDescription(Utils.getOidDescription((String)syntaxOid));
                this.addLdapSyntaxDescription(lsd);
            }
            String emr = atd.getEqualityMatchingRule();
            String omr = atd.getOrderingMatchingRule();
            String smr = atd.getSubstringsMatchingRule();
            this.checkMatchingRules(emr, omr, smr);
        }
        ObjectClassDescription extensibleObjectOcd = this.getObjectClassDescription("extensibleObject");
        Collection<AttributeTypeDescription> userAtds = SchemaUtils.getUserAttributeDescriptions(this);
        Collection<String> atdNames = SchemaUtils.getNames(userAtds);
        ArrayList<String> atdNames2 = new ArrayList<String>(atdNames);
        extensibleObjectOcd.setMayAttributeTypes(atdNames2);
    }

    private void checkMatchingRules(String ... matchingRules) {
        for (String matchingRule : matchingRules) {
            if (matchingRule == null || this.hasMatchingRuleDescription(matchingRule)) continue;
            MatchingRuleDescription mrd = new MatchingRuleDescription();
            mrd.setNumericOid(matchingRule);
            mrd.getNames().add(matchingRule);
            this.addMatchingRuleDescription(mrd);
        }
    }

    public LdifContentRecord getSchemaRecord() {
        return this.schemaRecord;
    }

    public void setSchemaRecord(LdifContentRecord schemaRecord) {
        this.schemaRecord = schemaRecord;
    }

    public LdapDN getDn() {
        return this.dn;
    }

    public void setDn(LdapDN dn) {
        this.dn = dn;
    }

    public String getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(String createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public String getModifyTimestamp() {
        return this.modifyTimestamp;
    }

    public void setModifyTimestamp(String modifyTimestamp) {
        this.modifyTimestamp = modifyTimestamp;
    }

    private void addObjectClassDescription(ObjectClassDescription ocd) {
        if (ocd.getNumericOid() != null) {
            this.ocdMapByNameOrNumericOid.put(ocd.getNumericOid().toLowerCase(), ocd);
        }
        if (ocd.getNames() != null && !ocd.getNames().isEmpty()) {
            for (String ocdName : ocd.getNames()) {
                this.ocdMapByNameOrNumericOid.put(ocdName.toLowerCase(), ocd);
            }
        }
    }

    public Collection<ObjectClassDescription> getObjectClassDescriptions() {
        HashSet<ObjectClassDescription> set = new HashSet<ObjectClassDescription>(this.ocdMapByNameOrNumericOid.values());
        return set;
    }

    public boolean hasObjectClassDescription(String nameOrOid) {
        return this.ocdMapByNameOrNumericOid.containsKey(nameOrOid.toLowerCase());
    }

    public ObjectClassDescription getObjectClassDescription(String nameOrOid) {
        if (this.ocdMapByNameOrNumericOid.containsKey(nameOrOid.toLowerCase())) {
            return this.ocdMapByNameOrNumericOid.get(nameOrOid.toLowerCase());
        }
        if (!this.isDefault()) {
            return DEFAULT_SCHEMA.getObjectClassDescription(nameOrOid);
        }
        ArrayList<String> names = new ArrayList<String>();
        names.add(nameOrOid);
        ObjectClassDescription ocd = new ObjectClassDescription();
        ocd.setNumericOid(nameOrOid);
        ocd.setNames(names);
        ocd.setExtensions(DUMMY_EXTENSIONS);
        return ocd;
    }

    private void addAttributeTypeDescription(AttributeTypeDescription atd) {
        if (atd.getNumericOid() != null) {
            this.atdMapByNameOrNumericOid.put(atd.getNumericOid().toLowerCase(), atd);
        }
        if (atd.getNames() != null && !atd.getNames().isEmpty()) {
            for (String atdName : atd.getNames()) {
                this.atdMapByNameOrNumericOid.put(atdName.toLowerCase(), atd);
            }
        }
    }

    public Collection<AttributeTypeDescription> getAttributeTypeDescriptions() {
        HashSet<AttributeTypeDescription> set = new HashSet<AttributeTypeDescription>(this.atdMapByNameOrNumericOid.values());
        return set;
    }

    public boolean hasAttributeTypeDescription(String nameOrOid) {
        return this.atdMapByNameOrNumericOid.containsKey(nameOrOid.toLowerCase());
    }

    public AttributeTypeDescription getAttributeTypeDescription(String nameOrOid) {
        AttributeDescription ad = new AttributeDescription(nameOrOid);
        String attributeType = ad.getParsedAttributeType();
        if (this.atdMapByNameOrNumericOid.containsKey(attributeType.toLowerCase())) {
            return this.atdMapByNameOrNumericOid.get(attributeType.toLowerCase());
        }
        if (!this.isDefault()) {
            return DEFAULT_SCHEMA.getAttributeTypeDescription(attributeType);
        }
        ArrayList<String> attributeTypes = new ArrayList<String>();
        attributeTypes.add(attributeType);
        AttributeTypeDescription atd = new AttributeTypeDescription();
        atd.setNumericOid(attributeType);
        atd.setNames(attributeTypes);
        atd.setUserModifiable(true);
        atd.setUsage(UsageEnum.USER_APPLICATIONS);
        atd.setExtensions(DUMMY_EXTENSIONS);
        return atd;
    }

    private void addLdapSyntaxDescription(LdapSyntaxDescription lsd) {
        if (lsd.getNumericOid() != null) {
            this.lsdMapByNumericOid.put(lsd.getNumericOid().toLowerCase(), lsd);
        }
    }

    public Collection<LdapSyntaxDescription> getLdapSyntaxDescriptions() {
        HashSet<LdapSyntaxDescription> set = new HashSet<LdapSyntaxDescription>(this.lsdMapByNumericOid.values());
        return set;
    }

    public boolean hasLdapSyntaxDescription(String numericOid) {
        return this.lsdMapByNumericOid.containsKey(numericOid.toLowerCase());
    }

    public LdapSyntaxDescription getLdapSyntaxDescription(String numericOid) {
        if (numericOid == null) {
            return DUMMY_LDAP_SYNTAX;
        }
        if (this.lsdMapByNumericOid.containsKey(numericOid.toLowerCase())) {
            return this.lsdMapByNumericOid.get(numericOid.toLowerCase());
        }
        if (!this.isDefault()) {
            return DEFAULT_SCHEMA.getLdapSyntaxDescription(numericOid);
        }
        LdapSyntaxDescription lsd = new LdapSyntaxDescription();
        lsd.setNumericOid(numericOid);
        lsd.setExtensions(DUMMY_EXTENSIONS);
        return lsd;
    }

    private void addMatchingRuleDescription(MatchingRuleDescription mrd) {
        if (mrd.getNumericOid() != null) {
            this.mrdMapByNameOrNumericOid.put(mrd.getNumericOid().toLowerCase(), mrd);
        }
        if (mrd.getNames() != null && !mrd.getNames().isEmpty()) {
            for (String mrdName : mrd.getNames()) {
                this.mrdMapByNameOrNumericOid.put(mrdName.toLowerCase(), mrd);
            }
        }
    }

    public Collection<MatchingRuleDescription> getMatchingRuleDescriptions() {
        HashSet<MatchingRuleDescription> set = new HashSet<MatchingRuleDescription>(this.mrdMapByNameOrNumericOid.values());
        return set;
    }

    public boolean hasMatchingRuleDescription(String nameOrOid) {
        return this.mrdMapByNameOrNumericOid.containsKey(nameOrOid.toLowerCase());
    }

    public MatchingRuleDescription getMatchingRuleDescription(String nameOrOid) {
        if (this.mrdMapByNameOrNumericOid.containsKey(nameOrOid.toLowerCase())) {
            return this.mrdMapByNameOrNumericOid.get(nameOrOid.toLowerCase());
        }
        if (!this.isDefault()) {
            return DEFAULT_SCHEMA.getMatchingRuleDescription(nameOrOid);
        }
        MatchingRuleDescription mrd = new MatchingRuleDescription();
        mrd.setNumericOid(nameOrOid);
        mrd.setExtensions(DUMMY_EXTENSIONS);
        return mrd;
    }

    private void addMatchingRuleUseDescription(MatchingRuleUseDescription mrud) {
        if (mrud.getNumericOid() != null) {
            this.mrudMapByNameOrNumericOid.put(mrud.getNumericOid().toLowerCase(), mrud);
        }
        if (mrud.getNames() != null && !mrud.getNames().isEmpty()) {
            for (String mrudName : mrud.getNames()) {
                this.mrudMapByNameOrNumericOid.put(mrudName.toLowerCase(), mrud);
            }
        }
    }

    public Collection<MatchingRuleUseDescription> getMatchingRuleUseDescriptions() {
        HashSet<MatchingRuleUseDescription> set = new HashSet<MatchingRuleUseDescription>(this.mrudMapByNameOrNumericOid.values());
        return set;
    }

    public boolean hasMatchingRuleUseDescription(String nameOrOid) {
        return this.mrudMapByNameOrNumericOid.containsKey(nameOrOid.toLowerCase());
    }

    public MatchingRuleUseDescription getMatchingRuleUseDescription(String nameOrOid) {
        if (this.mrudMapByNameOrNumericOid.containsKey(nameOrOid.toLowerCase())) {
            return this.mrudMapByNameOrNumericOid.get(nameOrOid.toLowerCase());
        }
        if (!this.isDefault()) {
            return DEFAULT_SCHEMA.getMatchingRuleUseDescription(nameOrOid);
        }
        MatchingRuleUseDescription mrud = new MatchingRuleUseDescription();
        mrud.setNumericOid(nameOrOid);
        mrud.setExtensions(DUMMY_EXTENSIONS);
        return mrud;
    }

    static {
        DUMMY_LDAP_SYNTAX.setNumericOid("");
        DUMMY_LDAP_SYNTAX.setDescription("");
        DUMMY_EXTENSIONS = new HashMap();
        ArrayList<String> dummyValues = new ArrayList<String>();
        dummyValues.add("DUMMY");
        DUMMY_EXTENSIONS.put("X-DUMMY", dummyValues);
        Schema defaultSchema = null;
        try {
            URL url = Schema.class.getClassLoader().getResource("default_schema.ldif");
            InputStream is = url.openStream();
            InputStreamReader reader = new InputStreamReader(is);
            defaultSchema = new Schema();
            defaultSchema.defaultSchema = true;
            defaultSchema.loadFromLdif(reader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DEFAULT_SCHEMA = defaultSchema;
    }
}

