/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.impl;

import java.util.ArrayList;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.ldapbrowser.core.internal.search.LdapSearchPageScoreComputer;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.eclipse.search.ui.ISearchPageScoreComputer;

public class SearchResult
implements ISearchResult {
    private static final long serialVersionUID = -5658803569872619432L;
    private ISearch search;
    private IEntry entry;

    protected SearchResult() {
    }

    public SearchResult(IEntry entry, ISearch search) {
        this.entry = entry;
        this.search = search;
    }

    public LdapDN getDn() {
        return this.entry.getDn();
    }

    public IAttribute[] getAttributes() {
        ArrayList<IAttribute> attributeList = new ArrayList<IAttribute>();
        for (int i = 0; i < this.search.getReturningAttributes().length; ++i) {
            if (this.entry.getAttribute(this.search.getReturningAttributes()[i]) == null) continue;
            attributeList.add(this.entry.getAttribute(this.search.getReturningAttributes()[i]));
        }
        return attributeList.toArray(new IAttribute[attributeList.size()]);
    }

    public IAttribute getAttribute(String attributeDescription) {
        return this.entry.getAttribute(attributeDescription);
    }

    public AttributeHierarchy getAttributeWithSubtypes(String attributeDescription) {
        return this.entry.getAttributeWithSubtypes(attributeDescription);
    }

    public IEntry getEntry() {
        return this.entry;
    }

    public Object getAdapter(Class adapter) {
        Class clazz = adapter;
        if (clazz.isAssignableFrom(ISearchPageScoreComputer.class)) {
            return new LdapSearchPageScoreComputer();
        }
        if (clazz.isAssignableFrom(Connection.class)) {
            return this.search.getBrowserConnection().getConnection();
        }
        if (clazz.isAssignableFrom(IBrowserConnection.class)) {
            return this.search.getBrowserConnection();
        }
        if (clazz.isAssignableFrom(IEntry.class)) {
            return this.getEntry();
        }
        return null;
    }

    public ISearch getSearch() {
        return this.search;
    }

    public void setSearch(ISearch search) {
        this.search = search;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entry == null ? 0 : this.entry.getDn().hashCode());
        result = 31 * result + (this.search == null ? 0 : this.search.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResult)) {
            return false;
        }
        SearchResult other = (SearchResult)obj;
        if (this.entry == null ? other.entry != null : !this.entry.equals(other.entry)) {
            return false;
        }
        return !(this.search == null ? other.search != null : !this.search.equals(other.search));
    }
}

