/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.impl;

import java.util.Arrays;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.core.model.impl.BaseDNEntry;

public final class RootDSE
extends BaseDNEntry
implements IRootDSE {
    private static final long serialVersionUID = -8445018787232919754L;

    protected RootDSE() {
    }

    public RootDSE(IBrowserConnection browserConnection) {
        super(LdapDN.EMPTY_LDAPDN, browserConnection);
    }

    public IEntry getParententry() {
        return null;
    }

    public String[] getSupportedExtensions() {
        return this.getAttributeValues("supportedExtension");
    }

    public String[] getSupportedControls() {
        return this.getAttributeValues("supportedControl");
    }

    public String[] getSupportedFeatures() {
        return this.getAttributeValues("supportedFeatures");
    }

    private String[] getAttributeValues(String attributeDescription) {
        IAttribute supportedFeaturesAttr = this.getAttribute(attributeDescription);
        if (supportedFeaturesAttr != null) {
            Object[] stringValues = supportedFeaturesAttr.getStringValues();
            Arrays.sort(stringValues);
            return stringValues;
        }
        return new String[0];
    }

    public boolean isSubentry() {
        return false;
    }

    public boolean isControlSupported(String oid) {
        String[] supportedControls = this.getSupportedControls();
        return Arrays.asList(supportedControls).contains(oid);
    }

    public boolean isFeatureSupported(String oid) {
        String[] supportedFeatures = this.getSupportedFeatures();
        return Arrays.asList(supportedFeatures).contains(oid);
    }
}

