/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.impl;

import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.studio.connection.core.DnUtils;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.AbstractEntry;

public class Entry
extends AbstractEntry {
    private static final long serialVersionUID = -4718107307581983276L;
    protected Rdn rdn;
    protected IEntry parent;

    protected Entry() {
    }

    public Entry(IEntry parent, Rdn rdn) {
        assert (parent != null);
        assert (rdn != null);
        assert (!"".equals(rdn.toString()));
        this.parent = parent;
        this.rdn = rdn;
    }

    public Rdn getRdn() {
        return this.rdn;
    }

    public LdapDN getDn() {
        LdapDN dn = DnUtils.composeDn((Rdn)this.rdn, (LdapDN)this.parent.getDn());
        return dn;
    }

    public IEntry getParententry() {
        return this.parent;
    }

    public IBrowserConnection getBrowserConnection() {
        return this.getParententry().getBrowserConnection();
    }

    protected void setRdn(Rdn newRdn) {
        this.rdn = newRdn;
    }

    protected void setParent(IEntry newParent) {
        this.parent = newParent;
    }
}

