/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescription;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.studio.connection.core.jobs.StudioBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.events.AttributeAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.AttributeDeletedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeDescription;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.ICompareableEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummyEntry
implements IEntry,
ICompareableEntry {
    private static final long serialVersionUID = 4833907766031149971L;
    private LdapDN dn;
    private IBrowserConnection browserConnection;
    private Map<String, IAttribute> attributeMap;

    protected DummyEntry() {
    }

    public DummyEntry(LdapDN dn, IBrowserConnection browserConnection) {
        this.dn = dn;
        this.browserConnection = browserConnection;
        this.attributeMap = new LinkedHashMap<String, IAttribute>();
    }

    public void setDn(LdapDN dn) {
        this.dn = dn;
    }

    @Override
    public void addAttribute(IAttribute attributeToAdd) {
        String oidString = attributeToAdd.getAttributeDescription().toOidString(this.getBrowserConnection().getSchema());
        this.attributeMap.put(oidString.toLowerCase(), attributeToAdd);
        EventRegistry.fireEntryUpdated(new AttributeAddedEvent(attributeToAdd.getEntry().getBrowserConnection(), this, attributeToAdd), this);
    }

    @Override
    public void addChild(IEntry childrenToAdd) {
    }

    @Override
    public void deleteAttribute(IAttribute attributeToDelete) {
        String oidString = attributeToDelete.getAttributeDescription().toOidString(this.getBrowserConnection().getSchema());
        this.attributeMap.remove(oidString.toLowerCase());
        EventRegistry.fireEntryUpdated(new AttributeDeletedEvent(attributeToDelete.getEntry().getBrowserConnection(), this, attributeToDelete), this);
    }

    @Override
    public void deleteChild(IEntry childrenToDelete) {
    }

    @Override
    public IAttribute getAttribute(String attributeDescription) {
        AttributeDescription ad = new AttributeDescription(attributeDescription);
        String oidString = ad.toOidString(this.getBrowserConnection().getSchema());
        return this.attributeMap.get(oidString.toLowerCase());
    }

    @Override
    public AttributeHierarchy getAttributeWithSubtypes(String attributeDescription) {
        ArrayList<IAttribute> attributeList = new ArrayList<IAttribute>();
        IAttribute myAttribute = this.getAttribute(attributeDescription);
        if (myAttribute != null) {
            attributeList.add(myAttribute);
        }
        AttributeDescription ad = new AttributeDescription(attributeDescription);
        for (IAttribute attribute : this.attributeMap.values()) {
            AttributeDescription other = attribute.getAttributeDescription();
            if (!other.isSubtypeOf(ad, this.getBrowserConnection().getSchema())) continue;
            attributeList.add(attribute);
        }
        if (attributeList.isEmpty()) {
            return null;
        }
        AttributeHierarchy ah = new AttributeHierarchy(this, attributeDescription, attributeList.toArray(new IAttribute[attributeList.size()]));
        return ah;
    }

    @Override
    public IAttribute[] getAttributes() {
        return this.attributeMap.values().toArray(new IAttribute[this.attributeMap.size()]);
    }

    @Override
    public IBrowserConnection getBrowserConnection() {
        return this.browserConnection;
    }

    @Override
    public LdapDN getDn() {
        return this.dn;
    }

    @Override
    public LdapURL getUrl() {
        return Utils.getLdapURL(this);
    }

    @Override
    public IEntry getParententry() {
        return null;
    }

    @Override
    public Rdn getRdn() {
        Rdn rdn = this.dn.getRdn();
        return rdn == null ? new Rdn() : rdn;
    }

    @Override
    public IEntry[] getChildren() {
        return null;
    }

    @Override
    public int getChildrenCount() {
        return -1;
    }

    @Override
    public String getChildrenFilter() {
        return "";
    }

    @Override
    public boolean hasMoreChildren() {
        return false;
    }

    @Override
    public StudioBulkRunnableWithProgress getNextPageChildrenRunnable() {
        return null;
    }

    @Override
    public StudioBulkRunnableWithProgress getTopPageChildrenRunnable() {
        return null;
    }

    @Override
    public boolean hasParententry() {
        return false;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean isAlias() {
        return this.getObjectClassDescriptions().contains(this.getBrowserConnection().getSchema().getObjectClassDescription("alias"));
    }

    @Override
    public boolean isAttributesInitialized() {
        return true;
    }

    @Override
    public boolean isInitOperationalAttributes() {
        return true;
    }

    @Override
    public boolean isFetchAliases() {
        return false;
    }

    @Override
    public boolean isFetchReferrals() {
        return false;
    }

    @Override
    public boolean isFetchSubentries() {
        return false;
    }

    @Override
    public boolean isReferral() {
        return this.getObjectClassDescriptions().contains(this.getBrowserConnection().getSchema().getObjectClassDescription("referral"));
    }

    @Override
    public boolean isSubentry() {
        return this.getObjectClassDescriptions().contains(this.getBrowserConnection().getSchema().getObjectClassDescription("subentry"));
    }

    @Override
    public boolean isChildrenInitialized() {
        return false;
    }

    @Override
    public void setAlias(boolean b) {
    }

    @Override
    public void setAttributesInitialized(boolean b) {
    }

    @Override
    public void setInitOperationalAttributes(boolean b) {
    }

    @Override
    public void setFetchAliases(boolean b) {
    }

    @Override
    public void setFetchReferrals(boolean b) {
    }

    @Override
    public void setFetchSubentries(boolean b) {
    }

    @Override
    public void setDirectoryEntry(boolean isDirectoryEntry) {
    }

    @Override
    public void setHasMoreChildren(boolean b) {
    }

    @Override
    public void setTopPageChildrenRunnable(StudioBulkRunnableWithProgress topPageChildrenRunnable) {
    }

    @Override
    public void setNextPageChildrenRunnable(StudioBulkRunnableWithProgress nextPageChildrenRunnable) {
    }

    @Override
    public void setHasChildrenHint(boolean b) {
    }

    @Override
    public void setReferral(boolean b) {
    }

    @Override
    public void setSubentry(boolean b) {
    }

    @Override
    public void setChildrenFilter(String filter) {
    }

    @Override
    public void setChildrenInitialized(boolean b) {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    @Override
    public Collection<ObjectClassDescription> getObjectClassDescriptions() {
        ArrayList<ObjectClassDescription> ocds = new ArrayList<ObjectClassDescription>();
        IAttribute ocAttribute = this.getAttribute("objectClass");
        if (ocAttribute != null) {
            String[] ocNames = ocAttribute.getStringValues();
            Schema schema = this.getBrowserConnection().getSchema();
            for (String ocName : ocNames) {
                ObjectClassDescription ocd = schema.getObjectClassDescription(ocName);
                ocds.add(ocd);
            }
        }
        return ocds;
    }

    public int hashCode() {
        return this.getDn().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ICompareableEntry)) {
            return false;
        }
        ICompareableEntry e = (ICompareableEntry)o;
        return this.getDn() == null ? e.getDn() == null : this.getDn().equals((Object)e.getDn()) && this.getBrowserConnection().equals(e.getBrowserConnection());
    }
}

