/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.impl;

import java.util.Collection;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescription;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.studio.connection.core.jobs.StudioBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.internal.search.LdapSearchPageScoreComputer;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DummyConnection;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.eclipse.search.ui.ISearchPageScoreComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelegateEntry
implements IEntry {
    private static final long serialVersionUID = -4488685394817691963L;
    protected String connectionId;
    protected LdapDN dn;
    protected boolean entryDoesNotExist;
    protected IEntry delegate;

    protected DelegateEntry() {
    }

    protected DelegateEntry(IBrowserConnection browserConnection, LdapDN dn) {
        this.connectionId = browserConnection.getConnection() != null ? browserConnection.getConnection().getId() : null;
        this.dn = dn;
        this.entryDoesNotExist = false;
        this.delegate = null;
    }

    protected IEntry getDelegate() {
        IBrowserConnection browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnectionById(this.connectionId);
        if (browserConnection == null) {
            browserConnection = new DummyConnection(Schema.DEFAULT_SCHEMA);
        }
        this.delegate = browserConnection.getEntryFromCache(this.dn);
        if (this.delegate != null && !this.delegate.getBrowserConnection().getConnection().getJNDIConnectionWrapper().isConnected()) {
            this.entryDoesNotExist = false;
            this.delegate = null;
        }
        return this.delegate;
    }

    protected void setDelegate(IEntry delegate) {
        this.delegate = delegate;
    }

    @Override
    public IBrowserConnection getBrowserConnection() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getBrowserConnection();
        }
        IBrowserConnection browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnectionById(this.connectionId);
        if (browserConnection == null) {
            browserConnection = new DummyConnection(Schema.DEFAULT_SCHEMA);
        }
        return browserConnection;
    }

    @Override
    public LdapDN getDn() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getDn();
        }
        return this.dn;
    }

    @Override
    public LdapURL getUrl() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getUrl();
        }
        return Utils.getLdapURL(this);
    }

    @Override
    public boolean isAttributesInitialized() {
        if (this.getDelegate() != null) {
            return this.getDelegate().isAttributesInitialized();
        }
        return this.entryDoesNotExist;
    }

    @Override
    public boolean isInitOperationalAttributes() {
        if (this.getDelegate() != null) {
            return this.getDelegate().isInitOperationalAttributes();
        }
        return false;
    }

    @Override
    public boolean isFetchAliases() {
        if (this.getDelegate() != null) {
            return this.getDelegate().isFetchAliases();
        }
        return false;
    }

    @Override
    public boolean isFetchReferrals() {
        if (this.getDelegate() != null) {
            return this.getDelegate().isFetchReferrals();
        }
        return false;
    }

    @Override
    public boolean isFetchSubentries() {
        if (this.getDelegate() != null) {
            return this.getDelegate().isFetchSubentries();
        }
        return false;
    }

    @Override
    public boolean isChildrenInitialized() {
        if (this.getDelegate() != null) {
            return this.getDelegate().isChildrenInitialized();
        }
        return this.entryDoesNotExist;
    }

    @Override
    public void addAttribute(IAttribute attributeToAdd) {
        if (this.getDelegate() != null) {
            this.getDelegate().addAttribute(attributeToAdd);
        }
    }

    @Override
    public void addChild(IEntry childrenToAdd) {
        if (this.getDelegate() != null) {
            this.getDelegate().addChild(childrenToAdd);
        }
    }

    @Override
    public void deleteAttribute(IAttribute attributeToDelete) {
        if (this.getDelegate() != null) {
            this.getDelegate().deleteAttribute(attributeToDelete);
        }
    }

    @Override
    public void deleteChild(IEntry childrenToDelete) {
        if (this.getDelegate() != null) {
            this.getDelegate().deleteChild(childrenToDelete);
        }
    }

    @Override
    public IAttribute getAttribute(String attributeDescription) {
        if (this.getDelegate() != null) {
            return this.getDelegate().getAttribute(attributeDescription);
        }
        return null;
    }

    @Override
    public AttributeHierarchy getAttributeWithSubtypes(String attributeDescription) {
        if (this.getDelegate() != null) {
            return this.getDelegate().getAttributeWithSubtypes(attributeDescription);
        }
        return null;
    }

    @Override
    public IAttribute[] getAttributes() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getAttributes();
        }
        return new IAttribute[0];
    }

    @Override
    public IEntry getParententry() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getParententry();
        }
        return null;
    }

    @Override
    public Rdn getRdn() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getRdn();
        }
        Rdn rdn = this.dn.getRdn();
        return rdn == null ? new Rdn() : rdn;
    }

    @Override
    public IEntry[] getChildren() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getChildren();
        }
        return new IEntry[0];
    }

    @Override
    public int getChildrenCount() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getChildrenCount();
        }
        return -1;
    }

    @Override
    public String getChildrenFilter() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getChildrenFilter();
        }
        return null;
    }

    @Override
    public boolean hasMoreChildren() {
        if (this.getDelegate() != null) {
            return this.getDelegate().hasMoreChildren();
        }
        return false;
    }

    @Override
    public StudioBulkRunnableWithProgress getTopPageChildrenRunnable() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getTopPageChildrenRunnable();
        }
        return null;
    }

    @Override
    public StudioBulkRunnableWithProgress getNextPageChildrenRunnable() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getNextPageChildrenRunnable();
        }
        return null;
    }

    @Override
    public boolean hasParententry() {
        if (this.getDelegate() != null) {
            return this.getDelegate().hasParententry();
        }
        return false;
    }

    @Override
    public boolean hasChildren() {
        if (this.getDelegate() != null) {
            return this.getDelegate().hasChildren();
        }
        return true;
    }

    @Override
    public void setAttributesInitialized(boolean b) {
        if (!b) {
            if (this.getDelegate() != null) {
                this.getDelegate().setAttributesInitialized(b);
            }
            this.setDelegate(null);
            this.entryDoesNotExist = false;
        } else {
            if (this.getDelegate() == null) {
                this.setDelegate(this.getBrowserConnection().getEntryFromCache(this.dn));
                if (this.getDelegate() == null) {
                    this.entryDoesNotExist = true;
                }
            }
            if (this.getDelegate() != null) {
                this.getDelegate().setAttributesInitialized(b);
            }
        }
    }

    @Override
    public void setInitOperationalAttributes(boolean b) {
        if (!b) {
            if (this.getDelegate() != null) {
                this.getDelegate().setInitOperationalAttributes(b);
            }
            this.setDelegate(null);
            this.entryDoesNotExist = false;
        } else {
            if (this.getDelegate() == null) {
                this.setDelegate(this.getBrowserConnection().getEntryFromCache(this.dn));
                if (this.getDelegate() == null) {
                    this.entryDoesNotExist = true;
                }
            }
            if (this.getDelegate() != null) {
                this.getDelegate().setInitOperationalAttributes(b);
            }
        }
    }

    @Override
    public void setFetchAliases(boolean b) {
        if (!b) {
            if (this.getDelegate() != null) {
                this.getDelegate().setFetchAliases(b);
            }
            this.setDelegate(null);
            this.entryDoesNotExist = false;
        } else {
            if (this.getDelegate() == null) {
                this.setDelegate(this.getBrowserConnection().getEntryFromCache(this.dn));
                if (this.getDelegate() == null) {
                    this.entryDoesNotExist = true;
                }
            }
            if (this.getDelegate() != null) {
                this.getDelegate().setFetchAliases(b);
            }
        }
    }

    @Override
    public void setFetchReferrals(boolean b) {
        if (!b) {
            if (this.getDelegate() != null) {
                this.getDelegate().setFetchReferrals(b);
            }
            this.setDelegate(null);
            this.entryDoesNotExist = false;
        } else {
            if (this.getDelegate() == null) {
                this.setDelegate(this.getBrowserConnection().getEntryFromCache(this.dn));
                if (this.getDelegate() == null) {
                    this.entryDoesNotExist = true;
                }
            }
            if (this.getDelegate() != null) {
                this.getDelegate().setFetchReferrals(b);
            }
        }
    }

    @Override
    public void setFetchSubentries(boolean b) {
        if (!b) {
            if (this.getDelegate() != null) {
                this.getDelegate().setFetchSubentries(b);
            }
            this.setDelegate(null);
            this.entryDoesNotExist = false;
        } else {
            if (this.getDelegate() == null) {
                this.setDelegate(this.getBrowserConnection().getEntryFromCache(this.dn));
                if (this.getDelegate() == null) {
                    this.entryDoesNotExist = true;
                }
            }
            if (this.getDelegate() != null) {
                this.getDelegate().setFetchSubentries(b);
            }
        }
    }

    @Override
    public void setDirectoryEntry(boolean b) {
        if (this.getDelegate() != null) {
            this.getDelegate().setDirectoryEntry(b);
        }
    }

    @Override
    public void setHasMoreChildren(boolean b) {
        if (this.getDelegate() != null) {
            this.getDelegate().setHasMoreChildren(b);
        }
    }

    @Override
    public void setTopPageChildrenRunnable(StudioBulkRunnableWithProgress topPageChildrenRunnable) {
        if (this.getDelegate() != null) {
            this.getDelegate().setTopPageChildrenRunnable(topPageChildrenRunnable);
        }
    }

    @Override
    public void setNextPageChildrenRunnable(StudioBulkRunnableWithProgress nextPageChildrenRunnable) {
        if (this.getDelegate() != null) {
            this.getDelegate().setNextPageChildrenRunnable(nextPageChildrenRunnable);
        }
    }

    @Override
    public void setHasChildrenHint(boolean b) {
        if (this.getDelegate() != null) {
            this.getDelegate().setHasChildrenHint(b);
        }
    }

    @Override
    public void setChildrenFilter(String filter) {
        if (this.getDelegate() != null) {
            this.getDelegate().setChildrenFilter(filter);
        }
    }

    @Override
    public void setChildrenInitialized(boolean b) {
        if (!b) {
            if (this.getDelegate() != null) {
                this.getDelegate().setChildrenInitialized(b);
            }
            this.entryDoesNotExist = false;
        } else {
            if (this.getDelegate() == null) {
                this.setDelegate(this.getBrowserConnection().getEntryFromCache(this.dn));
                if (this.getDelegate() == null) {
                    this.entryDoesNotExist = true;
                }
            }
            if (this.getDelegate() != null) {
                this.getDelegate().setChildrenInitialized(b);
            }
        }
    }

    @Override
    public boolean isAlias() {
        if (this.getDelegate() != null) {
            return this.getDelegate().isAlias();
        }
        return false;
    }

    @Override
    public void setAlias(boolean b) {
        if (this.getDelegate() != null) {
            this.getDelegate().setAlias(b);
        }
    }

    @Override
    public boolean isReferral() {
        if (this.getDelegate() != null) {
            return this.getDelegate().isReferral();
        }
        return false;
    }

    @Override
    public void setReferral(boolean b) {
        if (this.getDelegate() != null) {
            this.getDelegate().setReferral(b);
        }
    }

    @Override
    public boolean isSubentry() {
        if (this.getDelegate() != null) {
            return this.getDelegate().isSubentry();
        }
        return false;
    }

    @Override
    public void setSubentry(boolean b) {
        if (this.getDelegate() != null) {
            this.getDelegate().setSubentry(b);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ISearchPageScoreComputer.class)) {
            return new LdapSearchPageScoreComputer();
        }
        if (adapter == IBrowserConnection.class) {
            return this.getBrowserConnection();
        }
        if (adapter == IEntry.class) {
            return this;
        }
        return null;
    }

    @Override
    public Collection<ObjectClassDescription> getObjectClassDescriptions() {
        if (this.getDelegate() != null) {
            return this.getDelegate().getObjectClassDescriptions();
        }
        return null;
    }
}

