/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.impl;

import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.ldapbrowser.core.events.BookmarkUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.internal.search.LdapSearchPageScoreComputer;
import org.apache.directory.studio.ldapbrowser.core.model.BookmarkParameter;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.BookmarkEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DelegateEntry;
import org.eclipse.search.ui.ISearchPageScoreComputer;

public class Bookmark
implements IBookmark {
    private static final long serialVersionUID = 2914726541167255499L;
    private IBrowserConnection connection;
    private BookmarkParameter bookmarkParameter;
    private DelegateEntry bookmarkEntry;

    protected Bookmark() {
    }

    public Bookmark(IBrowserConnection connection, BookmarkParameter bookmarkParameter) {
        this.connection = connection;
        this.bookmarkParameter = bookmarkParameter;
        this.bookmarkEntry = new BookmarkEntry(connection, bookmarkParameter.getDn());
    }

    public Bookmark(IBrowserConnection connection, LdapDN dn, String name) {
        this.connection = connection;
        this.bookmarkParameter = new BookmarkParameter(dn, name);
        this.bookmarkEntry = new BookmarkEntry(connection, dn);
    }

    public LdapDN getDn() {
        return this.bookmarkParameter.getDn();
    }

    public void setDn(LdapDN dn) {
        this.bookmarkParameter.setDn(dn);
        this.fireBookmarkUpdated(BookmarkUpdateEvent.Detail.BOOKMARK_UPDATED);
    }

    public String getName() {
        return this.bookmarkParameter.getName();
    }

    public void setName(String name) {
        this.bookmarkParameter.setName(name);
        this.fireBookmarkUpdated(BookmarkUpdateEvent.Detail.BOOKMARK_UPDATED);
    }

    public Object getAdapter(Class adapter) {
        Class clazz = adapter;
        if (clazz.isAssignableFrom(ISearchPageScoreComputer.class)) {
            return new LdapSearchPageScoreComputer();
        }
        if (clazz.isAssignableFrom(Connection.class)) {
            return this.getBrowserConnection().getConnection();
        }
        if (clazz.isAssignableFrom(IBrowserConnection.class)) {
            return this.getBrowserConnection();
        }
        if (clazz.isAssignableFrom(IEntry.class)) {
            return this.getEntry();
        }
        if (clazz.isAssignableFrom(IBookmark.class)) {
            return this;
        }
        return null;
    }

    private void fireBookmarkUpdated(BookmarkUpdateEvent.Detail detail) {
        if (this.getName() != null && !"".equals(this.getName())) {
            EventRegistry.fireBookmarkUpdated(new BookmarkUpdateEvent(this, detail), this);
        }
    }

    public BookmarkParameter getBookmarkParameter() {
        return this.bookmarkParameter;
    }

    public void setBookmarkParameter(BookmarkParameter bookmarkParameter) {
        this.bookmarkParameter = bookmarkParameter;
    }

    public IBrowserConnection getBrowserConnection() {
        return this.connection;
    }

    public IEntry getEntry() {
        return this.bookmarkEntry;
    }

    public String toString() {
        return this.getName();
    }
}

