/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.parsers.ObjectClassDescription;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioBulkRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.AttributeAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.AttributeDeletedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.AttributesInitializedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.ChildrenInitializedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryDeletedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.internal.search.LdapSearchPageScoreComputer;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeDescription;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.ICompareableEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.AttributeInfo;
import org.apache.directory.studio.ldapbrowser.core.model.impl.BrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.impl.ChildrenInfo;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.eclipse.search.ui.ISearchPageScoreComputer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntry
implements IEntry,
ICompareableEntry {
    private static final long serialVersionUID = -2431637532526418774L;
    private static final int HAS_CHILDREN_HINT_FLAG = 1;
    private static final int IS_DIRECTORY_ENTRY_FLAG = 2;
    private static final int IS_ALIAS_FLAG = 4;
    private static final int IS_REFERRAL_FLAG = 8;
    private static final int IS_SUBENTRY_FLAG = 16;
    private static final int IS_INIT_OPERATIONAL_ATTRIBUTES_FLAG = 32;
    private static final int IS_FETCH_ALIASES_FLAG = 64;
    private static final int IS_FETCH_REFERRALS_FLAG = 128;
    private static final int IS_FETCH_SUBENTRIES_FLAG = 256;
    private volatile int flags = 1;
    protected IAttribute objectClassAttribute;

    protected AbstractEntry() {
    }

    protected abstract void setParent(IEntry var1);

    protected abstract void setRdn(Rdn var1);

    @Override
    public void addChild(IEntry childToAdd) {
        ChildrenInfo ci = this.getBrowserConnectionImpl().getChildrenInfo(this);
        if (ci == null) {
            ci = new ChildrenInfo();
            this.getBrowserConnectionImpl().setChildrenInfo(this, ci);
        }
        if (ci.childrenSet == null) {
            ci.childrenSet = new LinkedHashSet<IEntry>();
        }
        ci.childrenSet.add(childToAdd);
        this.entryModified(new EntryAddedEvent(childToAdd.getBrowserConnection(), childToAdd));
    }

    @Override
    public void deleteChild(IEntry childToDelete) {
        ChildrenInfo ci = this.getBrowserConnectionImpl().getChildrenInfo(this);
        if (ci != null) {
            if (ci.childrenSet != null) {
                ci.childrenSet.remove(childToDelete);
            }
            if (ci.childrenSet == null || ci.childrenSet.isEmpty()) {
                this.getBrowserConnectionImpl().setChildrenInfo(this, null);
            }
            this.entryModified(new EntryDeletedEvent(this.getBrowserConnectionImpl(), childToDelete));
        }
    }

    @Override
    public void addAttribute(IAttribute attributeToAdd) throws IllegalArgumentException {
        if (!this.equals(attributeToAdd.getEntry())) {
            throw new IllegalArgumentException(BrowserCoreMessages.model__attributes_entry_is_not_myself);
        }
        if (attributeToAdd.isObjectClassAttribute()) {
            if (this.objectClassAttribute != null) {
                throw new IllegalArgumentException(BrowserCoreMessages.model__attribute_already_exists);
            }
            this.objectClassAttribute = attributeToAdd;
        } else {
            String oidString = attributeToAdd.getAttributeDescription().toOidString(this.getBrowserConnection().getSchema());
            AttributeInfo ai = this.getBrowserConnectionImpl().getAttributeInfo(this);
            if (ai == null) {
                ai = new AttributeInfo();
                this.getBrowserConnectionImpl().setAttributeInfo(this, ai);
            }
            if (ai.attributeMap.containsKey(oidString.toLowerCase())) {
                throw new IllegalArgumentException(BrowserCoreMessages.model__attribute_already_exists);
            }
            ai.attributeMap.put(oidString.toLowerCase(), attributeToAdd);
        }
        this.entryModified(new AttributeAddedEvent(this.getBrowserConnectionImpl(), this, attributeToAdd));
    }

    @Override
    public void deleteAttribute(IAttribute attributeToDelete) throws IllegalArgumentException {
        if (attributeToDelete.isObjectClassAttribute()) {
            if (this.objectClassAttribute == null) {
                throw new IllegalArgumentException(BrowserCoreMessages.model__attribute_does_not_exist + ": " + attributeToDelete);
            }
            this.objectClassAttribute = null;
        } else {
            String oidString = attributeToDelete.getAttributeDescription().toOidString(this.getBrowserConnection().getSchema());
            AttributeInfo ai = this.getBrowserConnectionImpl().getAttributeInfo(this);
            if (ai != null && ai.attributeMap != null && ai.attributeMap.containsKey(oidString.toLowerCase())) {
                attributeToDelete = ai.attributeMap.get(oidString.toLowerCase());
                ai.attributeMap.remove(oidString.toLowerCase());
                if (ai.attributeMap.isEmpty()) {
                    this.getBrowserConnectionImpl().setAttributeInfo(this, null);
                }
            } else {
                throw new IllegalArgumentException(BrowserCoreMessages.model__attribute_does_not_exist + ": " + attributeToDelete);
            }
        }
        this.entryModified(new AttributeDeletedEvent(this.getBrowserConnectionImpl(), this, attributeToDelete));
    }

    @Override
    public void setDirectoryEntry(boolean isDirectoryEntry) {
        this.flags = isDirectoryEntry ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    @Override
    public boolean isAlias() {
        if ((this.flags & 4) != 0) {
            return true;
        }
        AttributeInfo ai = this.getBrowserConnectionImpl().getAttributeInfo(this);
        if (ai != null) {
            return this.getObjectClassDescriptions().contains(this.getBrowserConnection().getSchema().getObjectClassDescription("alias"));
        }
        return false;
    }

    @Override
    public void setAlias(boolean b) {
        this.flags = b ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    @Override
    public boolean isReferral() {
        if ((this.flags & 8) != 0) {
            return true;
        }
        AttributeInfo ai = this.getBrowserConnectionImpl().getAttributeInfo(this);
        if (ai != null) {
            return this.getObjectClassDescriptions().contains(this.getBrowserConnection().getSchema().getObjectClassDescription("referral"));
        }
        return false;
    }

    @Override
    public void setReferral(boolean b) {
        this.flags = b ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    @Override
    public boolean isSubentry() {
        if ((this.flags & 0x10) != 0) {
            return true;
        }
        AttributeInfo ai = this.getBrowserConnectionImpl().getAttributeInfo(this);
        if (ai != null) {
            return this.getObjectClassDescriptions().contains(this.getBrowserConnection().getSchema().getObjectClassDescription("subentry"));
        }
        return false;
    }

    @Override
    public void setSubentry(boolean b) {
        this.flags = b ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    private void entryModified(EntryModificationEvent event) {
        EventRegistry.fireEntryUpdated(event, this);
    }

    @Override
    public Rdn getRdn() {
        Rdn rdn = this.getDn().getRdn();
        return rdn == null ? new Rdn() : rdn;
    }

    @Override
    public boolean isAttributesInitialized() {
        AttributeInfo ai = this.getBrowserConnectionImpl().getAttributeInfo(this);
        return ai != null && ai.attributesInitialized;
    }

    @Override
    public void setAttributesInitialized(boolean b) {
        AttributeInfo ai = this.getBrowserConnectionImpl().getAttributeInfo(this);
        if (ai == null && b) {
            ai = new AttributeInfo();
            this.getBrowserConnectionImpl().setAttributeInfo(this, ai);
        }
        if (ai != null) {
            ai.attributesInitialized = b;
        }
        if (ai != null && !b) {
            ai.attributeMap.clear();
            this.getBrowserConnectionImpl().setAttributeInfo(this, null);
        }
        this.entryModified(new AttributesInitializedEvent(this));
    }

    @Override
    public boolean isInitOperationalAttributes() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public void setInitOperationalAttributes(boolean b) {
        this.flags = b ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    @Override
    public boolean isFetchAliases() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public void setFetchAliases(boolean b) {
        this.flags = b ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    @Override
    public boolean isFetchReferrals() {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public void setFetchReferrals(boolean b) {
        this.flags = b ? (this.flags |= 0x80) : (this.flags &= 0xFFFFFF7F);
    }

    @Override
    public boolean isFetchSubentries() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    public void setFetchSubentries(boolean b) {
        this.flags = b ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
    }

    @Override
    public IAttribute[] getAttributes() {
        HashSet<IAttribute> attributes = new HashSet<IAttribute>();
        AttributeInfo ai = this.getBrowserConnectionImpl().getAttributeInfo(this);
        if (ai != null && ai.attributeMap != null) {
            attributes.addAll(ai.attributeMap.values());
        }
        if (this.objectClassAttribute != null) {
            attributes.add(this.objectClassAttribute);
        }
        return attributes.toArray(new IAttribute[0]);
    }

    @Override
    public IAttribute getAttribute(String attributeDescription) {
        AttributeDescription ad = new AttributeDescription(attributeDescription);
        String oidString = ad.toOidString(this.getBrowserConnection().getSchema());
        if (oidString.equals("2.5.4.0")) {
            return this.objectClassAttribute;
        }
        AttributeInfo ai = this.getBrowserConnectionImpl().getAttributeInfo(this);
        if (ai == null || ai.attributeMap == null) {
            return null;
        }
        return ai.attributeMap.get(oidString.toLowerCase());
    }

    @Override
    public AttributeHierarchy getAttributeWithSubtypes(String attributeDescription) {
        IAttribute[] allAttributes;
        ArrayList<IAttribute> attributeList = new ArrayList<IAttribute>();
        IAttribute myAttribute = this.getAttribute(attributeDescription);
        if (myAttribute != null) {
            attributeList.add(myAttribute);
        }
        AttributeDescription ad = new AttributeDescription(attributeDescription);
        for (IAttribute attribute : allAttributes = this.getAttributes()) {
            AttributeDescription other = attribute.getAttributeDescription();
            if (!other.isSubtypeOf(ad, this.getBrowserConnection().getSchema())) continue;
            attributeList.add(attribute);
        }
        if (attributeList.isEmpty()) {
            return null;
        }
        IAttribute[] attributes = attributeList.toArray(new IAttribute[attributeList.size()]);
        AttributeHierarchy ah = new AttributeHierarchy(this, attributeDescription, attributes);
        return ah;
    }

    @Override
    public void setChildrenInitialized(boolean b) {
        ChildrenInfo ci = this.getBrowserConnectionImpl().getChildrenInfo(this);
        if (ci == null && b) {
            ci = new ChildrenInfo();
            this.getBrowserConnectionImpl().setChildrenInfo(this, ci);
        }
        if (ci != null) {
            ci.childrenInitialized = b;
        }
        if (ci != null && !b) {
            if (ci.childrenSet != null) {
                ci.childrenSet.clear();
            }
            this.getBrowserConnectionImpl().setChildrenInfo(this, null);
        }
        this.entryModified(new ChildrenInitializedEvent(this));
    }

    @Override
    public boolean isChildrenInitialized() {
        ChildrenInfo ci = this.getBrowserConnectionImpl().getChildrenInfo(this);
        return ci != null && ci.childrenInitialized;
    }

    @Override
    public IEntry[] getChildren() {
        int count = this.getChildrenCount();
        if (count < 0) {
            return null;
        }
        if (count == 0) {
            return new IEntry[0];
        }
        IEntry[] children = new IEntry[count];
        ChildrenInfo ci = this.getBrowserConnectionImpl().getChildrenInfo(this);
        int i = 0;
        if (ci.childrenSet != null) {
            Iterator<IEntry> i$ = ci.childrenSet.iterator();
            while (i$.hasNext()) {
                IEntry child;
                children[i] = child = i$.next();
                ++i;
            }
        }
        return children;
    }

    @Override
    public int getChildrenCount() {
        if (this.isSubentry()) {
            return 0;
        }
        ChildrenInfo ci = this.getBrowserConnectionImpl().getChildrenInfo(this);
        if (ci == null) {
            return -1;
        }
        return ci.childrenSet == null ? 0 : ci.childrenSet.size();
    }

    @Override
    public void setHasMoreChildren(boolean b) {
        ChildrenInfo ci = this.getBrowserConnectionImpl().getChildrenInfo(this);
        if (ci == null) {
            ci = new ChildrenInfo();
            this.getBrowserConnectionImpl().setChildrenInfo(this, ci);
        }
        ci.hasMoreChildren = b;
        this.entryModified(new ChildrenInitializedEvent(this));
    }

    @Override
    public boolean hasMoreChildren() {
        ChildrenInfo ci = this.getBrowserConnectionImpl().getChildrenInfo(this);
        return ci != null && ci.hasMoreChildren;
    }

    @Override
    public void setTopPageChildrenRunnable(StudioBulkRunnableWithProgress topPageChildrenRunnable) {
        ChildrenInfo ci = this.getBrowserConnectionImpl().getChildrenInfo(this);
        if (ci == null && topPageChildrenRunnable != null) {
            ci = new ChildrenInfo();
            this.getBrowserConnectionImpl().setChildrenInfo(this, ci);
        }
        if (ci != null) {
            ci.topPageChildrenRunnable = topPageChildrenRunnable;
        }
    }

    @Override
    public StudioBulkRunnableWithProgress getTopPageChildrenRunnable() {
        ChildrenInfo ci = this.getBrowserConnectionImpl().getChildrenInfo(this);
        return ci != null ? ci.topPageChildrenRunnable : null;
    }

    @Override
    public void setNextPageChildrenRunnable(StudioBulkRunnableWithProgress nextPageChildrenRunnable) {
        ChildrenInfo ci = this.getBrowserConnectionImpl().getChildrenInfo(this);
        if (ci == null && nextPageChildrenRunnable != null) {
            ci = new ChildrenInfo();
            this.getBrowserConnectionImpl().setChildrenInfo(this, ci);
        }
        if (ci != null) {
            ci.nextPageChildrenRunnable = nextPageChildrenRunnable;
        }
    }

    @Override
    public StudioBulkRunnableWithProgress getNextPageChildrenRunnable() {
        ChildrenInfo ci = this.getBrowserConnectionImpl().getChildrenInfo(this);
        return ci != null ? ci.nextPageChildrenRunnable : null;
    }

    @Override
    public void setHasChildrenHint(boolean b) {
        this.flags = b ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    @Override
    public boolean hasChildren() {
        return (this.flags & 1) != 0 || this.getChildrenCount() > 0;
    }

    @Override
    public String getChildrenFilter() {
        return this.getBrowserConnectionImpl().getChildrenFilter(this);
    }

    @Override
    public void setChildrenFilter(String childrenFilter) {
        this.getBrowserConnectionImpl().setChildrenFilter(this, childrenFilter);
    }

    @Override
    public boolean hasParententry() {
        return this.getParententry() != null;
    }

    private BrowserConnection getBrowserConnectionImpl() {
        return (BrowserConnection)this.getBrowserConnection();
    }

    public String toString() {
        return this.getDn().getUpName();
    }

    public int hashCode() {
        return this.getDn().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ICompareableEntry)) {
            return false;
        }
        ICompareableEntry e = (ICompareableEntry)o;
        return this.getDn() == null ? e.getDn() == null : this.getDn().equals((Object)e.getDn()) && this.getBrowserConnection().equals(e.getBrowserConnection());
    }

    public Object getAdapter(Class adapter) {
        Class clazz = adapter;
        if (clazz.isAssignableFrom(ISearchPageScoreComputer.class)) {
            return new LdapSearchPageScoreComputer();
        }
        if (clazz.isAssignableFrom(Connection.class)) {
            return this.getBrowserConnection().getConnection();
        }
        if (clazz.isAssignableFrom(IBrowserConnection.class)) {
            return this.getBrowserConnection();
        }
        if (clazz.isAssignableFrom(IEntry.class)) {
            return this;
        }
        return null;
    }

    @Override
    public LdapURL getUrl() {
        return Utils.getLdapURL(this);
    }

    @Override
    public Collection<ObjectClassDescription> getObjectClassDescriptions() {
        ArrayList<ObjectClassDescription> ocds = new ArrayList<ObjectClassDescription>();
        IAttribute ocAttribute = this.getAttribute("objectClass");
        if (ocAttribute != null) {
            String[] ocNames = ocAttribute.getStringValues();
            Schema schema = this.getBrowserConnection().getSchema();
            for (String ocName : ocNames) {
                ObjectClassDescription ocd = schema.getObjectClassDescription(ocName);
                ocds.add(ocd);
            }
        }
        return ocds;
    }
}

