/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.filter.parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapFilterToken
implements Comparable<LdapFilterToken> {
    public static final int NEW = Integer.MIN_VALUE;
    public static final int ERROR = -2;
    public static final int EOF = -1;
    public static final int UNKNOWN = 0;
    public static final int WHITESPACE = 1;
    public static final int LPAR = 11;
    public static final int RPAR = 12;
    public static final int AND = 21;
    public static final int OR = 22;
    public static final int NOT = 23;
    public static final int ATTRIBUTE = 31;
    public static final int EQUAL = 41;
    public static final int APROX = 42;
    public static final int GREATER = 43;
    public static final int LESS = 44;
    public static final int PRESENT = 45;
    public static final int SUBSTRING = 46;
    public static final int VALUE = 51;
    public static final int ASTERISK = 52;
    public static final int EXTENSIBLE_ATTRIBUTE = 61;
    public static final int EXTENSIBLE_DNATTR_COLON = 62;
    public static final int EXTENSIBLE_DNATTR = 63;
    public static final int EXTENSIBLE_MATCHINGRULEOID_COLON = 64;
    public static final int EXTENSIBLE_MATCHINGRULEOID = 65;
    public static final int EXTENSIBLE_EQUALS_COLON = 66;
    private int offset;
    private int type;
    private String value;

    public LdapFilterToken(int type, String value, int offset) {
        this.type = type;
        this.value = value;
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.value.length();
    }

    public int getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "(" + this.offset + ") " + "(" + this.type + ") " + this.value;
    }

    @Override
    public int compareTo(LdapFilterToken o) {
        if (o instanceof LdapFilterToken) {
            LdapFilterToken token = o;
            return this.offset - token.offset;
        }
        throw new ClassCastException("Not instanceof LapFilterToken: " + o.getClass().getName());
    }
}

