/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.studio.ldapbrowser.core.model.filter.LdapFilter;
import org.apache.directory.studio.ldapbrowser.core.model.filter.parser.LdapFilterToken;

public abstract class LdapFilterComponent {
    protected final LdapFilter parent;
    protected LdapFilterToken startToken;
    protected List<LdapFilter> filterList;

    protected LdapFilterComponent(LdapFilter parent) {
        if (parent == null) {
            throw new IllegalArgumentException("parent is null");
        }
        this.parent = parent;
        this.startToken = null;
        this.filterList = new ArrayList<LdapFilter>(2);
    }

    public final LdapFilter getParent() {
        return this.parent;
    }

    public boolean setStartToken(LdapFilterToken startToken) {
        if (this.startToken == null && startToken != null) {
            this.startToken = startToken;
            return true;
        }
        return false;
    }

    public final LdapFilterToken getStartToken() {
        return this.startToken;
    }

    public boolean addFilter(LdapFilter filter) {
        if (this.startToken != null && filter != null) {
            this.filterList.add(filter);
            return true;
        }
        return false;
    }

    public LdapFilter[] getFilters() {
        LdapFilter[] filters = new LdapFilter[this.filterList.size()];
        this.filterList.toArray(filters);
        return filters;
    }

    public boolean isValid() {
        if (this.startToken == null) {
            return false;
        }
        if (this.filterList.isEmpty()) {
            return false;
        }
        for (LdapFilter filter : this.filterList) {
            if (filter != null && filter.isValid()) continue;
            return false;
        }
        return true;
    }

    public abstract String getInvalidCause();

    public LdapFilter[] getInvalidFilters() {
        if (this.startToken == null || this.filterList.isEmpty()) {
            return new LdapFilter[]{this.parent};
        }
        ArrayList<LdapFilter> invalidFilterList = new ArrayList<LdapFilter>();
        for (LdapFilter filter : this.filterList) {
            if (filter == null) continue;
            invalidFilterList.addAll(Arrays.asList(filter.getInvalidFilters()));
        }
        return invalidFilterList.toArray(new LdapFilter[invalidFilterList.size()]);
    }

    public LdapFilterToken[] getTokens() {
        ArrayList<LdapFilterToken> tokenList = new ArrayList<LdapFilterToken>();
        if (this.startToken != null) {
            tokenList.add(this.startToken);
        }
        for (LdapFilter filter : this.filterList) {
            if (filter == null) continue;
            tokenList.addAll(Arrays.asList(filter.getTokens()));
        }
        Object[] tokens = tokenList.toArray(new LdapFilterToken[tokenList.size()]);
        Arrays.sort(tokens);
        return tokens;
    }

    public LdapFilter getFilter(int offset) {
        if (this.startToken != null && this.startToken.getOffset() == offset) {
            return this.parent;
        }
        if (this.filterList != null || !this.filterList.isEmpty()) {
            for (LdapFilter filter : this.filterList) {
                if (filter == null || filter.getFilter(offset) == null) continue;
                return filter.getFilter(offset);
            }
            return null;
        }
        return null;
    }
}

