/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.utils.UnixCrypt;
import org.apache.directory.studio.ldifparser.LdifUtils;

public class Password {
    public static final String HASH_METHOD_SHA = "SHA";
    public static final String HASH_METHOD_SSHA = "SSHA";
    public static final String HASH_METHOD_MD5 = "MD5";
    public static final String HASH_METHOD_SMD5 = "SMD5";
    public static final String HASH_METHOD_CRYPT = "CRYPT";
    public static final String HASH_METHOD_NO = BrowserCoreMessages.model__no_hash;
    public static final String HASH_METHOD_UNSUPPORTED = BrowserCoreMessages.model__unsupported_hash;
    public static final String HASH_METHOD_INVALID = BrowserCoreMessages.model__invalid_hash;
    private String hashMethod;
    private byte[] hashedPassword;
    private byte[] salt;
    private String trash;

    public Password(byte[] password) {
        this(LdifUtils.utf8decode((byte[])password));
    }

    public Password(String password) {
        block9: {
            if (password == null) {
                throw new IllegalArgumentException(BrowserCoreMessages.model__empty_password);
            }
            if (password.indexOf(123) == 0 && password.indexOf(125) > 0) {
                try {
                    this.hashMethod = password.substring(password.indexOf(123) + 1, password.indexOf(125));
                    String rest = password.substring(this.hashMethod.length() + 2);
                    if (HASH_METHOD_SHA.equalsIgnoreCase(this.hashMethod) || HASH_METHOD_MD5.equalsIgnoreCase(this.hashMethod)) {
                        this.hashedPassword = LdifUtils.base64decodeToByteArray((String)rest);
                        this.salt = null;
                        break block9;
                    }
                    if (HASH_METHOD_SSHA.equalsIgnoreCase(this.hashMethod)) {
                        byte[] hashedPasswordWithSalt = LdifUtils.base64decodeToByteArray((String)rest);
                        this.hashedPassword = new byte[20];
                        this.salt = new byte[hashedPasswordWithSalt.length - this.hashedPassword.length];
                        Password.split(hashedPasswordWithSalt, this.hashedPassword, this.salt);
                        break block9;
                    }
                    if (HASH_METHOD_SMD5.equalsIgnoreCase(this.hashMethod)) {
                        byte[] hashedPasswordWithSalt = LdifUtils.base64decodeToByteArray((String)rest);
                        this.hashedPassword = new byte[16];
                        this.salt = new byte[hashedPasswordWithSalt.length - this.hashedPassword.length];
                        Password.split(hashedPasswordWithSalt, this.hashedPassword, this.salt);
                        break block9;
                    }
                    if (HASH_METHOD_CRYPT.equalsIgnoreCase(this.hashMethod)) {
                        byte[] saltWithPassword = LdifUtils.utf8encode((String)rest);
                        this.salt = new byte[2];
                        this.hashedPassword = new byte[saltWithPassword.length - this.salt.length];
                        Password.split(saltWithPassword, this.salt, this.hashedPassword);
                        break block9;
                    }
                    this.hashMethod = HASH_METHOD_UNSUPPORTED;
                    this.trash = password;
                }
                catch (RuntimeException e) {
                    this.hashMethod = HASH_METHOD_INVALID;
                    this.trash = password;
                }
            } else {
                this.hashMethod = null;
                this.hashedPassword = LdifUtils.utf8encode((String)password);
                this.salt = null;
            }
        }
    }

    public Password(String hashMethod, String passwordAsPlaintext) {
        if (!(hashMethod == null || HASH_METHOD_NO.equalsIgnoreCase(hashMethod) || HASH_METHOD_SHA.equalsIgnoreCase(hashMethod) || HASH_METHOD_SSHA.equalsIgnoreCase(hashMethod) || HASH_METHOD_MD5.equalsIgnoreCase(hashMethod) || HASH_METHOD_SMD5.equalsIgnoreCase(hashMethod) || HASH_METHOD_CRYPT.equalsIgnoreCase(hashMethod))) {
            throw new IllegalArgumentException(BrowserCoreMessages.model__unsupported_hash);
        }
        if (passwordAsPlaintext == null) {
            throw new IllegalArgumentException(BrowserCoreMessages.model__empty_password);
        }
        if (HASH_METHOD_NO.equalsIgnoreCase(hashMethod)) {
            hashMethod = null;
        }
        this.hashMethod = hashMethod;
        if (HASH_METHOD_SSHA.equalsIgnoreCase(hashMethod) || HASH_METHOD_SMD5.equalsIgnoreCase(hashMethod)) {
            this.salt = new byte[8];
            new SecureRandom().nextBytes(this.salt);
        } else if (HASH_METHOD_CRYPT.equalsIgnoreCase(hashMethod)) {
            this.salt = new byte[2];
            SecureRandom sr = new SecureRandom();
            int i1 = sr.nextInt(64);
            int i2 = sr.nextInt(64);
            this.salt[0] = (byte)(i1 < 12 ? i1 + 46 : (i1 < 38 ? i1 + 65 - 12 : i1 + 97 - 38));
            this.salt[1] = (byte)(i2 < 12 ? i2 + 46 : (i2 < 38 ? i2 + 65 - 12 : i2 + 97 - 38));
        } else {
            this.salt = null;
        }
        if (HASH_METHOD_SHA.equalsIgnoreCase(hashMethod) || HASH_METHOD_SSHA.equalsIgnoreCase(hashMethod)) {
            this.hashedPassword = Password.digest(HASH_METHOD_SHA, passwordAsPlaintext, this.salt);
        } else if (HASH_METHOD_MD5.equalsIgnoreCase(hashMethod) || HASH_METHOD_SMD5.equalsIgnoreCase(hashMethod)) {
            this.hashedPassword = Password.digest(HASH_METHOD_MD5, passwordAsPlaintext, this.salt);
        } else if (HASH_METHOD_CRYPT.equalsIgnoreCase(hashMethod)) {
            this.hashedPassword = Password.crypt(passwordAsPlaintext, this.salt);
        } else if (hashMethod == null) {
            this.hashedPassword = LdifUtils.utf8encode((String)passwordAsPlaintext);
        }
    }

    public boolean verify(String testPasswordAsPlaintext) {
        if (testPasswordAsPlaintext == null) {
            return false;
        }
        boolean verified = false;
        if (this.hashMethod == null) {
            verified = testPasswordAsPlaintext.equals(LdifUtils.utf8decode((byte[])this.hashedPassword));
        } else if (HASH_METHOD_SHA.equalsIgnoreCase(this.hashMethod) || HASH_METHOD_SSHA.equalsIgnoreCase(this.hashMethod)) {
            byte[] hash = Password.digest(HASH_METHOD_SHA, testPasswordAsPlaintext, this.salt);
            verified = Password.equals(hash, this.hashedPassword);
        } else if (HASH_METHOD_MD5.equalsIgnoreCase(this.hashMethod) || HASH_METHOD_SMD5.equalsIgnoreCase(this.hashMethod)) {
            byte[] hash = Password.digest(HASH_METHOD_MD5, testPasswordAsPlaintext, this.salt);
            verified = Password.equals(hash, this.hashedPassword);
        } else if (HASH_METHOD_CRYPT.equalsIgnoreCase(this.hashMethod)) {
            byte[] crypted = Password.crypt(testPasswordAsPlaintext, this.salt);
            verified = Password.equals(crypted, this.hashedPassword);
        }
        return verified;
    }

    public String getHashMethod() {
        return this.hashMethod;
    }

    public byte[] getHashedPassword() {
        return this.hashedPassword;
    }

    public String getHashedPasswordAsHexString() {
        return LdifUtils.hexEncode((byte[])this.hashedPassword);
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public String getSaltAsHexString() {
        return LdifUtils.hexEncode((byte[])this.salt);
    }

    public byte[] toBytes() {
        return LdifUtils.utf8encode((String)this.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (HASH_METHOD_UNSUPPORTED.equalsIgnoreCase(this.hashMethod) || HASH_METHOD_INVALID.equalsIgnoreCase(this.hashMethod)) {
            sb.append(this.trash);
        } else if (HASH_METHOD_CRYPT.equalsIgnoreCase(this.hashMethod)) {
            sb.append('{').append(this.hashMethod).append('}');
            sb.append(LdifUtils.utf8decode((byte[])this.salt));
            sb.append(LdifUtils.utf8decode((byte[])this.hashedPassword));
        } else if (this.hashMethod != null) {
            sb.append('{').append(this.hashMethod).append('}');
            if (this.salt != null) {
                byte[] hashedPasswordWithSaltBytes = new byte[this.hashedPassword.length + this.salt.length];
                Password.merge(hashedPasswordWithSaltBytes, this.hashedPassword, this.salt);
                sb.append(LdifUtils.base64encode((byte[])hashedPasswordWithSaltBytes));
            } else {
                sb.append(LdifUtils.base64encode((byte[])this.hashedPassword));
            }
        } else {
            sb.append(LdifUtils.utf8decode((byte[])this.hashedPassword));
        }
        return sb.toString();
    }

    private static void split(byte[] all, byte[] left, byte[] right) {
        System.arraycopy(all, 0, left, 0, left.length);
        System.arraycopy(all, left.length, right, 0, right.length);
    }

    private static void merge(byte[] all, byte[] left, byte[] right) {
        System.arraycopy(left, 0, all, 0, left.length);
        System.arraycopy(right, 0, all, left.length, right.length);
    }

    private static boolean equals(byte[] data1, byte[] data2) {
        if (data1 == data2) {
            return true;
        }
        if (data1 == null || data2 == null) {
            return false;
        }
        if (data1.length != data2.length) {
            return false;
        }
        for (int i = 0; i < data1.length; ++i) {
            if (data1[i] == data2[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] digest(String hashMethod, String password, byte[] salt) {
        MessageDigest digest;
        byte[] passwordBytes = LdifUtils.utf8encode((String)password);
        try {
            digest = MessageDigest.getInstance(hashMethod);
        }
        catch (NoSuchAlgorithmException e1) {
            return null;
        }
        if (salt != null) {
            digest.update(passwordBytes);
            digest.update(salt);
            byte[] hashedPasswordBytes = digest.digest();
            return hashedPasswordBytes;
        }
        byte[] hashedPasswordBytes = digest.digest(passwordBytes);
        return hashedPasswordBytes;
    }

    private static byte[] crypt(String password, byte[] salt) {
        String saltWithCrypted = UnixCrypt.crypt(password, LdifUtils.utf8decode((byte[])salt));
        String crypted = saltWithCrypted.substring(2);
        return LdifUtils.utf8encode((String)crypted);
    }
}

