/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioBulkRunnableWithProgress;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.AttributesInitializedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeChildrenRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.impl.BaseDNEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DirectoryMetadataEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Search;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializeRootDSERunnable
implements StudioBulkRunnableWithProgress {
    public static final String[] ROOT_DSE_ATTRIBUTES = new String[]{"namingContexts", "subschemaSubentry", "supportedLDAPVersion", "supportedSASLMechanisms", "supportedExtension", "supportedControl", "supportedFeatures", "vendorName", "vendorVersion", "+"};
    private IRootDSE rootDSE;

    private InitializeRootDSERunnable(IRootDSE rootDSE) {
        this.rootDSE = rootDSE;
    }

    public Connection[] getConnections() {
        return new Connection[]{this.rootDSE.getBrowserConnection().getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__init_entries_title_attonly;
    }

    public Object[] getLockedObjects() {
        return new IEntry[]{this.rootDSE};
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__init_entries_error_1;
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(" ", 3);
        monitor.reportProgress(" ");
        monitor.setTaskName(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__init_entries_task, (Object[])new String[]{this.rootDSE.getDn().getUpName()}));
        monitor.worked(1);
        monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__init_entries_progress_att, (Object[])new String[]{this.rootDSE.getDn().getUpName()}));
        InitializeRootDSERunnable.loadRootDSE(this.rootDSE.getBrowserConnection(), monitor);
    }

    public void runNotification(StudioProgressMonitor monitor) {
        EventRegistry.fireEntryUpdated(new AttributesInitializedEvent(this.rootDSE), this);
    }

    public static synchronized void loadRootDSE(IBrowserConnection browserConnection, StudioProgressMonitor monitor) {
        IEntry[] schemaEntries;
        InitializeChildrenRunnable.clearCaches(browserConnection.getRootDSE(), true);
        IAttribute[] oldAttributes = browserConnection.getRootDSE().getAttributes();
        if (oldAttributes != null) {
            for (IAttribute oldAttribute : oldAttributes) {
                browserConnection.getRootDSE().deleteAttribute(oldAttribute);
            }
        }
        Search search = new Search(null, browserConnection, LdapDN.EMPTY_LDAPDN, "(objectClass=*)", ROOT_DSE_ATTRIBUTES, ISearch.SearchScope.OBJECT, 0, 0, Connection.AliasDereferencingMethod.NEVER, Connection.ReferralHandlingMethod.IGNORE, false, null);
        SearchRunnable.searchAndUpdateModel(browserConnection, search, monitor);
        search = new Search(null, browserConnection, LdapDN.EMPTY_LDAPDN, "(objectClass=*)", new String[]{"*"}, ISearch.SearchScope.OBJECT, 0, 0, Connection.AliasDereferencingMethod.NEVER, Connection.ReferralHandlingMethod.IGNORE, false, null);
        SearchRunnable.searchAndUpdateModel(browserConnection, search, monitor);
        HashMap<LdapDN, IEntry> rootDseEntries = new HashMap<LdapDN, IEntry>();
        if (!browserConnection.isFetchBaseDNs() && browserConnection.getBaseDN() != null && !"".equals(browserConnection.getBaseDN().toString())) {
            LdapDN dn = browserConnection.getBaseDN();
            IEntry entry = browserConnection.getEntryFromCache(dn);
            if (entry == null) {
                entry = new BaseDNEntry((LdapDN)dn.clone(), browserConnection);
                browserConnection.cacheEntry(entry);
            }
            rootDseEntries.put(dn, entry);
        } else {
            HashSet<String> namingContextSet = new HashSet<String>();
            IAttribute attribute = browserConnection.getRootDSE().getAttribute("namingContexts");
            if (attribute != null) {
                String[] values = attribute.getStringValues();
                for (int i = 0; i < values.length; ++i) {
                    namingContextSet.add(values[i]);
                }
            }
            if (!namingContextSet.isEmpty()) {
                for (String namingContext : namingContextSet) {
                    if (namingContext.length() > 0 && namingContext.charAt(namingContext.length() - 1) == '\u0000') {
                        namingContext = namingContext.substring(0, namingContext.length() - 1);
                    }
                    if (!"".equals(namingContext)) {
                        try {
                            LdapDN dn = new LdapDN(namingContext);
                            IEntry entry = browserConnection.getEntryFromCache(dn);
                            if (entry == null) {
                                entry = new BaseDNEntry(dn, browserConnection);
                                browserConnection.cacheEntry(entry);
                            }
                            rootDseEntries.put(dn, entry);
                        }
                        catch (InvalidNameException e) {
                            monitor.reportError(BrowserCoreMessages.model__error_setting_base_dn, (Exception)e);
                        }
                        continue;
                    }
                    InitializeRootDSERunnable.searchRootDseEntries(browserConnection, rootDseEntries, monitor);
                }
            } else {
                InitializeRootDSERunnable.searchRootDseEntries(browserConnection, rootDseEntries, monitor);
            }
        }
        for (IEntry entry : schemaEntries = InitializeRootDSERunnable.getDirectoryMetadataEntries(browserConnection, "subschemaSubentry")) {
            if (entry instanceof DirectoryMetadataEntry) {
                ((DirectoryMetadataEntry)entry).setSchemaEntry(true);
            }
            rootDseEntries.put(entry.getDn(), entry);
        }
        IAttribute[] rootDseAttributes = browserConnection.getRootDSE().getAttributes();
        if (rootDseAttributes != null) {
            for (IAttribute attribute : rootDseAttributes) {
                IEntry[] metadataEntries;
                for (IEntry entry : metadataEntries = InitializeRootDSERunnable.getDirectoryMetadataEntries(browserConnection, attribute.getDescription())) {
                    rootDseEntries.put(entry.getDn(), entry);
                }
            }
        }
        StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
        for (IEntry entry : rootDseEntries.values()) {
            InitializeRootDSERunnable.initBaseEntry(entry, dummyMonitor);
        }
        browserConnection.getRootDSE().setHasMoreChildren(false);
        browserConnection.getRootDSE().setAttributesInitialized(true);
        browserConnection.getRootDSE().setInitOperationalAttributes(true);
        browserConnection.getRootDSE().setChildrenInitialized(true);
        browserConnection.getRootDSE().setHasChildrenHint(true);
        browserConnection.getRootDSE().setDirectoryEntry(true);
    }

    private static void initBaseEntry(IEntry entry, StudioProgressMonitor monitor) {
        IBrowserConnection browserConnection = entry.getBrowserConnection();
        LdapDN dn = entry.getDn();
        Connection.AliasDereferencingMethod derefAliasMethod = browserConnection.getAliasesDereferencingMethod();
        Connection.ReferralHandlingMethod handleReferralsMethod = browserConnection.getReferralsHandlingMethod();
        Search search = new Search(null, browserConnection, dn, "(objectClass=*)", ISearch.NO_ATTRIBUTES, ISearch.SearchScope.OBJECT, 1, 0, derefAliasMethod, handleReferralsMethod, true, null);
        SearchRunnable.searchAndUpdateModel(browserConnection, search, monitor);
        ISearchResult[] results = search.getSearchResults();
        if (results != null && results.length == 1) {
            ISearchResult result = results[0];
            entry = result.getEntry();
            browserConnection.getRootDSE().addChild(entry);
        } else {
            browserConnection.uncacheEntryRecursive(entry);
        }
    }

    private static IEntry[] getDirectoryMetadataEntries(IBrowserConnection browserConnection, String metadataAttributeName) {
        ArrayList<LdapDN> metadataEntryDnList = new ArrayList<LdapDN>();
        IAttribute attribute = browserConnection.getRootDSE().getAttribute(metadataAttributeName);
        if (attribute != null) {
            String[] values;
            for (String dn : values = attribute.getStringValues()) {
                if (dn == null || "".equals(dn)) continue;
                try {
                    metadataEntryDnList.add(new LdapDN(dn));
                }
                catch (InvalidNameException e) {
                    // empty catch block
                }
            }
        }
        IEntry[] metadataEntries = new IEntry[metadataEntryDnList.size()];
        for (int i = 0; i < metadataEntryDnList.size(); ++i) {
            LdapDN dn = (LdapDN)metadataEntryDnList.get(i);
            metadataEntries[i] = browserConnection.getEntryFromCache(dn);
            if (metadataEntries[i] != null) continue;
            metadataEntries[i] = new DirectoryMetadataEntry(dn, browserConnection);
            metadataEntries[i].setDirectoryEntry(true);
            browserConnection.cacheEntry(metadataEntries[i]);
        }
        return metadataEntries;
    }

    private static void searchRootDseEntries(IBrowserConnection browserConnection, Map<LdapDN, IEntry> rootDseEntries, StudioProgressMonitor monitor) {
        ISearchResult[] results;
        Search search = new Search(null, browserConnection, LdapDN.EMPTY_LDAPDN, "(objectClass=*)", ISearch.NO_ATTRIBUTES, ISearch.SearchScope.ONELEVEL, 0, 0, Connection.AliasDereferencingMethod.NEVER, Connection.ReferralHandlingMethod.IGNORE, false, null);
        SearchRunnable.searchAndUpdateModel(browserConnection, search, monitor);
        for (ISearchResult searchResult : results = search.getSearchResults()) {
            IEntry entry = searchResult.getEntry();
            rootDseEntries.put(entry.getDn(), entry);
        }
    }
}

