/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import com.sun.jndi.ldap.BasicControl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.Control;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.directory.shared.dsmlv2.DsmlDecorator;
import org.apache.directory.shared.dsmlv2.Dsmlv2Parser;
import org.apache.directory.shared.dsmlv2.reponse.AddResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.AuthResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.BatchResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.CompareResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.DelResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.ExtendedResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.ModDNResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.ModifyResponseDsml;
import org.apache.directory.shared.dsmlv2.request.BatchRequest;
import org.apache.directory.shared.ldap.codec.ControlCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapResultCodec;
import org.apache.directory.shared.ldap.codec.add.AddRequestCodec;
import org.apache.directory.shared.ldap.codec.bind.BindRequestCodec;
import org.apache.directory.shared.ldap.codec.compare.CompareRequestCodec;
import org.apache.directory.shared.ldap.codec.del.DelRequestCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedRequestCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequestCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequestCodec;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.DnUtils;
import org.apache.directory.studio.connection.core.io.jndi.StudioNamingEnumeration;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.BulkModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.AbstractNotificationJob;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExportDsmlJob;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.eclipse.core.runtime.IProgressMonitor;

public class ImportDsmlJob
extends AbstractNotificationJob {
    private IBrowserConnection browserConnection;
    private File dsmlFile;
    private File responseFile;

    public ImportDsmlJob(IBrowserConnection connection, File dsmlFile, File saveFile) {
        this.browserConnection = connection;
        this.dsmlFile = dsmlFile;
        this.responseFile = saveFile;
        this.setName(BrowserCoreMessages.jobs__import_dsml_name);
    }

    public ImportDsmlJob(IBrowserConnection connection, File dsmlFile) {
        this(connection, dsmlFile, null);
    }

    protected Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    protected Object[] getLockedObjects() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.browserConnection.getUrl() + "_" + DigestUtils.shaHex((String)this.dsmlFile.toString()));
        return l.toArray();
    }

    protected void executeNotificationJob(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.jobs__import_dsml_task, 2);
        monitor.reportProgress(" ");
        monitor.worked(1);
        try {
            Dsmlv2Parser parser = new Dsmlv2Parser();
            parser.setInput((InputStream)new FileInputStream(this.dsmlFile), "UTF-8");
            parser.parseAllRequests();
            BatchRequest batchRequest = parser.getBatchRequest();
            BatchResponseDsml batchResponseDsml = null;
            if (this.responseFile != null) {
                batchResponseDsml = new BatchResponseDsml();
            }
            int errorsCount = 0;
            StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
            List requests = batchRequest.getRequests();
            for (Object request : requests) {
                this.processRequest(request, batchResponseDsml, dummyMonitor);
                if (dummyMonitor.errorsReported()) {
                    ++errorsCount;
                }
                dummyMonitor.reset();
            }
            if (this.responseFile != null) {
                FileOutputStream fos = new FileOutputStream(this.responseFile);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                BufferedWriter bufferedWriter = new BufferedWriter(osw);
                bufferedWriter.write(batchResponseDsml.toDsml());
                bufferedWriter.close();
                osw.close();
                fos.close();
            }
            if (errorsCount > 0) {
                monitor.reportError(BrowserCoreMessages.bind((String)"{0} errors occurred, see the response file for details", (Object[])new String[]{"" + errorsCount}));
            }
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }

    private void processRequest(Object request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) throws NamingException, LdapURLEncodingException {
        if (request instanceof BindRequestCodec) {
            this.processBindRequest((BindRequestCodec)request, batchResponseDsml, monitor);
        } else if (request instanceof AddRequestCodec) {
            this.processAddRequest((AddRequestCodec)request, batchResponseDsml, monitor);
        } else if (request instanceof CompareRequestCodec) {
            this.processCompareRequest((CompareRequestCodec)request, batchResponseDsml, monitor);
        } else if (request instanceof DelRequestCodec) {
            this.processDelRequest((DelRequestCodec)request, batchResponseDsml, monitor);
        } else if (request instanceof ExtendedRequestCodec) {
            this.processExtendedRequest((ExtendedRequestCodec)request, batchResponseDsml, monitor);
        } else if (request instanceof ModifyRequestCodec) {
            this.processModifyRequest((ModifyRequestCodec)request, batchResponseDsml, monitor);
        } else if (request instanceof ModifyDNRequestCodec) {
            this.processModifyDNRequest((ModifyDNRequestCodec)request, batchResponseDsml, monitor);
        } else if (request instanceof SearchRequestCodec) {
            this.processSearchRequest((SearchRequestCodec)request, batchResponseDsml, monitor);
        }
    }

    private void processBindRequest(BindRequestCodec request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) {
        if (batchResponseDsml != null) {
            AuthResponseDsml authResponseDsml = new AuthResponseDsml();
            LdapResultCodec ldapResult = new LdapResultCodec();
            ldapResult.setResultCode(ResultCodeEnum.UNWILLING_TO_PERFORM);
            ldapResult.setErrorMessage("This kind of request is not yet supported.");
            authResponseDsml.setLdapResult(ldapResult);
            batchResponseDsml.addResponse((DsmlDecorator)authResponseDsml);
        }
    }

    private void processAddRequest(AddRequestCodec request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) {
        IEntry parentEntry;
        Entry entry = request.getEntry();
        this.browserConnection.getConnection().getJNDIConnectionWrapper().createEntry(entry.getDn().getUpName(), AttributeUtils.toAttributes((Entry)entry), this.getControls((LdapMessageCodec)request), monitor, null);
        if (batchResponseDsml != null) {
            AddResponseDsml addResponseDsml = new AddResponseDsml();
            addResponseDsml.setLdapResult(this.getLdapResult(monitor, MessageTypeEnum.ADD_REQUEST));
            addResponseDsml.getLdapResult().setMatchedDN(entry.getDn());
            batchResponseDsml.addResponse((DsmlDecorator)addResponseDsml);
        }
        LdapDN dn = entry.getDn();
        IEntry e = this.browserConnection.getEntryFromCache(dn);
        LdapDN parentDn = DnUtils.getParent((LdapDN)dn);
        IEntry iEntry = parentEntry = parentDn != null ? this.browserConnection.getEntryFromCache(parentDn) : null;
        if (e != null) {
            e.setAttributesInitialized(false);
        }
        if (parentEntry != null) {
            parentEntry.setChildrenInitialized(false);
        }
    }

    private void processCompareRequest(CompareRequestCodec request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) {
        if (batchResponseDsml != null) {
            CompareResponseDsml compareResponseDsml = new CompareResponseDsml();
            LdapResultCodec ldapResult = new LdapResultCodec();
            ldapResult.setResultCode(ResultCodeEnum.UNWILLING_TO_PERFORM);
            ldapResult.setErrorMessage("This kind of request is not yet supported.");
            compareResponseDsml.setLdapResult(ldapResult);
            batchResponseDsml.addResponse((DsmlDecorator)compareResponseDsml);
        }
    }

    private void processDelRequest(DelRequestCodec request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) {
        IEntry parentEntry;
        this.browserConnection.getConnection().getJNDIConnectionWrapper().deleteEntry(request.getEntry().getUpName(), this.getControls((LdapMessageCodec)request), monitor, null);
        if (batchResponseDsml != null) {
            DelResponseDsml delResponseDsml = new DelResponseDsml();
            delResponseDsml.setLdapResult(this.getLdapResult(monitor, MessageTypeEnum.DEL_REQUEST));
            delResponseDsml.getLdapResult().setMatchedDN(request.getEntry());
            batchResponseDsml.addResponse((DsmlDecorator)delResponseDsml);
        }
        LdapDN dn = request.getEntry();
        IEntry e = this.browserConnection.getEntryFromCache(dn);
        LdapDN parentDn = DnUtils.getParent((LdapDN)dn);
        IEntry iEntry = parentEntry = parentDn != null ? this.browserConnection.getEntryFromCache(parentDn) : null;
        if (e != null) {
            e.setAttributesInitialized(false);
            this.browserConnection.uncacheEntryRecursive(e);
        }
        if (parentEntry != null) {
            parentEntry.setChildrenInitialized(false);
        }
    }

    private void processExtendedRequest(ExtendedRequestCodec request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) {
        if (batchResponseDsml != null) {
            ExtendedResponseDsml extendedResponseDsml = new ExtendedResponseDsml();
            LdapResultCodec ldapResult = new LdapResultCodec();
            ldapResult.setResultCode(ResultCodeEnum.UNWILLING_TO_PERFORM);
            ldapResult.setErrorMessage("This kind of request is not yet supported.");
            extendedResponseDsml.setLdapResult(ldapResult);
            batchResponseDsml.addResponse((DsmlDecorator)extendedResponseDsml);
        }
    }

    private void processModifyRequest(ModifyRequestCodec request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) {
        LdapDN dn;
        IEntry e;
        ArrayList<ModificationItem> modificationItems = new ArrayList<ModificationItem>();
        for (Modification modification : request.getModifications()) {
            modificationItems.add(new ModificationItem(this.convertModificationOperation(modification.getOperation()), AttributeUtils.toAttribute((EntryAttribute)modification.getAttribute())));
        }
        this.browserConnection.getConnection().getJNDIConnectionWrapper().modifyEntry(request.getObject().getUpName(), modificationItems.toArray(new ModificationItem[0]), this.getControls((LdapMessageCodec)request), monitor, null);
        if (batchResponseDsml != null) {
            ModifyResponseDsml modifyResponseDsml = new ModifyResponseDsml();
            modifyResponseDsml.setLdapResult(this.getLdapResult(monitor, MessageTypeEnum.MODIFY_REQUEST));
            modifyResponseDsml.getLdapResult().setMatchedDN(request.getObject());
            batchResponseDsml.addResponse((DsmlDecorator)modifyResponseDsml);
        }
        if ((e = this.browserConnection.getEntryFromCache(dn = request.getObject())) != null) {
            e.setAttributesInitialized(false);
        }
    }

    private int convertModificationOperation(ModificationOperation operation) {
        switch (operation) {
            case ADD_ATTRIBUTE: {
                return 1;
            }
            case REMOVE_ATTRIBUTE: {
                return 3;
            }
            case REPLACE_ATTRIBUTE: {
                return 2;
            }
        }
        return 0;
    }

    private void processModifyDNRequest(ModifyDNRequestCodec request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) {
        LdapDN newSuperiorDn;
        IEntry newSuperiorEntry;
        IEntry parentEntry;
        this.browserConnection.getConnection().getJNDIConnectionWrapper().renameEntry(request.getEntry().getUpName(), request.getNewRDN().getUpName(), request.isDeleteOldRDN(), this.getControls((LdapMessageCodec)request), monitor, null);
        if (batchResponseDsml != null) {
            ModDNResponseDsml modDNResponseDsml = new ModDNResponseDsml();
            modDNResponseDsml.setLdapResult(this.getLdapResult(monitor, MessageTypeEnum.MOD_DN_REQUEST));
            modDNResponseDsml.getLdapResult().setMatchedDN(request.getEntry());
            batchResponseDsml.addResponse((DsmlDecorator)modDNResponseDsml);
        }
        LdapDN dn = request.getEntry();
        IEntry e = this.browserConnection.getEntryFromCache(dn);
        LdapDN parentDn = DnUtils.getParent((LdapDN)dn);
        IEntry iEntry = parentEntry = parentDn != null ? this.browserConnection.getEntryFromCache(parentDn) : null;
        if (e != null) {
            e.setAttributesInitialized(false);
            this.browserConnection.uncacheEntryRecursive(e);
        }
        if (parentEntry != null) {
            parentEntry.setChildrenInitialized(false);
        }
        if (request.getNewSuperior() != null && (newSuperiorEntry = this.browserConnection.getEntryFromCache(newSuperiorDn = request.getNewSuperior())) != null) {
            newSuperiorEntry.setChildrenInitialized(false);
        }
    }

    private void processSearchRequest(SearchRequestCodec request, BatchResponseDsml batchResponseDsml, StudioProgressMonitor monitor) throws NamingException, LdapURLEncodingException {
        if (batchResponseDsml != null) {
            StudioNamingEnumeration ne = this.browserConnection.getConnection().getJNDIConnectionWrapper().search(request.getBaseObject().getUpName(), request.getFilter().toString(), this.getSearchControls(request), this.getAliasDereferencingMethod(request), Connection.ReferralHandlingMethod.IGNORE, this.getControls((LdapMessageCodec)request), monitor, null);
            SearchParameter sp = new SearchParameter();
            sp.setReferralsHandlingMethod(this.browserConnection.getReferralsHandlingMethod());
            ExportDsmlJob.processAsDsmlResponse(ne, batchResponseDsml, monitor, sp);
        }
    }

    private SearchControls getSearchControls(SearchRequestCodec request) {
        SearchControls controls = new SearchControls();
        switch (request.getScope()) {
            case OBJECT: {
                controls.setSearchScope(0);
                break;
            }
            case ONELEVEL: {
                controls.setSearchScope(1);
                break;
            }
            case SUBTREE: {
                controls.setSearchScope(2);
                break;
            }
            default: {
                controls.setSearchScope(1);
            }
        }
        ArrayList<String> returningAttributes = new ArrayList<String>();
        for (EntryAttribute entryAttribute : request.getAttributes()) {
            returningAttributes.add(entryAttribute.getId());
        }
        if (returningAttributes.size() == 0) {
            returningAttributes.add("*");
        }
        controls.setReturningAttributes(returningAttributes.toArray(new String[0]));
        controls.setCountLimit(request.getSizeLimit());
        controls.setTimeLimit(request.getTimeLimit());
        return controls;
    }

    private Connection.AliasDereferencingMethod getAliasDereferencingMethod(SearchRequestCodec request) {
        switch (request.getDerefAliases()) {
            case 0: {
                return Connection.AliasDereferencingMethod.NEVER;
            }
            case 3: {
                return Connection.AliasDereferencingMethod.ALWAYS;
            }
            case 2: {
                return Connection.AliasDereferencingMethod.FINDING;
            }
            case 1: {
                return Connection.AliasDereferencingMethod.SEARCH;
            }
        }
        return Connection.AliasDereferencingMethod.NEVER;
    }

    private Control[] getControls(LdapMessageCodec request) {
        List controls = request.getControls();
        if (controls != null) {
            ArrayList<BasicControl> jndiControls = new ArrayList<BasicControl>();
            for (ControlCodec control : controls) {
                BasicControl jndiControl = new BasicControl(control.getControlType(), control.getCriticality(), control.getEncodedValue());
                jndiControls.add(jndiControl);
            }
            return jndiControls.toArray(new Control[jndiControls.size()]);
        }
        return null;
    }

    private LdapResultCodec getLdapResult(StudioProgressMonitor monitor, MessageTypeEnum messageType) {
        LdapResultCodec ldapResult = new LdapResultCodec();
        if (!monitor.errorsReported()) {
            ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
        } else {
            Exception t = monitor.getException();
            ldapResult.setResultCode(ResultCodeEnum.getBestEstimate((Throwable)t, (MessageTypeEnum)messageType));
            if (t.getMessage() != null) {
                ldapResult.setErrorMessage(t.getMessage());
            }
        }
        return ldapResult;
    }

    protected String getErrorMessage() {
        return BrowserCoreMessages.jobs__import_dsml_error;
    }

    protected void runNotification() {
        EventRegistry.fireEntryUpdated(new BulkModificationEvent(this.browserConnection), (Object)this);
    }
}

