/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioBulkRunnableWithProgress;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeRootDSERunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.impl.DirectoryMetadataEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchBaseDNsRunnable
implements StudioBulkRunnableWithProgress {
    private IBrowserConnection connection;
    private List<String> baseDNs;

    public FetchBaseDNsRunnable(IBrowserConnection connection) {
        this.connection = connection;
        this.baseDNs = new ArrayList<String>();
    }

    public Connection[] getConnections() {
        return null;
    }

    public String getName() {
        return BrowserCoreMessages.jobs__fetch_basedns_name;
    }

    public Object[] getLockedObjects() {
        return new Connection[]{this.connection.getConnection()};
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.jobs__fetch_basedns_task, 5);
        monitor.reportProgress(" ");
        monitor.worked(1);
        InitializeRootDSERunnable.loadRootDSE(this.connection, monitor);
        IEntry[] baseDNEntries = this.connection.getRootDSE().getChildren();
        if (baseDNEntries != null) {
            for (IEntry baseDNEntry : baseDNEntries) {
                if (baseDNEntry instanceof DirectoryMetadataEntry) continue;
                this.baseDNs.add(baseDNEntry.getDn().getUpName());
            }
        }
        monitor.worked(1);
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__fetch_basedns_error;
    }

    public List<String> getBaseDNs() {
        return this.baseDNs;
    }

    public void runNotification(StudioProgressMonitor monitor) {
    }
}

