/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.jobs.AbstractEclipseJob;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExportCsvJob;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExportLdifJob;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.apache.directory.studio.ldapbrowser.core.utils.JNDIUtils;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.eclipse.core.runtime.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportXlsJob
extends AbstractEclipseJob {
    public static final int MAX_COUNT_LIMIT = 65000;
    private String exportXlsFilename;
    private IBrowserConnection browserConnection;
    private SearchParameter searchParameter;
    private boolean exportDn;

    public ExportXlsJob(String exportLdifFilename, IBrowserConnection browserConnection, SearchParameter searchParameter, boolean exportDn) {
        this.exportXlsFilename = exportLdifFilename;
        this.browserConnection = browserConnection;
        this.searchParameter = searchParameter;
        this.exportDn = exportDn;
        this.setName(BrowserCoreMessages.jobs__export_xls_name);
    }

    @Override
    protected Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    @Override
    protected Object[] getLockedObjects() {
        return new Object[]{this.browserConnection.getUrl() + "_" + DigestUtils.shaHex((String)this.exportXlsFilename)};
    }

    @Override
    protected void executeAsyncJob(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.jobs__export_xls_task, 2);
        monitor.reportProgress(" ");
        monitor.worked(1);
        Preferences coreStore = BrowserCorePlugin.getDefault().getPluginPreferences();
        String valueDelimiter = coreStore.getString("formatXlsValueDelimiter");
        int binaryEncoding = coreStore.getInt("formatXlsBinaryEncoding");
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("Export");
        HSSFRow headerRow = sheet.createRow(0);
        LinkedHashMap<String, Short> attributeNameMap = new LinkedHashMap<String, Short>();
        if (this.exportDn) {
            short cellNum = 0;
            attributeNameMap.put("dn", new Short(cellNum));
            headerRow.createCell(cellNum).setCellValue("dn");
        }
        if (this.searchParameter.getCountLimit() < 1 || this.searchParameter.getCountLimit() > 65000) {
            this.searchParameter.setCountLimit(65000);
        }
        try {
            int count = 0;
            ExportXlsJob.exportToXls(this.browserConnection, this.searchParameter, sheet, headerRow, count, monitor, attributeNameMap, valueDelimiter, binaryEncoding, this.exportDn);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            HSSFRow row = sheet.getRow(i);
            for (short j = 0; row != null && j <= row.getLastCellNum(); j = (short)(j + 1)) {
                String value;
                HSSFCell cell = row.getCell(j);
                if (cell == null || cell.getCellType() != 1 || (short)((double)((value = cell.getStringCellValue()).length() * 256) * 1.1) <= sheet.getColumnWidth(j)) continue;
                sheet.setColumnWidth(j, (short)((double)(value.length() * 256) * 1.1));
            }
        }
        try {
            FileOutputStream fileOut = new FileOutputStream(this.exportXlsFilename);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }

    private static void exportToXls(IBrowserConnection browserConnection, SearchParameter searchParameter, HSSFSheet sheet, HSSFRow headerRow, int count, StudioProgressMonitor monitor, LinkedHashMap<String, Short> attributeNameMap, String valueDelimiter, int binaryEncoding, boolean exportDn) throws IOException {
        block3: {
            try {
                ExportLdifJob.JndiLdifEnumeration enumeration = ExportLdifJob.search(browserConnection, searchParameter, monitor);
                while (!monitor.isCanceled() && !monitor.errorsReported() && enumeration.hasNext()) {
                    LdifContainer container = enumeration.next();
                    if (!(container instanceof LdifContentRecord)) continue;
                    LdifContentRecord record = (LdifContentRecord)container;
                    ExportXlsJob.recordToHSSFRow(browserConnection, record, sheet, headerRow, attributeNameMap, valueDelimiter, binaryEncoding, exportDn);
                    monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__export_progress, (Object[])new String[]{Integer.toString(++count)}));
                }
            }
            catch (NamingException ne) {
                int ldapStatusCode = JNDIUtils.getLdapStatusCode(ne);
                if (ldapStatusCode == 3 || ldapStatusCode == 4 || ldapStatusCode == 11) break block3;
                monitor.reportError((Exception)ne);
            }
        }
    }

    private static void recordToHSSFRow(IBrowserConnection browserConnection, LdifContentRecord record, HSSFSheet sheet, HSSFRow headerRow, Map<String, Short> headerRowAttributeNameMap, String valueDelimiter, int binaryEncoding, boolean exportDn) {
        Map<String, String> attributeMap = ExportCsvJob.getAttributeMap(null, record, valueDelimiter, "UTF-16", binaryEncoding);
        HSSFRow row = sheet.createRow(sheet.getLastRowNum() + 1);
        if (exportDn) {
            HSSFCell cell = row.createCell((short)0);
            cell.setEncoding((short)1);
            cell.setCellValue(record.getDnLine().getValueAsString());
        }
        for (String attributeName : attributeMap.keySet()) {
            HSSFCell cell;
            short cellNum;
            String value = attributeMap.get(attributeName);
            if (!headerRowAttributeNameMap.containsKey(attributeName)) {
                cellNum = (short)headerRowAttributeNameMap.size();
                headerRowAttributeNameMap.put(attributeName, new Short(cellNum));
                cell = headerRow.createCell(cellNum);
                cell.setEncoding((short)1);
                cell.setCellValue(attributeName);
            }
            if (!headerRowAttributeNameMap.containsKey(attributeName)) continue;
            cellNum = headerRowAttributeNameMap.get(attributeName);
            cell = row.createCell(cellNum);
            cell.setEncoding((short)1);
            cell.setCellValue(value);
        }
    }

    @Override
    protected String getErrorMessage() {
        return BrowserCoreMessages.jobs__export_xls_error;
    }
}

