/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.jobs.AbstractEclipseJob;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExportCsvJob;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExportLdifJob;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.apache.directory.studio.ldapbrowser.core.utils.JNDIUtils;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.eclipse.core.runtime.Preferences;
import org.openoffice.odf.doc.OdfFileDom;
import org.openoffice.odf.doc.OdfSpreadsheetDocument;
import org.openoffice.odf.doc.element.table.OdfTable;
import org.openoffice.odf.doc.element.table.OdfTableCell;
import org.openoffice.odf.doc.element.table.OdfTableRow;
import org.openoffice.odf.dom.OdfNamespace;
import org.openoffice.odf.dom.type.office.OdfValueType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportOdfJob
extends AbstractEclipseJob {
    public static final int MAX_COUNT_LIMIT = 65000;
    private String exportOdfFilename;
    private IBrowserConnection browserConnection;
    private SearchParameter searchParameter;
    private boolean exportDn;

    public ExportOdfJob(String exportOdfFilename, IBrowserConnection browserConnection, SearchParameter searchParameter, boolean exportDn) {
        this.exportOdfFilename = exportOdfFilename;
        this.browserConnection = browserConnection;
        this.searchParameter = searchParameter;
        this.exportDn = exportDn;
        this.setName(BrowserCoreMessages.jobs__export_odf_name);
    }

    @Override
    protected Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    @Override
    protected Object[] getLockedObjects() {
        return new Object[]{this.browserConnection.getUrl() + "_" + DigestUtils.shaHex((String)this.exportOdfFilename)};
    }

    @Override
    protected void executeAsyncJob(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.jobs__export_odf_task, 2);
        monitor.reportProgress(" ");
        monitor.worked(1);
        Preferences coreStore = BrowserCorePlugin.getDefault().getPluginPreferences();
        String valueDelimiter = coreStore.getString("formatOdfValueDelimiter");
        int binaryEncoding = coreStore.getInt("formatOdfBinaryEncoding");
        try {
            OdfSpreadsheetDocument doc = OdfSpreadsheetDocument.createSpreadsheetDocument();
            OdfFileDom contentDoc = doc.getContentDom();
            Element spreadsheetElement = (Element)contentDoc.getElementsByTagNameNS(OdfNamespace.OFFICE.getUri(), "spreadsheet").item(0);
            OdfTable table = (OdfTable)spreadsheetElement.getElementsByTagNameNS(OdfNamespace.TABLE.getUri(), "table").item(0);
            table.getParentNode().removeChild((Node)table);
            table = new OdfTable(contentDoc);
            table.setName("Export");
            Element officeSpreadsheet = (Element)contentDoc.getElementsByTagNameNS(OdfNamespace.OFFICE.getUri(), "spreadsheet").item(0);
            officeSpreadsheet.appendChild((Node)table);
            OdfTableRow headerRow = new OdfTableRow(contentDoc);
            table.appendChild((Node)headerRow);
            LinkedHashMap<String, Short> attributeNameMap = new LinkedHashMap<String, Short>();
            if (this.exportDn) {
                boolean cellNum = false;
                OdfTableCell cell = new OdfTableCell(contentDoc);
                cell.setValueType(OdfValueType.STRING);
                cell.setStringValue("dn");
                headerRow.appendCell((Node)cell);
            }
            if (this.searchParameter.getCountLimit() < 1 || this.searchParameter.getCountLimit() > 65000) {
                this.searchParameter.setCountLimit(65000);
            }
            int count = 0;
            ExportOdfJob.exportToOdf(this.browserConnection, this.searchParameter, contentDoc, table, headerRow, count, monitor, attributeNameMap, valueDelimiter, binaryEncoding, this.exportDn);
            doc.save(this.exportOdfFilename);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }

    private static void exportToOdf(IBrowserConnection browserConnection, SearchParameter searchParameter, OdfFileDom contentDoc, OdfTable table, OdfTableRow headerRow, int count, StudioProgressMonitor monitor, LinkedHashMap<String, Short> attributeNameMap, String valueDelimiter, int binaryEncoding, boolean exportDn) throws IOException {
        block3: {
            try {
                ExportLdifJob.JndiLdifEnumeration enumeration = ExportLdifJob.search(browserConnection, searchParameter, monitor);
                while (!monitor.isCanceled() && !monitor.errorsReported() && enumeration.hasNext()) {
                    LdifContainer container = enumeration.next();
                    if (!(container instanceof LdifContentRecord)) continue;
                    LdifContentRecord record = (LdifContentRecord)container;
                    ExportOdfJob.recordToOdfRow(browserConnection, record, contentDoc, table, headerRow, attributeNameMap, valueDelimiter, binaryEncoding, exportDn);
                    monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__export_progress, (Object[])new String[]{Integer.toString(++count)}));
                }
            }
            catch (NamingException ne) {
                int ldapStatusCode = JNDIUtils.getLdapStatusCode(ne);
                if (ldapStatusCode == 3 || ldapStatusCode == 4 || ldapStatusCode == 11) break block3;
                monitor.reportError((Exception)ne);
            }
        }
    }

    private static void recordToOdfRow(IBrowserConnection browserConnection, LdifContentRecord record, OdfFileDom contentDoc, OdfTable table, OdfTableRow headerRow, Map<String, Short> headerRowAttributeNameMap, String valueDelimiter, int binaryEncoding, boolean exportDn) {
        OdfTableCell cell;
        Map<String, String> attributeMap = ExportCsvJob.getAttributeMap(null, record, valueDelimiter, "UTF-16", binaryEncoding);
        OdfTableRow row = new OdfTableRow(contentDoc);
        table.appendChild((Node)row);
        if (exportDn) {
            OdfTableCell cell2 = new OdfTableCell(contentDoc);
            cell2.setValueType(OdfValueType.STRING);
            cell2.setStringValue(record.getDnLine().getValueAsString());
            row.appendCell((Node)cell2);
        }
        for (String attributeName : attributeMap.keySet()) {
            if (headerRowAttributeNameMap.containsKey(attributeName)) continue;
            short cellNum = (short)headerRowAttributeNameMap.size();
            headerRowAttributeNameMap.put(attributeName, new Short(cellNum));
            cell = new OdfTableCell(contentDoc);
            cell.setValueType(OdfValueType.STRING);
            cell.setStringValue(attributeName);
            headerRow.appendCell((Node)cell);
        }
        for (String attributeName : headerRowAttributeNameMap.keySet()) {
            String value = attributeMap.get(attributeName);
            if (value == null) {
                value = "";
            }
            cell = new OdfTableCell(contentDoc);
            cell.setValueType(OdfValueType.STRING);
            cell.setStringValue(value);
            row.appendCell((Node)cell);
        }
    }

    @Override
    protected String getErrorMessage() {
        return BrowserCoreMessages.jobs__export_odf_error;
    }
}

