/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.SearchResult;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.directory.shared.dsmlv2.DsmlDecorator;
import org.apache.directory.shared.dsmlv2.reponse.BatchResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.SearchResponseDsml;
import org.apache.directory.shared.dsmlv2.reponse.SearchResultDoneDsml;
import org.apache.directory.shared.dsmlv2.reponse.SearchResultEntryDsml;
import org.apache.directory.shared.dsmlv2.reponse.SearchResultReferenceDsml;
import org.apache.directory.shared.dsmlv2.request.AddRequestDsml;
import org.apache.directory.shared.dsmlv2.request.BatchRequestDsml;
import org.apache.directory.shared.ldap.codec.LdapResultCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultDoneCodec;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.io.jndi.StudioNamingEnumeration;
import org.apache.directory.studio.connection.core.io.jndi.StudioSearchResult;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.jobs.AbstractEclipseJob;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.eclipse.core.runtime.IProgressMonitor;

public class ExportDsmlJob
extends AbstractEclipseJob {
    private static final String OBJECTCLASS_OBJECTCLASS_OID = "objectClass";
    private static final String OBJECTCLASS_OBJECTCLASS_NAME = "2.5.4.0";
    private static final String REFERRAL_OBJECTCLASS_OID = "2.16.840.1.113730.3.2.6";
    private static final String REFERRAL_OBJECTCLASS_NAME = "referral";
    private static final String REF_ATTRIBUTETYPE_OID = "2.16.840.1.113730.3.1.34";
    private static final String REF_ATTRIBUTETYPE_NAME = "ref";
    private String exportDsmlFilename;
    private IBrowserConnection browserConnection;
    private SearchParameter searchParameter;
    private ExportDsmlJobType type = ExportDsmlJobType.RESPONSE;

    public ExportDsmlJob(String exportDsmlFilename, IBrowserConnection connection, SearchParameter searchParameter, ExportDsmlJobType type) {
        this.exportDsmlFilename = exportDsmlFilename;
        this.browserConnection = connection;
        this.searchParameter = searchParameter;
        this.type = type;
        ArrayList<String> returningAttributes = new ArrayList<String>(Arrays.asList(searchParameter.getReturningAttributes()));
        returningAttributes.add(REF_ATTRIBUTETYPE_NAME);
        returningAttributes.add(REF_ATTRIBUTETYPE_OID);
        searchParameter.setReturningAttributes(returningAttributes.toArray(new String[0]));
        this.setName(BrowserCoreMessages.jobs__export_dsml_name);
    }

    protected Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    protected Object[] getLockedObjects() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.browserConnection.getUrl() + "_" + DigestUtils.shaHex((String)this.exportDsmlFilename));
        return l.toArray();
    }

    protected void executeAsyncJob(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.jobs__export_dsml_task, 4);
        monitor.reportProgress(" ");
        monitor.worked(1);
        try {
            StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
            StudioNamingEnumeration ne = SearchRunnable.search(this.browserConnection, this.searchParameter, dummyMonitor);
            monitor.worked(1);
            String dsmlExportString = null;
            switch (this.type) {
                case RESPONSE: {
                    dsmlExportString = this.processAsDsmlResponse(ne, dummyMonitor);
                    break;
                }
                case REQUEST: {
                    dsmlExportString = this.processAsDsmlRequest(ne, dummyMonitor);
                }
            }
            monitor.worked(1);
            if (dsmlExportString != null) {
                FileOutputStream fos = new FileOutputStream(this.exportDsmlFilename);
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                BufferedWriter bufferedWriter = new BufferedWriter(osw);
                bufferedWriter.write(dsmlExportString);
                bufferedWriter.close();
                osw.close();
                fos.close();
            }
            monitor.worked(1);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }

    private String processAsDsmlResponse(StudioNamingEnumeration ne, StudioProgressMonitor monitor) throws NamingException, LdapURLEncodingException {
        BatchResponseDsml batchResponse = new BatchResponseDsml();
        ExportDsmlJob.processAsDsmlResponse(ne, batchResponse, monitor, this.searchParameter);
        return batchResponse.toDsml();
    }

    public static void processAsDsmlResponse(StudioNamingEnumeration ne, BatchResponseDsml batchResponse, StudioProgressMonitor monitor, SearchParameter searchParameter) throws NamingException, LdapURLEncodingException {
        SearchResponseDsml sr = new SearchResponseDsml();
        batchResponse.addResponse((DsmlDecorator)sr);
        if (!monitor.errorsReported()) {
            while (ne.hasMore()) {
                StudioSearchResult searchResult = ne.next();
                sr.addResponse(ExportDsmlJob.convertSearchResultToDsml((SearchResult)searchResult, searchParameter));
            }
        }
        SearchResultDoneCodec srd = new SearchResultDoneCodec();
        LdapResultCodec ldapResult = new LdapResultCodec();
        if (!monitor.errorsReported()) {
            ldapResult.setResultCode(ResultCodeEnum.SUCCESS);
        } else {
            Exception t = monitor.getException();
            ldapResult.setResultCode(ResultCodeEnum.getBestEstimate((Throwable)t, (MessageTypeEnum)MessageTypeEnum.SEARCH_REQUEST));
            if (t.getMessage() != null) {
                ldapResult.setErrorMessage(t.getMessage());
            }
        }
        srd.setLdapResult(ldapResult);
        sr.addResponse((DsmlDecorator)new SearchResultDoneDsml(srd));
    }

    private static DsmlDecorator convertSearchResultToDsml(SearchResult searchResult, SearchParameter searchParameter) throws InvalidAttributeIdentifierException, InvalidNameException, LdapURLEncodingException {
        Entry entry = AttributeUtils.toClientEntry((Attributes)searchResult.getAttributes(), (LdapDN)new LdapDN(searchResult.getNameInNamespace()));
        if (ExportDsmlJob.isReferral(entry)) {
            SearchResultReferenceDsml srr = new SearchResultReferenceDsml();
            EntryAttribute refAttribute = entry.get(REF_ATTRIBUTETYPE_NAME);
            if (refAttribute == null) {
                refAttribute = entry.get(REF_ATTRIBUTETYPE_OID);
            }
            if (refAttribute != null) {
                for (Value value : refAttribute) {
                    srr.addSearchResultReference(new LdapURL((String)value.get()));
                }
            }
            return srr;
        }
        SearchResultEntryDsml sre = new SearchResultEntryDsml();
        sre.setEntry(entry);
        return sre;
    }

    private static boolean isReferral(Entry entry) {
        if (entry != null) {
            EntryAttribute objectClassAttribute = entry.get(OBJECTCLASS_OBJECTCLASS_NAME);
            if (objectClassAttribute == null) {
                objectClassAttribute = entry.get(OBJECTCLASS_OBJECTCLASS_OID);
            }
            if (objectClassAttribute != null) {
                return objectClassAttribute.contains(new String[]{REFERRAL_OBJECTCLASS_NAME}) || objectClassAttribute.contains(new String[]{REFERRAL_OBJECTCLASS_OID});
            }
        }
        return false;
    }

    private String processAsDsmlRequest(StudioNamingEnumeration ne, StudioProgressMonitor monitor) throws NamingException {
        BatchRequestDsml batchRequest = new BatchRequestDsml();
        if (!monitor.errorsReported()) {
            while (ne.hasMore()) {
                StudioSearchResult searchResult = ne.next();
                AddRequestDsml arDsml = this.convertToAddRequestDsml((SearchResult)searchResult);
                batchRequest.addRequest((DsmlDecorator)arDsml);
            }
        }
        return batchRequest.toDsml();
    }

    private AddRequestDsml convertToAddRequestDsml(SearchResult searchResult) throws InvalidAttributeIdentifierException, InvalidNameException {
        AddRequestDsml ar = new AddRequestDsml();
        Entry entry = AttributeUtils.toClientEntry((Attributes)searchResult.getAttributes(), (LdapDN)new LdapDN(searchResult.getNameInNamespace()));
        ar.setEntry(entry);
        return ar;
    }

    protected String getErrorMessage() {
        return BrowserCoreMessages.jobs__export_dsml_error;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExportDsmlJobType {
        RESPONSE,
        REQUEST;

    }
}

