/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.jobs.AbstractEclipseJob;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExportLdifJob;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeDescription;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.apache.directory.studio.ldapbrowser.core.utils.JNDIUtils;
import org.apache.directory.studio.ldifparser.LdifUtils;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContentRecord;
import org.apache.directory.studio.ldifparser.model.lines.LdifAttrValLine;
import org.eclipse.core.runtime.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportCsvJob
extends AbstractEclipseJob {
    private String exportCsvFilename;
    private IBrowserConnection browserConnection;
    private SearchParameter searchParameter;
    private boolean exportDn;

    public ExportCsvJob(String exportCsvFilename, IBrowserConnection browserConnection, SearchParameter searchParameter, boolean exportDn) {
        this.exportCsvFilename = exportCsvFilename;
        this.browserConnection = browserConnection;
        this.searchParameter = searchParameter;
        this.exportDn = exportDn;
        this.setName(BrowserCoreMessages.jobs__export_csv_name);
    }

    @Override
    protected Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    @Override
    protected Object[] getLockedObjects() {
        return new Object[]{this.browserConnection.getUrl() + "_" + DigestUtils.shaHex((String)this.exportCsvFilename)};
    }

    @Override
    protected void executeAsyncJob(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.jobs__export_csv_task, 2);
        monitor.reportProgress(" ");
        monitor.worked(1);
        Preferences coreStore = BrowserCorePlugin.getDefault().getPluginPreferences();
        String attributeDelimiter = coreStore.getString("formatCsvAttributeDelimiter");
        String valueDelimiter = coreStore.getString("formatCsvValueDelimiter");
        String quoteCharacter = coreStore.getString("formatCsvQuoteCharacter");
        String lineSeparator = coreStore.getString("formatCsvLineSeparator");
        String encoding = coreStore.getString("formatCsvEncoding");
        int binaryEncoding = coreStore.getInt("formatCsvBinaryEncoding");
        String[] exportAttributes = this.searchParameter.getReturningAttributes();
        try {
            FileOutputStream fos = new FileOutputStream(this.exportCsvFilename);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoding);
            BufferedWriter bufferedWriter = new BufferedWriter(osw);
            if (this.exportDn) {
                bufferedWriter.write("dn");
                if (exportAttributes == null || exportAttributes.length > 0) {
                    bufferedWriter.write(attributeDelimiter);
                }
            }
            for (int i = 0; i < exportAttributes.length; ++i) {
                bufferedWriter.write(exportAttributes[i]);
                if (i + 1 >= exportAttributes.length) continue;
                bufferedWriter.write(attributeDelimiter);
            }
            bufferedWriter.write(BrowserCoreConstants.LINE_SEPARATOR);
            int count = 0;
            ExportCsvJob.exportToCsv(this.browserConnection, this.searchParameter, bufferedWriter, count, monitor, exportAttributes, attributeDelimiter, valueDelimiter, quoteCharacter, lineSeparator, encoding, binaryEncoding, this.exportDn);
            bufferedWriter.close();
            osw.close();
            fos.close();
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }

    private static void exportToCsv(IBrowserConnection browserConnection, SearchParameter searchParameter, BufferedWriter bufferedWriter, int count, StudioProgressMonitor monitor, String[] attributes, String attributeDelimiter, String valueDelimiter, String quoteCharacter, String lineSeparator, String encoding, int binaryEncoding, boolean exportDn) throws IOException {
        block3: {
            try {
                ExportLdifJob.JndiLdifEnumeration enumeration = ExportLdifJob.search(browserConnection, searchParameter, monitor);
                while (!monitor.isCanceled() && !monitor.errorsReported() && enumeration.hasNext()) {
                    LdifContainer container = enumeration.next();
                    if (!(container instanceof LdifContentRecord)) continue;
                    LdifContentRecord record = (LdifContentRecord)container;
                    bufferedWriter.write(ExportCsvJob.recordToCsv(browserConnection, record, attributes, attributeDelimiter, valueDelimiter, quoteCharacter, lineSeparator, encoding, binaryEncoding, exportDn));
                    monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__export_progress, (Object[])new String[]{Integer.toString(++count)}));
                }
            }
            catch (NamingException ce) {
                int ldapStatusCode = JNDIUtils.getLdapStatusCode(ce);
                if (ldapStatusCode == 3 || ldapStatusCode == 4 || ldapStatusCode == 11) break block3;
                monitor.reportError((Exception)ce);
            }
        }
    }

    private static String recordToCsv(IBrowserConnection browserConnection, LdifContentRecord record, String[] attributes, String attributeDelimiter, String valueDelimiter, String quoteCharacter, String lineSeparator, String encoding, int binaryEncoding, boolean exportDn) {
        Map<String, String> attributeMap = ExportCsvJob.getAttributeMap(browserConnection, record, valueDelimiter, encoding, binaryEncoding);
        StringBuffer sb = new StringBuffer();
        if (exportDn) {
            sb.append(quoteCharacter);
            sb.append(record.getDnLine().getValueAsString());
            sb.append(quoteCharacter);
            if (attributes == null || attributes.length > 0) {
                sb.append(attributeDelimiter);
            }
        }
        for (int i = 0; i < attributes.length; ++i) {
            String attributeName = attributes[i];
            AttributeDescription ad = new AttributeDescription(attributeName);
            String oidString = ad.toOidString(browserConnection.getSchema());
            if (attributeMap.containsKey(oidString)) {
                String value = attributeMap.get(oidString);
                value = value.replaceAll(quoteCharacter, quoteCharacter + quoteCharacter);
                sb.append(quoteCharacter);
                sb.append(value);
                sb.append(quoteCharacter);
            }
            if (i + 1 >= attributes.length) continue;
            sb.append(attributeDelimiter);
        }
        sb.append(lineSeparator);
        return sb.toString();
    }

    static Map<String, String> getAttributeMap(IBrowserConnection browserConnection, LdifContentRecord record, String valueDelimiter, String encoding, int binaryEncoding) {
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        LdifAttrValLine[] lines = record.getAttrVals();
        for (int i = 0; i < lines.length; ++i) {
            String oldValue;
            String attributeName = lines[i].getUnfoldedAttributeDescription();
            if (browserConnection != null) {
                AttributeDescription ad = new AttributeDescription(attributeName);
                attributeName = ad.toOidString(browserConnection.getSchema());
            }
            String value = lines[i].getValueAsString();
            if (!Charset.forName(encoding).newEncoder().canEncode(value)) {
                value = binaryEncoding == 1 ? LdifUtils.base64encode((byte[])lines[i].getValueAsBinary()) : (binaryEncoding == 2 ? LdifUtils.hexEncode((byte[])lines[i].getValueAsBinary()) : "BINARY");
                if (attributeMap.containsKey(attributeName)) {
                    oldValue = (String)attributeMap.get(attributeName);
                    attributeMap.put(attributeName, oldValue + valueDelimiter + value);
                    continue;
                }
                attributeMap.put(attributeName, value);
                continue;
            }
            if (attributeMap.containsKey(attributeName)) {
                oldValue = (String)attributeMap.get(attributeName);
                attributeMap.put(attributeName, oldValue + valueDelimiter + value);
                continue;
            }
            attributeMap.put(attributeName, value);
        }
        return attributeMap;
    }

    @Override
    protected String getErrorMessage() {
        return BrowserCoreMessages.jobs__export_cvs_error;
    }
}

