/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.util.ArrayList;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.Control;
import javax.naming.ldap.ManageReferralControl;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.StudioControl;
import org.apache.directory.studio.connection.core.jobs.StudioBulkRunnableWithProgress;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.EntryAddedEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReadEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateEntryRunnable
implements StudioBulkRunnableWithProgress {
    private IEntry entryToCreate;
    private IBrowserConnection browserConnection;
    private IEntry createdEntry;

    public CreateEntryRunnable(IEntry entryToCreate, IBrowserConnection browserConnection) {
        this.entryToCreate = entryToCreate;
        this.browserConnection = browserConnection;
        this.createdEntry = null;
    }

    public Connection[] getConnections() {
        return new Connection[]{this.browserConnection.getConnection()};
    }

    public String getName() {
        return BrowserCoreMessages.jobs__create_entry_name_1;
    }

    public Object[] getLockedObjects() {
        return new Object[]{this.browserConnection};
    }

    public void run(StudioProgressMonitor monitor) {
        monitor.beginTask(BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__create_entry_task_1, (Object[])new String[]{this.entryToCreate.getDn().getUpName()}), 3);
        monitor.reportProgress(" ");
        monitor.worked(1);
        CreateEntryRunnable.createEntry(this.browserConnection, this.entryToCreate, monitor);
        if (!monitor.errorsReported() && !monitor.isCanceled()) {
            ArrayList<StudioControl> controls = new ArrayList<StudioControl>();
            if (this.entryToCreate.isReferral()) {
                controls.add(StudioControl.MANAGEDSAIT_CONTROL);
            }
            StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
            this.createdEntry = ReadEntryRunnable.getEntry(this.browserConnection, this.entryToCreate.getDn(), controls, dummyMonitor);
            dummyMonitor.done();
            if (this.createdEntry != null) {
                this.createdEntry.setHasChildrenHint(false);
                if (this.createdEntry.hasParententry()) {
                    if (this.createdEntry.isAlias()) {
                        this.createdEntry.getParententry().setFetchAliases(true);
                    }
                    if (this.createdEntry.isReferral()) {
                        this.createdEntry.getParententry().setFetchReferrals(true);
                    }
                    if (this.createdEntry.isSubentry()) {
                        this.createdEntry.getParententry().setFetchSubentries(true);
                    }
                }
            }
        }
        monitor.reportProgress(" ");
        monitor.worked(1);
    }

    public void runNotification(StudioProgressMonitor monitor) {
        if (this.createdEntry != null) {
            EventRegistry.fireEntryUpdated(new EntryAddedEvent(this.browserConnection, this.createdEntry), this);
        }
    }

    public String getErrorMessage() {
        return BrowserCoreMessages.jobs__create_entry_error_1;
    }

    static void createEntry(IBrowserConnection browserConnection, IEntry entryToCreate, StudioProgressMonitor monitor) {
        String dn = entryToCreate.getDn().getUpName();
        BasicAttributes jndiAttributes = new BasicAttributes();
        IAttribute[] attributes = entryToCreate.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            String description = attributes[i].getDescription();
            IValue[] values = attributes[i].getValues();
            for (int ii = 0; ii < values.length; ++ii) {
                IValue value = values[ii];
                Object rawValue = value.getRawValue();
                if (jndiAttributes.get(description) != null) {
                    jndiAttributes.get(description).add(rawValue);
                    continue;
                }
                jndiAttributes.put(description, rawValue);
            }
        }
        Control[] controls = null;
        if (entryToCreate.isReferral()) {
            controls = new Control[]{new ManageReferralControl(false)};
        }
        browserConnection.getConnection().getJNDIConnectionWrapper().createEntry(dn, (Attributes)jndiAttributes, controls, monitor, null);
    }
}

