/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.ManageReferralControl;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.DnUtils;
import org.apache.directory.studio.connection.core.io.jndi.StudioNamingEnumeration;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.events.BulkModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.AbstractNotificationJob;
import org.apache.directory.studio.ldapbrowser.core.jobs.EntryExistsCopyStrategyDialog;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.utils.JNDIUtils;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyEntriesJob
extends AbstractNotificationJob {
    private IEntry parent;
    private IEntry[] entriesToCopy;
    private ISearch.SearchScope scope;
    private EntryExistsCopyStrategyDialog dialog;

    public CopyEntriesJob(IEntry parent, IEntry[] entriesToCopy, ISearch.SearchScope scope, EntryExistsCopyStrategyDialog dialog) {
        this.parent = parent;
        this.entriesToCopy = entriesToCopy;
        this.scope = scope;
        this.dialog = dialog;
        this.setName(entriesToCopy.length == 1 ? BrowserCoreMessages.jobs__copy_entries_name_1 : BrowserCoreMessages.jobs__copy_entries_name_n);
    }

    @Override
    protected Connection[] getConnections() {
        return new Connection[]{this.parent.getBrowserConnection().getConnection()};
    }

    @Override
    protected Object[] getLockedObjects() {
        ArrayList<IEntry> l = new ArrayList<IEntry>();
        l.add(this.parent);
        l.addAll(Arrays.asList(this.entriesToCopy));
        return l.toArray();
    }

    @Override
    protected void executeNotificationJob(StudioProgressMonitor monitor) {
        monitor.beginTask(this.entriesToCopy.length == 1 ? BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__copy_entries_task_1, (Object[])new String[]{this.entriesToCopy[0].getDn().getUpName(), this.parent.getDn().getUpName()}) : BrowserCoreMessages.bind((String)BrowserCoreMessages.jobs__copy_entries_task_n, (Object[])new String[]{Integer.toString(this.entriesToCopy.length), this.parent.getDn().getUpName()}), 2 + this.entriesToCopy.length);
        monitor.reportProgress(" ");
        monitor.worked(1);
        if (this.scope == ISearch.SearchScope.OBJECT || this.scope == ISearch.SearchScope.ONELEVEL || this.scope == ISearch.SearchScope.SUBTREE) {
            StudioProgressMonitor dummyMonitor = new StudioProgressMonitor((IProgressMonitor)monitor);
            int copyScope = this.scope == ISearch.SearchScope.SUBTREE ? 2 : (this.scope == ISearch.SearchScope.ONELEVEL ? 1 : 0);
            int num = 0;
            for (int i = 0; !monitor.isCanceled() && i < this.entriesToCopy.length; ++i) {
                IEntry entryToCopy = this.entriesToCopy[i];
                if (this.scope == ISearch.SearchScope.OBJECT || !this.parent.getDn().getNormName().endsWith(entryToCopy.getDn().getNormName())) {
                    dummyMonitor.reset();
                    num = CopyEntriesJob.copyEntry(entryToCopy, this.parent, null, copyScope, num, this.dialog, dummyMonitor, monitor);
                    continue;
                }
                monitor.reportError(BrowserCoreMessages.jobs__copy_entries_source_and_target_are_equal);
            }
            this.parent.setChildrenInitialized(false);
            this.parent.setHasChildrenHint(true);
        }
    }

    @Override
    protected void runNotification() {
        EventRegistry.fireEntryUpdated(new BulkModificationEvent(this.parent.getBrowserConnection()), (Object)this);
    }

    @Override
    protected String getErrorMessage() {
        return this.entriesToCopy.length == 1 ? BrowserCoreMessages.jobs__copy_entries_error_1 : BrowserCoreMessages.jobs__copy_entries_error_n;
    }

    static int copyEntry(IEntry entryToCopy, IEntry parent, Rdn newRdn, int scope, int numberOfCopiedEntries, EntryExistsCopyStrategyDialog dialog, StudioProgressMonitor dummyMonitor, StudioProgressMonitor monitor) {
        SearchControls searchControls = new SearchControls();
        searchControls.setCountLimit(1L);
        searchControls.setReturningAttributes(new String[]{"*", "ref"});
        searchControls.setSearchScope(0);
        Control[] controls = null;
        if (entryToCopy.isReferral()) {
            controls = new Control[]{new ManageReferralControl(false)};
        }
        StudioNamingEnumeration result = entryToCopy.getBrowserConnection().getConnection().getJNDIConnectionWrapper().search(entryToCopy.getDn().getUpName(), "(objectClass=*)", searchControls, Connection.AliasDereferencingMethod.NEVER, Connection.ReferralHandlingMethod.IGNORE, controls, monitor, null);
        LdapDN parentDn = parent.getDn();
        if (parentDn.isEmpty()) {
            parentDn = DnUtils.getParent((LdapDN)entryToCopy.getDn());
        }
        numberOfCopiedEntries = CopyEntriesJob.copyEntryRecursive(entryToCopy.getBrowserConnection(), (NamingEnumeration<SearchResult>)result, parent.getBrowserConnection(), parentDn, newRdn, scope, numberOfCopiedEntries, dialog, dummyMonitor, monitor);
        return numberOfCopiedEntries;
    }

    static int copyEntryRecursive(IBrowserConnection sourceBrowserConnection, NamingEnumeration<SearchResult> entries, IBrowserConnection targetBrowserConnection, LdapDN parentDn, Rdn forceNewRdn, int scope, int numberOfCopiedEntries, EntryExistsCopyStrategyDialog dialog, StudioProgressMonitor dummyMonitor, StudioProgressMonitor monitor) {
        try {
            while (!monitor.isCanceled() && entries.hasMore()) {
                SearchResult sr = entries.next();
                LdapDN oldLdapDn = JNDIUtils.getDn(sr);
                Rdn oldRdn = oldLdapDn.getRdn();
                Attributes newAttributes = sr.getAttributes();
                Rdn newRdn = oldLdapDn.getRdn();
                if (forceNewRdn != null) {
                    newRdn = forceNewRdn;
                }
                LdapDN newLdapDn = DnUtils.composeDn((Rdn)newRdn, (LdapDN)parentDn);
                CopyEntriesJob.applyNewRdn(newAttributes, oldRdn, newRdn);
                Control[] controls = null;
                if (newAttributes.get("objectClass") != null && newAttributes.get("objectClass").contains("referral")) {
                    controls = new Control[]{new ManageReferralControl(false)};
                }
                targetBrowserConnection.getConnection().getJNDIConnectionWrapper().createEntry(newLdapDn.getUpName(), newAttributes, controls, dummyMonitor, null);
                while (dummyMonitor.errorsReported()) {
                    if (dialog != null && dummyMonitor.getException() instanceof NameAlreadyBoundException) {
                        dialog.setExistingEntry(targetBrowserConnection, newLdapDn);
                        dialog.open();
                        EntryExistsCopyStrategyDialog.EntryExistsCopyStrategy strategy = dialog.getStrategy();
                        if (strategy != null) {
                            dummyMonitor.reset();
                            switch (strategy) {
                                case BREAK: {
                                    monitor.setCanceled(true);
                                    break;
                                }
                                case IGNORE_AND_CONTINUE: {
                                    break;
                                }
                                case OVERWRITE_AND_CONTINUE: {
                                    ArrayList<ModificationItem> mis = new ArrayList<ModificationItem>();
                                    NamingEnumeration<? extends Attribute> all = newAttributes.getAll();
                                    while (all.hasMore()) {
                                        Attribute attribute = all.next();
                                        ModificationItem mi = new ModificationItem(2, attribute);
                                        mis.add(mi);
                                    }
                                    targetBrowserConnection.getConnection().getJNDIConnectionWrapper().modifyEntry(newLdapDn.getUpName(), mis.toArray(new ModificationItem[mis.size()]), null, dummyMonitor, null);
                                    IEntry newEntry = targetBrowserConnection.getEntryFromCache(newLdapDn);
                                    if (newEntry == null) break;
                                    newEntry.setAttributesInitialized(false);
                                    break;
                                }
                                case RENAME_AND_CONTINUE: {
                                    Rdn renamedRdn = dialog.getRdn();
                                    CopyEntriesJob.applyNewRdn(newAttributes, newRdn, renamedRdn);
                                    newLdapDn = DnUtils.composeDn((Rdn)renamedRdn, (LdapDN)parentDn);
                                    targetBrowserConnection.getConnection().getJNDIConnectionWrapper().createEntry(newLdapDn.getUpName(), newAttributes, null, dummyMonitor, null);
                                }
                            }
                            continue;
                        }
                        monitor.reportError(dummyMonitor.getException());
                        break;
                    }
                    monitor.reportError(dummyMonitor.getException());
                    break;
                }
                if (monitor.isCanceled() || monitor.errorsReported()) continue;
                monitor.reportProgress(BrowserCoreMessages.bind((String)BrowserCoreMessages.model__copied_n_entries, (Object[])new String[]{"" + ++numberOfCopiedEntries}));
                if (scope != 1 && scope != 2) continue;
                SearchControls searchControls = new SearchControls();
                searchControls.setCountLimit(0L);
                searchControls.setReturningAttributes(new String[]{"*", "ref"});
                searchControls.setSearchScope(1);
                StudioNamingEnumeration childEntries = sourceBrowserConnection.getConnection().getJNDIConnectionWrapper().search(oldLdapDn.getUpName(), "(objectClass=*)", searchControls, Connection.AliasDereferencingMethod.NEVER, Connection.ReferralHandlingMethod.IGNORE, null, monitor, null);
                if (scope == 1) {
                    scope = 0;
                }
                numberOfCopiedEntries = CopyEntriesJob.copyEntryRecursive(sourceBrowserConnection, (NamingEnumeration<SearchResult>)childEntries, targetBrowserConnection, newLdapDn, null, scope, numberOfCopiedEntries, dialog, dummyMonitor, monitor);
            }
        }
        catch (NamingException e) {
            monitor.reportError((Exception)e);
        }
        return numberOfCopiedEntries;
    }

    private static void applyNewRdn(Attributes attributes, Rdn oldRdn, Rdn newRdn) {
        Attribute attribute;
        for (AttributeTypeAndValue atav : oldRdn) {
            attribute = attributes.get(atav.getUpType());
            if (attribute == null) continue;
            attribute.remove(atav.getNormValue().getString());
            if (attribute.size() != 0) continue;
            attributes.remove(atav.getUpType());
        }
        for (AttributeTypeAndValue atav : newRdn) {
            attribute = attributes.get(atav.getUpType());
            if (attribute == null) {
                attribute = new BasicAttribute(atav.getUpType());
                attributes.put(attribute);
            }
            if (attribute.contains(atav.getNormValue().getString())) continue;
            attribute.add(atav.getNormValue().getString());
        }
    }
}

