/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.IConnectionListener;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.BrowserConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class AbstractEclipseJob
extends Job {
    private IProgressMonitor externalProgressMonitor;
    private IStatus externalResult;

    protected AbstractEclipseJob() {
        super("");
    }

    protected abstract Connection[] getConnections();

    protected abstract void executeAsyncJob(StudioProgressMonitor var1) throws Exception;

    protected String getErrorMessage() {
        return BrowserCoreMessages.jobs__error_occurred;
    }

    protected final IStatus run(IProgressMonitor ipm) {
        Connection[] connections;
        StudioProgressMonitor monitor = new StudioProgressMonitor(this.externalProgressMonitor == null ? ipm : this.externalProgressMonitor);
        for (Connection connection : connections = this.getConnections()) {
            if (connection == null || connection.getJNDIConnectionWrapper().isConnected()) continue;
            monitor.setTaskName(Messages.bind((String)Messages.jobs__open_connections_task, (Object[])new String[]{connection.getName()}));
            monitor.worked(1);
            connection.getJNDIConnectionWrapper().connect(monitor);
            connection.getJNDIConnectionWrapper().bind(monitor);
            for (IConnectionListener listener : ConnectionCorePlugin.getDefault().getConnectionListeners()) {
                listener.connectionOpened(connection, monitor);
            }
            ConnectionEventRegistry.fireConnectionOpened((Connection)connection, (Object)((Object)this));
        }
        if (!monitor.errorsReported()) {
            try {
                this.executeAsyncJob(monitor);
            }
            catch (Exception e) {
                monitor.reportError(e);
            }
        }
        monitor.done();
        ipm.done();
        if (monitor.isCanceled()) {
            this.externalResult = Status.CANCEL_STATUS;
            return Status.CANCEL_STATUS;
        }
        if (monitor.errorsReported()) {
            this.externalResult = monitor.getErrorStatus(this.getErrorMessage());
            if (this.externalProgressMonitor == null) {
                return this.externalResult;
            }
            return Status.OK_STATUS;
        }
        this.externalResult = Status.OK_STATUS;
        return Status.OK_STATUS;
    }

    public void setExternalProgressMonitor(IProgressMonitor externalProgressMonitor) {
        this.externalProgressMonitor = externalProgressMonitor;
    }

    public IStatus getExternalResult() {
        return this.externalResult;
    }

    public final void execute() {
        this.setUser(true);
        this.schedule();
    }

    protected abstract Object[] getLockedObjects();

    public boolean shouldSchedule() {
        Object[] myLockedObjects = this.getLockedObjects();
        String[] myLockedObjectsIdentifiers = AbstractEclipseJob.getLockIdentifiers(myLockedObjects);
        Job[] jobs = Platform.getJobManager().find(null);
        for (int i = 0; i < jobs.length; ++i) {
            Job job = jobs[i];
            if (job.getClass() != ((Object)((Object)this)).getClass() || job == this) continue;
            AbstractEclipseJob otherJob = (AbstractEclipseJob)job;
            Object[] otherLockedObjects = otherJob.getLockedObjects();
            String[] otherLockedObjectIdentifiers = AbstractEclipseJob.getLockIdentifiers(otherLockedObjects);
            for (int j = 0; j < otherLockedObjectIdentifiers.length; ++j) {
                String other = otherLockedObjectIdentifiers[j];
                for (int k = 0; k < myLockedObjectsIdentifiers.length; ++k) {
                    String my = myLockedObjectsIdentifiers[k];
                    if (!other.startsWith(my) && !my.startsWith(other)) continue;
                    return false;
                }
            }
        }
        return super.shouldSchedule();
    }

    protected static String[] getLockIdentifiers(Object[] objects) {
        String[] identifiers = new String[objects.length];
        for (int i = 0; i < identifiers.length; ++i) {
            Object o = objects[i];
            identifiers[i] = o instanceof IBrowserConnection ? AbstractEclipseJob.getLockIdentifier((IBrowserConnection)o) : (o instanceof IEntry ? AbstractEclipseJob.getLockIdentifier((IEntry)o) : (o instanceof IAttribute ? AbstractEclipseJob.getLockIdentifier((IAttribute)o) : (o instanceof IValue ? AbstractEclipseJob.getLockIdentifier((IValue)o) : (o instanceof ISearch ? AbstractEclipseJob.getLockIdentifier((ISearch)o) : AbstractEclipseJob.getLockIdentifier(objects[i])))));
        }
        return identifiers;
    }

    protected static String getLockIdentifier(IBrowserConnection browserConnection) {
        if (browserConnection instanceof BrowserConnection && browserConnection.getConnection() != null) {
            return browserConnection.getConnection().getHost() + ":" + browserConnection.getConnection().getPort();
        }
        return "";
    }

    protected static String getLockIdentifier(IEntry entry) {
        return AbstractEclipseJob.getLockIdentifier(entry.getBrowserConnection()) + "_" + new StringBuffer(entry.getDn().getNormName()).reverse().toString();
    }

    protected static String getLockIdentifier(IAttribute attribute) {
        return AbstractEclipseJob.getLockIdentifier(attribute.getEntry()) + "_" + attribute.getDescription();
    }

    protected static String getLockIdentifier(IValue value) {
        return AbstractEclipseJob.getLockIdentifier(value.getAttribute()) + "_" + value.getStringValue();
    }

    protected static String getLockIdentifier(ISearch search) {
        return AbstractEclipseJob.getLockIdentifier(search.getBrowserConnection()) + "_" + new StringBuffer(search.getSearchBase().getNormName()).reverse().toString();
    }

    protected static String getLockIdentifier(Object object) {
        return object.toString();
    }
}

