/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.directory.shared.ldap.schema.parsers.AttributeTypeDescription;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.IConnectionListener;
import org.apache.directory.studio.connection.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.events.BrowserConnectionUpdateEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeAttributesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReloadSchemaRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;

public class BrowserConnectionListener
implements IConnectionListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionOpened(Connection connection, StudioProgressMonitor monitor) {
        IBrowserConnection browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(connection);
        if (browserConnection != null) {
            try {
                EventRegistry.suspendEventFiringInCurrentThread();
                BrowserConnectionListener.openBrowserConnection(browserConnection, monitor);
                BrowserConnectionListener.setBinaryAttributes(browserConnection, monitor);
            }
            finally {
                EventRegistry.resumeEventFiringInCurrentThread();
                BrowserConnectionUpdateEvent browserConnectionUpdateEvent = new BrowserConnectionUpdateEvent(browserConnection, BrowserConnectionUpdateEvent.Detail.BROWSER_CONNECTION_OPENED);
                EventRegistry.fireBrowserConnectionUpdated(browserConnectionUpdateEvent, this);
                BrowserConnectionUpdateEvent schemaUpdateEvent = new BrowserConnectionUpdateEvent(browserConnection, BrowserConnectionUpdateEvent.Detail.SCHEMA_UPDATED);
                EventRegistry.fireBrowserConnectionUpdated(schemaUpdateEvent, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(Connection connection, StudioProgressMonitor monitor) {
        IBrowserConnection browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(connection);
        if (browserConnection != null) {
            try {
                EventRegistry.suspendEventFiringInCurrentThread();
                browserConnection.clearCaches();
            }
            finally {
                EventRegistry.resumeEventFiringInCurrentThread();
                BrowserConnectionUpdateEvent browserConnectionUpdateEvent = new BrowserConnectionUpdateEvent(browserConnection, BrowserConnectionUpdateEvent.Detail.BROWSER_CONNECTION_CLOSED);
                EventRegistry.fireBrowserConnectionUpdated(browserConnectionUpdateEvent, this);
            }
        }
    }

    private static void openBrowserConnection(IBrowserConnection browserConnection, StudioProgressMonitor monitor) {
        ReloadSchemaRunnable.reloadSchema(false, browserConnection, monitor);
        IRootDSE rootDSE = browserConnection.getRootDSE();
        InitializeAttributesRunnable.initializeAttributes(rootDSE, monitor);
    }

    private static void setBinaryAttributes(IBrowserConnection browserConnection, StudioProgressMonitor monitor) {
        ArrayList<String> binaryAttributeNames = new ArrayList<String>();
        Schema schema = browserConnection.getSchema();
        Collection<AttributeTypeDescription> attributeTypeDescriptions = schema.getAttributeTypeDescriptions();
        for (AttributeTypeDescription atd : attributeTypeDescriptions) {
            if (!SchemaUtils.isBinary(atd, schema)) continue;
            String name = atd.getNames().isEmpty() ? atd.getNumericOid() : (String)atd.getNames().get(0);
            binaryAttributeNames.add(name);
        }
        if (browserConnection.getConnection() != null) {
            browserConnection.getConnection().getJNDIConnectionWrapper().setBinaryAttributes(binaryAttributeNames);
        }
    }
}

