/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.StudioControl;
import org.apache.directory.studio.connection.core.io.ConnectionIOException;
import org.apache.directory.studio.ldapbrowser.core.model.BookmarkParameter;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.SearchParameter;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Bookmark;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Search;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserConnectionIO {
    private static final String BROWSER_CONNECTIONS_TAG = "browserConnections";
    private static final String BROWSER_CONNECTION_TAG = "browserConnection";
    private static final String ID_TAG = "id";
    private static final String SEARCHES_TAG = "searches";
    private static final String SEARCH_PARAMETER_TAG = "searchParameter";
    private static final String NAME_TAG = "name";
    private static final String SEARCH_BASE_TAG = "searchBase";
    private static final String FILTER_TAG = "filer";
    private static final String RETURNING_ATTRIBUTES_TAG = "returningAttributes";
    private static final String RETURNING_ATTRIBUTE_TAG = "returningAttribute";
    private static final String VALUE_TAG = "value";
    private static final String SCOPE_TAG = "scope";
    private static final String TIME_LIMIT_TAG = "timeLimit";
    private static final String COUNT_LIMIT_TAG = "countLimit";
    private static final String ALIASES_DEREFERENCING_METHOD_TAG = "aliasesDereferencingMethod";
    private static final String REFERRALS_HANDLING_METHOD_TAG = "referralsHandlingMethod";
    private static final String CONTROLS_TAG = "controls";
    private static final String CONTROL_TAG = "control";
    private static final String BOOKMARKS_TAG = "bookmarks";
    private static final String BOOKMARK_PARAMETER_TAG = "bookmarkParameter";
    private static final String DN_TAG = "dn";

    public static void load(InputStream stream, Map<String, IBrowserConnection> browserConnectionMap) throws ConnectionIOException {
        SAXReader saxReader = new SAXReader();
        Document document = null;
        try {
            document = saxReader.read(stream);
        }
        catch (DocumentException e) {
            throw new ConnectionIOException(e.getMessage());
        }
        Element rootElement = document.getRootElement();
        if (!rootElement.getName().equals(BROWSER_CONNECTIONS_TAG)) {
            throw new ConnectionIOException("The file does not seem to be a valid BrowserConnections file.");
        }
        Iterator i = rootElement.elementIterator(BROWSER_CONNECTION_TAG);
        while (i.hasNext()) {
            Element browserConnectionElement = (Element)i.next();
            BrowserConnectionIO.readBrowserConnection(browserConnectionElement, browserConnectionMap);
        }
    }

    private static void readBrowserConnection(Element element, Map<String, IBrowserConnection> browserConnectionMap) throws ConnectionIOException {
        String id;
        IBrowserConnection browserConnection;
        Attribute idAttribute = element.attribute(ID_TAG);
        if (idAttribute != null && (browserConnection = browserConnectionMap.get(id = idAttribute.getValue())) != null) {
            Element bookmarksElement;
            Element searchesElement = element.element(SEARCHES_TAG);
            if (searchesElement != null) {
                Iterator i = searchesElement.elementIterator(SEARCH_PARAMETER_TAG);
                while (i.hasNext()) {
                    Element searchParameterElement = (Element)i.next();
                    SearchParameter searchParameter = BrowserConnectionIO.readSearch(searchParameterElement, browserConnection);
                    Search search = new Search(browserConnection, searchParameter);
                    browserConnection.getSearchManager().addSearch(search);
                }
            }
            if ((bookmarksElement = element.element(BOOKMARKS_TAG)) != null) {
                Iterator i = bookmarksElement.elementIterator(BOOKMARK_PARAMETER_TAG);
                while (i.hasNext()) {
                    Element bookmarkParameterElement = (Element)i.next();
                    BookmarkParameter bookmarkParameter = BrowserConnectionIO.readBookmark(bookmarkParameterElement, browserConnection);
                    Bookmark bookmark = new Bookmark(browserConnection, bookmarkParameter);
                    browserConnection.getBookmarkManager().addBookmark(bookmark);
                }
            }
        }
    }

    private static SearchParameter readSearch(Element searchParameterElement, IBrowserConnection browserConnection) throws ConnectionIOException {
        Element controlsElement;
        Attribute referralsHandlingMethodAttribute;
        Attribute aliasesDereferencingMethodAttribute;
        Attribute countLimitAttribute;
        Attribute timeLimitAttribute;
        Attribute scopeAttribute;
        Element returningAttributesElement;
        Attribute filterAttribute;
        Attribute searchBaseAttribute;
        SearchParameter searchParameter = new SearchParameter();
        Attribute nameAttribute = searchParameterElement.attribute(NAME_TAG);
        if (nameAttribute != null) {
            searchParameter.setName(nameAttribute.getValue());
        }
        if ((searchBaseAttribute = searchParameterElement.attribute(SEARCH_BASE_TAG)) != null) {
            try {
                searchParameter.setSearchBase(new LdapDN(searchBaseAttribute.getValue()));
            }
            catch (InvalidNameException e) {
                throw new ConnectionIOException("Unable to parse 'Search Base' of search '" + searchParameter.getName() + "' :" + searchBaseAttribute.getValue());
            }
        }
        if ((filterAttribute = searchParameterElement.attribute(FILTER_TAG)) != null) {
            searchParameter.setFilter(filterAttribute.getValue());
        }
        if ((returningAttributesElement = searchParameterElement.element(RETURNING_ATTRIBUTES_TAG)) != null) {
            ArrayList<String> returningAttributes = new ArrayList<String>();
            Iterator i = returningAttributesElement.elementIterator(RETURNING_ATTRIBUTE_TAG);
            while (i.hasNext()) {
                Element returningAttributeElement = (Element)i.next();
                Attribute valueAttribute = returningAttributeElement.attribute(VALUE_TAG);
                if (valueAttribute == null) continue;
                returningAttributes.add(valueAttribute.getValue());
            }
            searchParameter.setReturningAttributes(returningAttributes.toArray(new String[returningAttributes.size()]));
        }
        if ((scopeAttribute = searchParameterElement.attribute(SCOPE_TAG)) != null) {
            try {
                searchParameter.setScope(ISearch.SearchScope.valueOf(scopeAttribute.getValue()));
            }
            catch (IllegalArgumentException e) {
                throw new ConnectionIOException("Unable to parse 'Scope' of search '" + searchParameter.getName() + "' as int value. Scope value :" + scopeAttribute.getValue());
            }
        }
        if ((timeLimitAttribute = searchParameterElement.attribute(TIME_LIMIT_TAG)) != null) {
            try {
                searchParameter.setTimeLimit(Integer.parseInt(timeLimitAttribute.getValue()));
            }
            catch (NumberFormatException e) {
                throw new ConnectionIOException("Unable to parse 'Time limit' of search '" + searchParameter.getName() + "' as int value. Time limit value :" + timeLimitAttribute.getValue());
            }
        }
        if ((countLimitAttribute = searchParameterElement.attribute(COUNT_LIMIT_TAG)) != null) {
            try {
                searchParameter.setCountLimit(Integer.parseInt(countLimitAttribute.getValue()));
            }
            catch (NumberFormatException e) {
                throw new ConnectionIOException("Unable to parse 'Count limit' of search '" + searchParameter.getName() + "' as int value. Count limit value :" + countLimitAttribute.getValue());
            }
        }
        if ((aliasesDereferencingMethodAttribute = searchParameterElement.attribute(ALIASES_DEREFERENCING_METHOD_TAG)) != null) {
            try {
                searchParameter.setAliasesDereferencingMethod(Connection.AliasDereferencingMethod.valueOf((String)aliasesDereferencingMethodAttribute.getValue()));
            }
            catch (IllegalArgumentException e) {
                throw new ConnectionIOException("Unable to parse 'Aliases Dereferencing Method' of search '" + searchParameter.getName() + "' as int value. Aliases Dereferencing Method value :" + aliasesDereferencingMethodAttribute.getValue());
            }
        }
        if ((referralsHandlingMethodAttribute = searchParameterElement.attribute(REFERRALS_HANDLING_METHOD_TAG)) != null) {
            try {
                searchParameter.setReferralsHandlingMethod(Connection.ReferralHandlingMethod.valueOf((String)referralsHandlingMethodAttribute.getValue()));
            }
            catch (IllegalArgumentException e) {
                throw new ConnectionIOException("Unable to parse 'Referrals Handling Method' of search '" + searchParameter.getName() + "' as int value. Referrals Handling Method value :" + referralsHandlingMethodAttribute.getValue());
            }
        }
        if ((controlsElement = searchParameterElement.element(CONTROLS_TAG)) != null) {
            Iterator i = controlsElement.elementIterator(CONTROL_TAG);
            while (i.hasNext()) {
                Element controlElement = (Element)i.next();
                Attribute valueAttribute = controlElement.attribute(VALUE_TAG);
                if (valueAttribute == null) continue;
                byte[] bytes = Base64.decode((char[])valueAttribute.getValue().toCharArray());
                ByteArrayInputStream bais = null;
                ObjectInputStream ois = null;
                try {
                    bais = new ByteArrayInputStream(bytes);
                    ois = new ObjectInputStream(bais);
                    StudioControl control = (StudioControl)ois.readObject();
                    searchParameter.getControls().add(control);
                    ois.close();
                }
                catch (Exception e) {
                    throw new ConnectionIOException("Unable to parse 'Control' of search '" + searchParameter.getName() + "'. Control value :" + valueAttribute.getValue());
                }
            }
        }
        return searchParameter;
    }

    private static BookmarkParameter readBookmark(Element bookmarkParameterElement, IBrowserConnection browserConnection) throws ConnectionIOException {
        Attribute dnAttribute;
        BookmarkParameter bookmarkParameter = new BookmarkParameter();
        Attribute nameAttribute = bookmarkParameterElement.attribute(NAME_TAG);
        if (nameAttribute != null) {
            bookmarkParameter.setName(nameAttribute.getValue());
        }
        if ((dnAttribute = bookmarkParameterElement.attribute(DN_TAG)) != null) {
            try {
                bookmarkParameter.setDn(new LdapDN(dnAttribute.getValue()));
            }
            catch (InvalidNameException e) {
                throw new ConnectionIOException("Unable to parse 'DN' of bookmark '" + bookmarkParameter.getName() + "' :" + dnAttribute.getValue());
            }
        }
        return bookmarkParameter;
    }

    public static void save(OutputStream stream, Map<String, IBrowserConnection> browserConnectionMap) throws IOException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(BROWSER_CONNECTIONS_TAG);
        if (browserConnectionMap != null) {
            for (IBrowserConnection browserConnection : browserConnectionMap.values()) {
                BrowserConnectionIO.writeBrowserConnection(root, browserConnection);
            }
        }
        OutputFormat outformat = OutputFormat.createPrettyPrint();
        outformat.setEncoding("UTF-8");
        XMLWriter writer = new XMLWriter(stream, outformat);
        writer.write(document);
        writer.flush();
    }

    private static void writeBrowserConnection(Element parent, IBrowserConnection browserConnection) throws IOException {
        IBookmark[] bookmarks;
        Element browserConnectionElement = parent.addElement(BROWSER_CONNECTION_TAG);
        browserConnectionElement.addAttribute(ID_TAG, browserConnection.getConnection().getId());
        Element searchesElement = browserConnectionElement.addElement(SEARCHES_TAG);
        List<ISearch> searches = browserConnection.getSearchManager().getSearches();
        for (ISearch search : searches) {
            Element searchParameterElement = searchesElement.addElement(SEARCH_PARAMETER_TAG);
            BrowserConnectionIO.writeSearch(searchParameterElement, search.getSearchParameter());
        }
        Element bookmarksElement = browserConnectionElement.addElement(BOOKMARKS_TAG);
        for (IBookmark bookmark : bookmarks = browserConnection.getBookmarkManager().getBookmarks()) {
            Element bookmarkParameterElement = bookmarksElement.addElement(BOOKMARK_PARAMETER_TAG);
            BrowserConnectionIO.writeBookmark(bookmarkParameterElement, bookmark.getBookmarkParameter());
        }
    }

    private static void writeSearch(Element searchParameterElement, SearchParameter searchParameter) throws IOException {
        searchParameterElement.addAttribute(NAME_TAG, searchParameter.getName());
        String searchBase = searchParameter.getSearchBase() != null ? searchParameter.getSearchBase().getUpName() : "";
        searchParameterElement.addAttribute(SEARCH_BASE_TAG, searchBase);
        searchParameterElement.addAttribute(FILTER_TAG, searchParameter.getFilter());
        Element returningAttributesElement = searchParameterElement.addElement(RETURNING_ATTRIBUTES_TAG);
        for (String ra : searchParameter.getReturningAttributes()) {
            Element raElement = returningAttributesElement.addElement(RETURNING_ATTRIBUTE_TAG);
            raElement.addAttribute(VALUE_TAG, ra);
        }
        searchParameterElement.addAttribute(SCOPE_TAG, searchParameter.getScope().toString());
        searchParameterElement.addAttribute(TIME_LIMIT_TAG, "" + searchParameter.getTimeLimit());
        searchParameterElement.addAttribute(COUNT_LIMIT_TAG, "" + searchParameter.getCountLimit());
        searchParameterElement.addAttribute(ALIASES_DEREFERENCING_METHOD_TAG, searchParameter.getAliasesDereferencingMethod().toString());
        searchParameterElement.addAttribute(REFERRALS_HANDLING_METHOD_TAG, searchParameter.getReferralsHandlingMethod().toString());
        Element controlsElement = searchParameterElement.addElement(CONTROLS_TAG);
        for (StudioControl studioControl : searchParameter.getControls()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(studioControl);
            oos.close();
            byte[] bytes = baos.toByteArray();
            String controlsValue = new String(Base64.encode((byte[])bytes));
            Element controlElement = controlsElement.addElement(CONTROL_TAG);
            controlElement.addAttribute(VALUE_TAG, controlsValue);
        }
    }

    private static void writeBookmark(Element bookmarkParameterElement, BookmarkParameter bookmarkParameter) {
        bookmarkParameterElement.addAttribute(NAME_TAG, bookmarkParameter.getName());
        String dn = bookmarkParameter.getDn() != null ? bookmarkParameter.getDn().getUpName() : "";
        bookmarkParameterElement.addAttribute(DN_TAG, dn);
    }
}

