/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredElementTreeSelectionDialog
extends ElementTreeSelectionDialog {
    private String fInitialFilter = null;
    private boolean fIsDeepFiltering;

    public FilteredElementTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        this(parent, labelProvider, contentProvider, true);
    }

    public FilteredElementTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, boolean isDeepFiltering) {
        super(parent, labelProvider, contentProvider);
        this.fIsDeepFiltering = isDeepFiltering;
    }

    public void setInitialFilter(String initialFilter) {
        this.fInitialFilter = initialFilter;
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        FilteredTreeWithFilter tree = new FilteredTreeWithFilter(parent, style, this.fInitialFilter, this.fIsDeepFiltering);
        tree.setLayoutData(new GridData(1808));
        FilteredElementTreeSelectionDialog.applyDialogFont((Control)tree);
        TreeViewer viewer = tree.getViewer();
        SWTUtil.setAccessibilityText(viewer.getControl(), Strings.removeMnemonicIndicator(this.getMessage()));
        return viewer;
    }

    private static class FilteredTreeWithFilter
    extends FilteredTree {
        private boolean narrowingDown;
        private String previousFilterText;

        public FilteredTreeWithFilter(Composite parent, int treeStyle, String initialFilter, boolean deepFiltering) {
            super(parent, treeStyle, (PatternFilter)new MultiplePatternFilter(deepFiltering), true);
            if (initialFilter != null) {
                this.setFilterText(initialFilter);
                this.textChanged();
            }
        }

        protected void textChanged() {
            this.narrowingDown = this.previousFilterText == null || this.getFilterString().startsWith(this.previousFilterText);
            this.previousFilterText = this.getFilterString();
            super.textChanged();
        }

        protected WorkbenchJob doCreateRefreshJob() {
            return new WorkbenchJob(this, "Refresh Filter"){
                final /* synthetic */ FilteredTreeWithFilter this$1;
                {
                    this.this$1 = filteredTreeWithFilter;
                }

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    boolean initial;
                    if (FilteredTreeWithFilter.access$0(this.this$1).getControl().isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    String text = FilteredTreeWithFilter.access$1(this.this$1);
                    if (text == null) {
                        return Status.OK_STATUS;
                    }
                    boolean bl = initial = FilteredTreeWithFilter.access$2(this.this$1) != null && FilteredTreeWithFilter.access$2(this.this$1).equals(text);
                    if (initial) {
                        this.this$1.getPatternFilter().setPattern(null);
                    } else {
                        this.this$1.getPatternFilter().setPattern(text);
                    }
                    Composite redrawFalseControl = FilteredTreeWithFilter.access$3(this.this$1) != null ? FilteredTreeWithFilter.access$3(this.this$1) : FilteredTreeWithFilter.access$0(this.this$1).getControl();
                    try {
                        redrawFalseControl.setRedraw(false);
                        if (!FilteredTreeWithFilter.access$4(this.this$1)) {
                            TreeItem[] is = FilteredTreeWithFilter.access$0(this.this$1).getTree().getItems();
                            int i = 0;
                            while (i < is.length) {
                                TreeItem item = is[i];
                                if (item.getExpanded()) {
                                    FilteredTreeWithFilter.access$0(this.this$1).setExpandedState(item.getData(), false);
                                }
                                ++i;
                            }
                        }
                        FilteredTreeWithFilter.access$0(this.this$1).refresh(true);
                        FilteredTreeWithFilter.access$5(this.this$1, text.length() > 0 && !initial);
                    }
                    finally {
                        TreeItem[] items = this.this$1.getViewer().getTree().getItems();
                        if (items.length > 0 && this.this$1.getViewer().getTree().getSelectionCount() == 0) {
                            FilteredTreeWithFilter.access$0(this.this$1).getTree().setTopItem(items[0]);
                        }
                        redrawFalseControl.setRedraw(true);
                    }
                    return Status.OK_STATUS;
                }
            };
        }

        static /* synthetic */ TreeViewer access$0(FilteredTreeWithFilter filteredTreeWithFilter) {
            return filteredTreeWithFilter.treeViewer;
        }

        static /* synthetic */ String access$1(FilteredTreeWithFilter filteredTreeWithFilter) {
            return filteredTreeWithFilter.getFilterString();
        }

        static /* synthetic */ String access$2(FilteredTreeWithFilter filteredTreeWithFilter) {
            return filteredTreeWithFilter.initialText;
        }

        static /* synthetic */ Composite access$3(FilteredTreeWithFilter filteredTreeWithFilter) {
            return filteredTreeWithFilter.treeComposite;
        }

        static /* synthetic */ boolean access$4(FilteredTreeWithFilter filteredTreeWithFilter) {
            return filteredTreeWithFilter.narrowingDown;
        }

        static /* synthetic */ void access$5(FilteredTreeWithFilter filteredTreeWithFilter, boolean bl) {
            filteredTreeWithFilter.updateToolbar(bl);
        }
    }

    private static class MultiplePatternFilter
    extends PatternFilter {
        private StringMatcher[] fMatchers;
        private final boolean fIsDeepFiltering;

        public MultiplePatternFilter(boolean deepFiltering) {
            this.fIsDeepFiltering = deepFiltering;
        }

        public void setPattern(String patternString) {
            super.setPattern(patternString);
            this.fMatchers = null;
            if (patternString != null && patternString.length() > 0) {
                ArrayList<StringMatcher> res = new ArrayList<StringMatcher>();
                StringTokenizer tok = new StringTokenizer(patternString, ",;");
                this.fMatchers = new StringMatcher[tok.countTokens()];
                int i = 0;
                while (i < this.fMatchers.length) {
                    String token = tok.nextToken().trim();
                    if (token.length() > 0) {
                        res.add(new StringMatcher(String.valueOf(token) + '*', true, false));
                    }
                    ++i;
                }
                if (!res.isEmpty()) {
                    this.fMatchers = res.toArray(new StringMatcher[res.size()]);
                }
            }
        }

        protected boolean wordMatches(String text) {
            if (text != null) {
                if (this.fMatchers == null || this.fMatchers.length == 0) {
                    return true;
                }
                int i = 0;
                while (i < this.fMatchers.length) {
                    if (this.fMatchers[i].match(text)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public boolean isElementVisible(Viewer viewer, Object element) {
            boolean hasChildren = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).hasChildren(element);
            if (this.fIsDeepFiltering) {
                if (!super.isElementVisible(viewer, element)) {
                    return false;
                }
                ViewerFilter[] filters = ((TreeViewer)viewer).getFilters();
                int i = 0;
                while (i < filters.length) {
                    if (filters[i] != this && !filters[i].select(viewer, element, element)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return hasChildren || this.isLeafMatch(viewer, element);
        }
    }
}

