/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class HierarchyLabelProvider
extends AppearanceAwareLabelProvider {
    private Color fSpecialColor;
    private ViewerFilter fFilter;
    private TypeHierarchyLifeCycle fHierarchy;
    static /* synthetic */ Class class$0;

    public HierarchyLabelProvider(TypeHierarchyLifeCycle lifeCycle) {
        super(317758862524457L, 1);
        this.fHierarchy = lifeCycle;
        this.fFilter = null;
    }

    public ViewerFilter getFilter() {
        return this.fFilter;
    }

    public void setFilter(ViewerFilter filter) {
        this.fFilter = filter;
    }

    protected boolean isDifferentScope(IType type) {
        if (this.fFilter != null && !this.fFilter.select(null, null, (Object)type)) {
            return true;
        }
        IJavaElement input = this.fHierarchy.getInputElement();
        if (input == null || input.getElementType() == 7) {
            return false;
        }
        IJavaElement parent = type.getAncestor(input.getElementType());
        return !(input.getElementType() == 4 ? parent == null || parent.getElementName().equals(input.getElementName()) : input.equals(parent));
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof IType) {
            Object desc = this.getTypeImageDescriptor((IType)element);
            if (desc != null) {
                if (element.equals(this.fHierarchy.getInputElement())) {
                    desc = new FocusDescriptor((ImageDescriptor)desc);
                }
                result = JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
            }
        } else {
            result = this.fImageLabelProvider.getImageLabel(element, this.evaluateImageFlags(element));
        }
        return this.decorateImage(result, element);
    }

    private ImageDescriptor getTypeImageDescriptor(IType type) {
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        if (hierarchy == null) {
            return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CLASS, 0, JavaElementImageProvider.BIG_SIZE);
        }
        int flags = hierarchy.getCachedFlags(type);
        if (flags == -1) {
            return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CLASS, 0, JavaElementImageProvider.BIG_SIZE);
        }
        boolean isInterface = Flags.isInterface((int)flags);
        IType declaringType = type.getDeclaringType();
        boolean isInner = declaringType != null;
        boolean isInInterfaceOrAnnotation = false;
        if (isInner) {
            int declaringTypeFlags = hierarchy.getCachedFlags(declaringType);
            if (declaringTypeFlags != -1) {
                isInInterfaceOrAnnotation = Flags.isInterface((int)declaringTypeFlags);
            } else {
                try {
                    isInInterfaceOrAnnotation = declaringType.isInterface();
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        ImageDescriptor desc = JavaElementImageProvider.getTypeImageDescriptor(isInner, isInInterfaceOrAnnotation, flags, this.isDifferentScope(type));
        int adornmentFlags = 0;
        if (Flags.isFinal((int)flags)) {
            adornmentFlags |= 2;
        }
        if (Flags.isAbstract((int)flags) && !isInterface) {
            adornmentFlags |= 1;
        }
        if (Flags.isStatic((int)flags)) {
            adornmentFlags |= 8;
        }
        if (Flags.isDeprecated((int)flags)) {
            adornmentFlags |= 0x400;
        }
        return new JavaElementImageDescriptor(desc, adornmentFlags, JavaElementImageProvider.BIG_SIZE);
    }

    public Color getForeground(Object element) {
        if (element instanceof IMethod) {
            if (this.fSpecialColor == null) {
                this.fSpecialColor = Display.getCurrent().getSystemColor(10);
            }
            return this.fSpecialColor;
        }
        if (element instanceof IType && this.isDifferentScope((IType)element)) {
            return JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
        }
        return null;
    }

    private static class FocusDescriptor
    extends CompositeImageDescriptor {
        private ImageDescriptor fBase;

        public FocusDescriptor(ImageDescriptor base) {
            this.fBase = base;
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.getImageData(this.fBase), 0, 0);
            this.drawImage(this.getImageData(JavaPluginImages.DESC_OVR_FOCUS), 0, 0);
        }

        private ImageData getImageData(ImageDescriptor descriptor) {
            ImageData data = descriptor.getImageData();
            if (data == null) {
                data = DEFAULT_IMAGE_DATA;
                JavaPlugin.logErrorMessage("Image data not available: " + descriptor.toString());
            }
            return data;
        }

        protected Point getSize() {
            return JavaElementImageProvider.BIG_SIZE;
        }

        public int hashCode() {
            return this.fBase.hashCode();
        }

        public boolean equals(Object object) {
            if (object != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.internal.ui.typehierarchy.HierarchyLabelProvider$FocusDescriptor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(object.getClass()) && ((FocusDescriptor)((Object)object)).fBase.equals(this.fBase)) {
                    return true;
                }
            }
            return false;
        }
    }
}

